/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.pref2;

import android.content.SharedPreferences;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Process;
import android.util.Log;
import com.yy.mobile.pref2.XmlUtilsModify;
import com.yy.mobile.util.taskexecutor.HandlEx;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import org.xmlpull.v1.XmlPullParserException;

public final class SharedPreferencesImpl
implements SharedPreferences {
    public static final int MODE_MULTI_PROCESS = 4;
    private static final String TAG = "SharedPreferencesImpl";
    private static final boolean DEBUG = false;
    private static final Object mContent = new Object();
    static HandlerThread sSharedPreferencesThread;
    static HandlEx sSharedPreferencesHandler;
    private static ArrayList<YYTaskExecutor.RunnableEx> mBackupRunnableList;
    private final File mFile;
    private final File mTempFile;
    private final File mBackupFile;
    private final int mMode;
    private final Object mWritingToDiskLock = new Object();
    private final WeakHashMap<SharedPreferences.OnSharedPreferenceChangeListener, Object> mListeners = new WeakHashMap();
    private Map<String, Object> mMap;
    private int mDiskWritesInFlight = 0;
    private boolean mLoaded = false;
    private long mStatTimestamp;
    private long mStatSize;
    private EditorImpl mEditor = new EditorImpl();
    private Handler mMainHandler = new Handler(Looper.getMainLooper());
    private YYTaskExecutor.RunnableEx mBackupRunnable = new YYTaskExecutor.RunnableEx(){

        @Override
        public void run() {
            MemoryCommitResult mcr = (MemoryCommitResult)this.getArg();
            if (mcr == null) {
                return;
            }
            try {
                File bakFile = new File(SharedPreferencesImpl.this.mBackupFile.getPath() + ".tmp");
                FileOutputStream str = SharedPreferencesImpl.createFileOutputStream(bakFile);
                if (str == null) {
                    return;
                }
                XmlUtilsModify.writeMapXml(mcr.mapToWriteToDisk, str);
                try {
                    str.getFD().sync();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                str.close();
                if (SharedPreferencesImpl.this.mBackupFile.exists()) {
                    SharedPreferencesImpl.this.mBackupFile.delete();
                }
                bakFile.renameTo(SharedPreferencesImpl.this.mBackupFile);
                SharedPreferencesImpl.setFilePermissionsFromMode(SharedPreferencesImpl.this.mBackupFile.getPath(), SharedPreferencesImpl.this.mMode, 0);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    };

    public SharedPreferencesImpl(File file, int mode) {
        this.mFile = file;
        this.mTempFile = SharedPreferencesImpl.makeTempFile(file);
        this.mBackupFile = SharedPreferencesImpl.makeBackupFile(file);
        this.mMode = mode;
        this.mLoaded = false;
        this.mMap = null;
        this.startLoadFromDisk();
    }

    private static File makeTempFile(File prefsFile) {
        return new File(prefsFile.getPath() + ".tmp");
    }

    private static File makeBackupFile(File prefsFile) {
        return new File(prefsFile.getPath() + ".bak");
    }

    private static FileOutputStream createFileOutputStream(File file) {
        FileOutputStream str = null;
        try {
            str = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            File parent = file.getParentFile();
            if (parent != null && !parent.mkdir()) {
                Log.e((String)TAG, (String)("Couldn't create directory for SharedPreferences file " + file));
                return null;
            }
            try {
                str = new FileOutputStream(file);
            }
            catch (FileNotFoundException e2) {
                Log.e((String)TAG, (String)("Couldn't create SharedPreferences file " + file), (Throwable)e2);
            }
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backupAllData() {
        ArrayList<YYTaskExecutor.RunnableEx> arrayList = mBackupRunnableList;
        synchronized (arrayList) {
            for (YYTaskExecutor.RunnableEx r : mBackupRunnableList) {
                if (r.getArg() == null) continue;
                YYTaskExecutor.execute((Runnable)r, YYTaskExecutor.TaskType.IO);
            }
            mBackupRunnableList.clear();
        }
    }

    private static void setFilePermissionsFromMode(String name, int mode, int extraPermissions) {
    }

    private static synchronized HandlEx getSharedPreferencesThread() {
        if (sSharedPreferencesHandler == null) {
            sSharedPreferencesThread = new HandlerThread("sSharedPreferencesHandler", 0);
            sSharedPreferencesThread.start();
            sSharedPreferencesHandler = new HandlEx("sSharedPreferencesHandler", sSharedPreferencesThread.getLooper());
        }
        return sSharedPreferencesHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoadFromDisk() {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.mLoaded = false;
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Process.setThreadPriority((int)0);
                SharedPreferencesImpl sharedPreferencesImpl = SharedPreferencesImpl.this;
                synchronized (sharedPreferencesImpl) {
                    SharedPreferencesImpl.this.loadFromDiskLocked();
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoadFromDiskRightNow() {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.mLoaded = false;
        }
        this.loadFromDiskLocked();
    }

    private void loadFromDiskLocked() {
        if (this.mLoaded) {
            return;
        }
        if (this.mTempFile.exists()) {
            this.mFile.delete();
            this.mTempFile.renameTo(this.mFile);
        }
        boolean error = false;
        Map map = null;
        long statTimestamp = 0L;
        long statSize = 0L;
        try {
            statTimestamp = this.mFile.lastModified();
            statSize = this.mFile.length();
            map = this.readFromXml(this.mFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((map == null || map.size() == 0) && this.mTempFile.exists()) {
            map = this.readFromXml(this.mTempFile);
        }
        if (!(this.mMap != null && this.mMap.size() != 0 || map != null && map.size() != 0)) {
            try {
                map = this.readFromXml(this.mBackupFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mLoaded = true;
        if (map != null && map.size() > 0) {
            this.mMap = map;
            this.mStatTimestamp = statTimestamp;
            this.mStatSize = statSize;
        } else if (this.mMap == null) {
            this.mMap = new HashMap<String, Object>();
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map readFromXml(File file) {
        HashMap map = null;
        if (file.canRead()) {
            BufferedInputStream str = null;
            try {
                str = new BufferedInputStream(new FileInputStream(file), 16384);
                map = XmlUtilsModify.readMapXml(str);
            }
            catch (XmlPullParserException e) {
                Log.w((String)TAG, (String)"getSharedPreferences", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                Log.w((String)TAG, (String)"getSharedPreferences", (Throwable)e);
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"getSharedPreferences", (Throwable)e);
            }
            finally {
                try {
                    if (str != null) {
                        str.close();
                    }
                }
                catch (IOException e) {
                    Log.w((String)TAG, (String)"getSharedPreferences", (Throwable)e);
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startReloadIfChangedUnexpectedlyRightNow() {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            if (!this.hasFileChangedUnexpectedly()) {
                return false;
            }
            this.startLoadFromDiskRightNow();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasFileChangedUnexpectedly() {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            if (this.mDiskWritesInFlight > 0) {
                return false;
            }
        }
        sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            if (this.mStatTimestamp == 0L) {
                return false;
            }
            boolean ret = false;
            try {
                ret = this.mStatTimestamp != this.mFile.lastModified() || this.mStatSize != this.mFile.length();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.mListeners.put(listener, mContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.mListeners.remove(listener);
        }
    }

    private void awaitLoadedLocked() {
        while (!this.mLoaded) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ?> getAll() {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.startReloadIfChangedUnexpectedlyRightNow();
            this.awaitLoadedLocked();
            return new HashMap<String, Object>(this.mMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key, String defValue) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.startReloadIfChangedUnexpectedlyRightNow();
            this.awaitLoadedLocked();
            Object o = this.mMap.get(key);
            String v = null;
            if (o instanceof String) {
                v = (String)o;
            }
            return v != null ? v : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getStringSet(String key, Set<String> defValues) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.startReloadIfChangedUnexpectedlyRightNow();
            this.awaitLoadedLocked();
            Object o = this.mMap.get(key);
            Set<String> v = null;
            if (o instanceof Set) {
                v = (Set<String>)o;
            }
            return v != null ? v : defValues;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String key, int defValue) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.startReloadIfChangedUnexpectedlyRightNow();
            this.awaitLoadedLocked();
            Object o = this.mMap.get(key);
            Integer v = null;
            if (o instanceof Integer) {
                v = (Integer)o;
            }
            return v != null ? v : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(String key, long defValue) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.startReloadIfChangedUnexpectedlyRightNow();
            this.awaitLoadedLocked();
            Object o = this.mMap.get(key);
            Long v = null;
            if (o instanceof Long) {
                v = (Long)o;
            }
            return v != null ? v : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(String key, float defValue) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.startReloadIfChangedUnexpectedlyRightNow();
            this.awaitLoadedLocked();
            Object o = this.mMap.get(key);
            Float v = null;
            if (o instanceof Float) {
                v = (Float)o;
            }
            return v != null ? v.floatValue() : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String key, boolean defValue) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.startReloadIfChangedUnexpectedlyRightNow();
            this.awaitLoadedLocked();
            Object o = this.mMap.get(key);
            Boolean v = null;
            if (o instanceof Boolean) {
                v = (Boolean)o;
            }
            return v != null ? v : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String key) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.startReloadIfChangedUnexpectedlyRightNow();
            this.awaitLoadedLocked();
            return this.mMap.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedPreferences.Editor edit() {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.awaitLoadedLocked();
            return this.mEditor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueDiskWrite(final MemoryCommitResult mcr, final Runnable postWriteRunnable, final EditorImpl editor) {
        boolean isFromSyncCommit;
        Runnable writeToDiskRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = SharedPreferencesImpl.this.mWritingToDiskLock;
                synchronized (object) {
                    if ((SharedPreferencesImpl.this.mMode & 4) != 0 && SharedPreferencesImpl.this.startReloadIfChangedUnexpectedlyRightNow()) {
                        SharedPreferencesImpl sharedPreferencesImpl = SharedPreferencesImpl.this;
                        synchronized (sharedPreferencesImpl) {
                            mcr.mapToWriteToDisk = new HashMap(SharedPreferencesImpl.this.mMap);
                        }
                        editor.mergeModify(mcr);
                    }
                    SharedPreferencesImpl.this.writeToFile(mcr);
                }
                object = SharedPreferencesImpl.this;
                synchronized (object) {
                    SharedPreferencesImpl.this.mDiskWritesInFlight--;
                }
                if (postWriteRunnable != null) {
                    postWriteRunnable.run();
                }
            }
        };
        boolean bl = isFromSyncCommit = postWriteRunnable == null;
        if (isFromSyncCommit) {
            boolean wasEmpty = false;
            SharedPreferencesImpl sharedPreferencesImpl = this;
            synchronized (sharedPreferencesImpl) {
                wasEmpty = this.mDiskWritesInFlight == 1;
            }
            if (wasEmpty) {
                writeToDiskRunnable.run();
                return;
            }
        }
        SharedPreferencesImpl.getSharedPreferencesThread().post(writeToDiskRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(MemoryCommitResult mcr) {
        if (this.mFile.exists()) {
            if (!mcr.changesMade) {
                mcr.setDiskWriteResult(true);
                return;
            }
            if (!this.mTempFile.exists()) {
                if (!this.mFile.renameTo(this.mTempFile)) {
                    Log.e((String)TAG, (String)("Couldn't rename file " + this.mFile + " to backup file " + this.mTempFile));
                    mcr.setDiskWriteResult(false);
                    return;
                }
            } else {
                this.mFile.delete();
            }
        }
        try {
            Object object;
            FileOutputStream str = SharedPreferencesImpl.createFileOutputStream(this.mFile);
            if (str == null) {
                mcr.setDiskWriteResult(false);
                return;
            }
            XmlUtilsModify.writeMapXml(mcr.mapToWriteToDisk, str);
            try {
                str.getFD().sync();
            }
            catch (Exception exception) {
                // empty catch block
            }
            str.close();
            SharedPreferencesImpl.setFilePermissionsFromMode(this.mFile.getPath(), this.mMode, 0);
            try {
                object = this;
                synchronized (object) {
                    this.mStatTimestamp = this.mFile.lastModified();
                    this.mStatSize = this.mFile.length();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mTempFile.delete();
            mcr.setDiskWriteResult(true);
            if (mcr.mapToWriteToDisk == this.mMap) {
                mcr.mapToWriteToDisk = new HashMap((HashMap)mcr.mapToWriteToDisk);
            }
            this.mBackupRunnable.setArg(mcr);
            object = mBackupRunnableList;
            synchronized (object) {
                if (!mBackupRunnableList.contains(this.mBackupRunnable)) {
                    mBackupRunnableList.add(this.mBackupRunnable);
                }
            }
            return;
        }
        catch (XmlPullParserException e) {
            Log.w((String)TAG, (String)"writeToFile: Got exception:", (Throwable)e);
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"writeToFile: Got exception:", (Throwable)e);
        }
        if (this.mFile.exists() && !this.mFile.delete()) {
            Log.e((String)TAG, (String)("Couldn't clean up partially-written file " + this.mFile));
        }
        mcr.setDiskWriteResult(false);
    }

    static {
        mBackupRunnableList = new ArrayList();
    }

    public final class EditorImpl
    implements SharedPreferences.Editor {
        private final Map<String, Object> mModified = new HashMap<String, Object>();
        private boolean mClear = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor putString(String key, String value) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.mModified.put(key, value);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor putStringSet(String key, Set<String> values) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.mModified.put(key, values == null ? null : new HashSet<String>(values));
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor putInt(String key, int value) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.mModified.put(key, value);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor putLong(String key, long value) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.mModified.put(key, value);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor putFloat(String key, float value) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.mModified.put(key, Float.valueOf(value));
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor putBoolean(String key, boolean value) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.mModified.put(key, value);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor remove(String key) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.mModified.put(key, this);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor clear() {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.mClear = true;
                return this;
            }
        }

        public void apply() {
            final MemoryCommitResult mcr = this.commitToMemory();
            Runnable postWriteRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        mcr.writtenToDiskLatch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            SharedPreferencesImpl.this.enqueueDiskWrite(mcr, postWriteRunnable, this);
            this.notifyListeners(mcr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MemoryCommitResult commitToMemory() {
            MemoryCommitResult mcr = new MemoryCommitResult();
            SharedPreferencesImpl sharedPreferencesImpl = SharedPreferencesImpl.this;
            synchronized (sharedPreferencesImpl) {
                if (SharedPreferencesImpl.this.mDiskWritesInFlight > 0) {
                    SharedPreferencesImpl.this.mMap = new HashMap(SharedPreferencesImpl.this.mMap);
                }
                mcr.mapToWriteToDisk = SharedPreferencesImpl.this.mMap;
                SharedPreferencesImpl.this.mDiskWritesInFlight++;
                this.mergeModify(mcr);
            }
            return mcr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mergeModify(MemoryCommitResult mcr) {
            SharedPreferencesImpl sharedPreferencesImpl = SharedPreferencesImpl.this;
            synchronized (sharedPreferencesImpl) {
                EditorImpl editorImpl = this;
                synchronized (editorImpl) {
                    boolean hasListeners;
                    if (this.mClear) {
                        if (!SharedPreferencesImpl.this.mMap.isEmpty()) {
                            mcr.changesMade = true;
                            SharedPreferencesImpl.this.mMap.clear();
                            this.mModified.clear();
                        }
                        this.mClear = false;
                    }
                    boolean bl = hasListeners = SharedPreferencesImpl.this.mListeners.size() > 0;
                    if (hasListeners) {
                        mcr.keysModified = new ArrayList<String>();
                        mcr.listeners = new HashSet(SharedPreferencesImpl.this.mListeners.keySet());
                    }
                    for (Map.Entry<String, Object> e : this.mModified.entrySet()) {
                        String k = e.getKey();
                        Object v = e.getValue();
                        if (v == this) {
                            if (!SharedPreferencesImpl.this.mMap.containsKey(k)) continue;
                            SharedPreferencesImpl.this.mMap.remove(k);
                        } else {
                            Object existingValue;
                            if (SharedPreferencesImpl.this.mMap.containsKey(k) && (existingValue = SharedPreferencesImpl.this.mMap.get(k)) != null && existingValue.equals(v)) continue;
                            SharedPreferencesImpl.this.mMap.put(k, v);
                        }
                        mcr.changesMade = true;
                        if (!hasListeners) continue;
                        mcr.keysModified.add(k);
                    }
                    this.mModified.clear();
                }
            }
        }

        public boolean commit() {
            MemoryCommitResult mcr = this.commitToMemory();
            SharedPreferencesImpl.this.enqueueDiskWrite(mcr, null, this);
            try {
                mcr.writtenToDiskLatch.await();
            }
            catch (InterruptedException e) {
                return false;
            }
            this.notifyListeners(mcr);
            return mcr.writeToDiskResult;
        }

        private void notifyListeners(final MemoryCommitResult mcr) {
            if (mcr.listeners == null || mcr.keysModified == null || mcr.keysModified.size() == 0) {
                return;
            }
            if (Looper.myLooper() == Looper.getMainLooper()) {
                for (int i = mcr.keysModified.size() - 1; i >= 0; --i) {
                    String key = mcr.keysModified.get(i);
                    for (SharedPreferences.OnSharedPreferenceChangeListener listener : mcr.listeners) {
                        if (listener == null) continue;
                        listener.onSharedPreferenceChanged((SharedPreferences)SharedPreferencesImpl.this, key);
                    }
                }
            } else {
                SharedPreferencesImpl.this.mMainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        EditorImpl.this.notifyListeners(mcr);
                    }
                });
            }
        }
    }

    private static class MemoryCommitResult {
        public final CountDownLatch writtenToDiskLatch = new CountDownLatch(1);
        public boolean changesMade;
        public List<String> keysModified;
        public Set<SharedPreferences.OnSharedPreferenceChangeListener> listeners;
        public Map<?, ?> mapToWriteToDisk;
        public volatile boolean writeToDiskResult = false;

        private MemoryCommitResult() {
        }

        public void setDiskWriteResult(boolean result) {
            this.writeToDiskResult = result;
            this.writtenToDiskLatch.countDown();
        }
    }
}

