/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.mvp;

import android.arch.lifecycle.Lifecycle;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.util.Log;
import com.trello.rxlifecycle2.components.support.RxFragmentActivity;
import com.yy.mobile.mvp.MvpInnerDelegate;
import com.yy.mobile.mvp.MvpInnerDelegateCallback;
import com.yy.mobile.mvp.MvpPresenter;
import com.yy.mobile.mvp.MvpView;
import com.yy.mobile.util.SdkInitStatusRecorder;
import com.yy.mobile.util.log.MLog;
import java.util.concurrent.atomic.AtomicBoolean;

public class MvpActivity<P extends MvpPresenter<V>, V extends MvpView>
extends RxFragmentActivity
implements MvpInnerDelegateCallback<P, V>,
MvpView {
    protected P mPresenter;
    private MvpInnerDelegate<P, V> mMvpInnerDelegate;
    protected AtomicBoolean sdkInitStatus = new AtomicBoolean(true);

    @Override
    public P createPresenter() {
        if (this.mPresenter == null) {
            this.mPresenter = this.getMvpDelegate().createPresenter();
        }
        return this.mPresenter;
    }

    @Override
    @NonNull
    public P getPresenter() {
        return this.mPresenter;
    }

    @Override
    public void setPresenter(@NonNull P presenter) {
        this.mPresenter = presenter;
    }

    @Override
    @NonNull
    public V getMvpView() {
        return (V)this;
    }

    @Override
    public MvpInnerDelegate<P, V> getMvpDelegate() {
        if (this.mMvpInnerDelegate == null) {
            this.mMvpInnerDelegate = this.onCreateDelegate();
        }
        return this.mMvpInnerDelegate;
    }

    protected MvpInnerDelegate<P, V> onCreateDelegate() {
        return new MvpInnerDelegate(this);
    }

    protected void onCreate(Bundle savedInstanceState) {
        this.sdkInitStatus.set(SdkInitStatusRecorder.INSTANCE.isInstalled().get());
        if (!this.sdkInitStatus.get()) {
            try {
                super.onCreate(savedInstanceState);
                MLog.error((Object)"SdkInitStatusRecorder", "onCreate# MvpActivity sdk not init", new Object[0]);
            }
            catch (Exception e) {
                Log.e((String)"SdkInitStatusRecorder", (String)"onCreate# MvpActivity error", (Throwable)e);
            }
            finally {
                if (this.getLifecycle().getCurrentState() != Lifecycle.State.DESTROYED) {
                    this.finish();
                }
            }
            Log.e((String)"SdkInitStatusRecorder", (String)"onCreate# MvpActivity sdk not init");
            return;
        }
        super.onCreate(savedInstanceState);
        this.createPresenter();
        this.getMvpDelegate().attachView(savedInstanceState);
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (!this.sdkInitStatus.get()) {
            MLog.error((Object)"SdkInitStatusRecorder", "onNewIntent# MvpActivity sdk not init", new Object[0]);
            this.finish();
        }
    }

    protected void onStart() {
        super.onStart();
        if (this.sdkInitStatus.get()) {
            ((MvpPresenter)this.getPresenter()).onStart();
        } else {
            MLog.info("SdkInitStatusRecorder", "onStart# MvpActivity sdk not init", new Object[0]);
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.sdkInitStatus.get()) {
            ((MvpPresenter)this.getPresenter()).onPause();
        } else {
            MLog.info("SdkInitStatusRecorder", "onPause# MvpActivity sdk not init", new Object[0]);
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.sdkInitStatus.get()) {
            ((MvpPresenter)this.getPresenter()).onResume();
        } else {
            MLog.info("SdkInitStatusRecorder", "onResume# MvpActivity sdk not init", new Object[0]);
        }
    }

    protected void onStop() {
        super.onStop();
        if (this.sdkInitStatus.get()) {
            ((MvpPresenter)this.getPresenter()).onStop();
        } else {
            MLog.info("SdkInitStatusRecorder", "onStop# MvpActivity sdk not init", new Object[0]);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.sdkInitStatus.get()) {
            if (this.getPresenter() != null) {
                ((MvpPresenter)this.getPresenter()).onDestroy();
            }
            if (this.getMvpDelegate() != null) {
                this.getMvpDelegate().detach();
            }
        } else {
            MLog.info("SdkInitStatusRecorder", "onDestroy# MvpActivity sdk not init", new Object[0]);
        }
    }
}

