/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.image;

import android.widget.AbsListView;
import com.yy.mobile.imageloader.ImageLoader;

public class PauseOnScrollListener
implements AbsListView.OnScrollListener {
    private final boolean mPauseOnScroll;
    private final boolean mPauseOnFling;
    private final AbsListView.OnScrollListener mExternalListener;

    public PauseOnScrollListener(boolean pauseOnScroll, boolean pauseOnFling) {
        this(pauseOnScroll, pauseOnFling, null);
    }

    public PauseOnScrollListener(boolean pauseOnScroll, boolean pauseOnFling, AbsListView.OnScrollListener externalListener) {
        this.mPauseOnScroll = pauseOnScroll;
        this.mPauseOnFling = pauseOnFling;
        this.mExternalListener = externalListener;
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        switch (scrollState) {
            case 0: {
                ImageLoader.resumeRequests();
                break;
            }
            case 1: {
                if (!this.mPauseOnScroll) break;
                ImageLoader.pauseRequests();
                break;
            }
            case 2: {
                if (!this.mPauseOnFling) break;
                ImageLoader.pauseRequests();
                break;
            }
        }
        if (this.mExternalListener != null) {
            this.mExternalListener.onScrollStateChanged(view, scrollState);
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (this.mExternalListener != null) {
            this.mExternalListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
    }
}

