/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http.net;

import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.Request;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.ResponseData;

public class RequestMonitor
implements Runnable {
    private Request request = null;

    public RequestMonitor(Request r) {
        this.request = r;
    }

    @Override
    public void run() {
        try {
            if (this.request.isCanceled()) {
                this.request.postCancel(this.getClass().getName() + " Network discard cancelled");
                return;
            }
            ResponseData responseData = this.request.getNetwork().performRequest(this.request);
            if (responseData == null || responseData.notModified && this.request.hasHadResponseDelivered()) {
                return;
            }
            this.request.parseDataToResponse(responseData);
            this.request.markDelivered();
            this.request.postResponse();
            if (this.request.shouldCache() && this.request.getResponse().cacheEntry != null) {
                this.request.getCache().put(this.request.getKey(), this.request.getResponse().cacheEntry);
            }
        }
        catch (RequestError error) {
            this.checkTestUIThread(error);
            this.parseAndDeliverNetworkError(this.request, error);
        }
        catch (Exception error) {
            this.checkTestUIThread(error);
            this.request.postError(new RequestError(error));
        }
        catch (Error error) {
            this.checkTestUIThread(error);
            this.request.postError(new RequestError(error));
        }
    }

    private void parseAndDeliverNetworkError(Request<?> request, RequestError error) {
        request.postError(error);
    }

    private void checkTestUIThread(Throwable error) {
        if (BasicConfig.getInstance().isDebuggable() && error.getMessage() != null && error.getMessage().contains(" thread ")) {
            throw new RuntimeException(error);
        }
    }
}

