/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http.form;

import com.yy.mobile.http.ByteArrayPool;
import com.yy.mobile.http.FileUploadRequest;
import com.yy.mobile.http.HttpLog;
import com.yy.mobile.http.utils.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class RandomProgressStreamEntity {
    protected static final int BUFFER_SIZE = 2048;
    protected static final long DEFAULT_PROGRESS_PERCENT = 100L;
    protected final InputStream content;
    protected final long length;
    protected final RandomAccessFile mRaf;
    protected final long mStart;
    protected final long mEnd;
    protected boolean consumed = false;
    protected FileUploadRequest mRequest;
    protected long progressStep;
    protected long progressPercent = 100L;

    public RandomProgressStreamEntity(InputStream instream, FileUploadRequest request, File file, long start, long end) throws FileNotFoundException {
        if (instream == null) {
            throw new IllegalArgumentException("Source input stream may not be null");
        }
        this.content = instream;
        if (start < 0L) {
            throw new IllegalArgumentException("Start index could not less than 0");
        }
        if (end <= 0L) {
            throw new IllegalArgumentException("End index must be more than 0");
        }
        if (end <= start) {
            throw new IllegalArgumentException("End index could not less than start");
        }
        this.length = end - start;
        this.mRequest = request;
        this.mRaf = new RandomAccessFile(file, "rwd");
        this.mStart = start;
        this.mEnd = end;
    }

    public boolean isRepeatable() {
        return false;
    }

    public long getContentLength() {
        return this.length;
    }

    public InputStream getContent() throws IOException {
        return this.content;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        block13: {
            if (outstream == null) {
                throw new IllegalArgumentException("Output stream may not be null");
            }
            InputStream instream = this.content;
            ByteArrayPool pool = Utils.getByteArrayPool();
            byte[] buffer = pool.getBuf(2048);
            if (HttpLog.isDebug()) {
                HttpLog.d("RandomProgressStreamEntity get buffer from pool", new Object[0]);
            }
            long chunkSize = this.length / this.progressPercent;
            long progress = 0L;
            try {
                if (this.length < 0L) {
                    int l;
                    while ((l = instream.read(buffer)) != -1) {
                        outstream.write(buffer, 0, l);
                    }
                    break block13;
                }
                long remaining = this.length;
                this.mRaf.seek(this.mStart);
                while (remaining > 0L) {
                    int l = this.mRaf.read(buffer, 0, (int)Math.min(2048L, remaining));
                    if (l == -1) {
                        break;
                    }
                    outstream.write(buffer, 0, l);
                    remaining -= (long)l;
                    progress += (long)l;
                    if (!this.needProgress(l, this.length, chunkSize)) continue;
                    if (HttpLog.isDebug()) {
                        HttpLog.d("RamdomProgressStreamEntity progress=%d,total=%d", progress, this.length);
                    }
                    this.mRequest.pushProgress(progress, this.length);
                }
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                pool.returnBuf(buffer);
                this.mRaf.close();
                if (HttpLog.isDebug()) {
                    HttpLog.d("RandomProgressStreamEntity return buffer to pool", new Object[0]);
                }
            }
        }
        this.consumed = true;
    }

    public boolean isStreaming() {
        return !this.consumed;
    }

    public void consumeContent() throws IOException {
        this.consumed = true;
        this.content.close();
    }

    public boolean needProgress(long progress, long total, long chunkSize) {
        this.progressStep += progress;
        if (this.progressStep > chunkSize || progress >= total) {
            this.progressStep = 0L;
            return true;
        }
        return false;
    }
}

