/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http.dnsparser;

import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.HashSet;

public class DnsParser {
    private static String TAG = "DnsParser";
    private static volatile boolean sDnsSwitch = false;
    private static final HashSet<String> sWhiteHostSet = new HashSet();
    private static final HashSet<String> sBlackHostSet = new HashSet();
    private static final HashSet<String> sNeedConvertHostSet = new HashSet();
    private static volatile boolean sInit = false;
    private static volatile boolean sRunningInit = false;
    private static long timeout = 300000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillWhiteHostList(ArrayList<String> hostList) {
        if (hostList == null || hostList.size() <= 0) {
            return;
        }
        HashSet<String> hashSet = sWhiteHostSet;
        synchronized (hashSet) {
            sWhiteHostSet.clear();
            sWhiteHostSet.addAll(hostList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillBlackHostList(ArrayList<String> hostList) {
        if (hostList == null || hostList.size() <= 0) {
            return;
        }
        HashSet<String> hashSet = sBlackHostSet;
        synchronized (hashSet) {
            sBlackHostSet.clear();
            sBlackHostSet.addAll(hostList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(boolean dnsSwitch, ArrayList<String> whiteList, ArrayList<String> blackList) {
        MLog.info(TAG, "init dnsSwitch:" + dnsSwitch + " whiteList:" + (whiteList != null ? whiteList.toString() : "") + " blackList:" + (blackList != null ? blackList.toString() : ""), new Object[0]);
        sDnsSwitch = dnsSwitch;
        DnsParser.fillWhiteHostList(whiteList);
        DnsParser.fillBlackHostList(blackList);
        if (!dnsSwitch) {
            HashSet<String> hashSet = sNeedConvertHostSet;
            synchronized (hashSet) {
                sNeedConvertHostSet.clear();
            }
        }
    }

    public static String hostConvertToIP(String url) {
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean needsConvertOnly(String host) {
        if (host == null || host.isEmpty()) {
            return false;
        }
        HashSet<String> hashSet = sBlackHostSet;
        synchronized (hashSet) {
            if (sBlackHostSet.contains(host)) {
                return false;
            }
        }
        if (!sDnsSwitch) {
            hashSet = sWhiteHostSet;
            synchronized (hashSet) {
                for (String white : sWhiteHostSet) {
                    if (host.indexOf(white) == -1) continue;
                    return true;
                }
            }
        } else if (DnsParser.isNotIP(host)) {
            return true;
        }
        return false;
    }

    private static boolean isNotIP(String addr) {
        if (addr.length() < 7 || addr.length() > 15 || "".equals(addr)) {
            return true;
        }
        boolean isAllDigit = true;
        for (int i = 0; i < addr.length(); ++i) {
            if (addr.charAt(i) == '.' || Character.isDigit(addr.charAt(i))) continue;
            isAllDigit = false;
            break;
        }
        return !isAllDigit;
    }
}

