/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http.dns;

import android.content.Context;
import com.yy.gslbsdk.DnsResultInfo;
import com.yy.gslbsdk.GslbEvent;
import com.yy.gslbsdk.HttpDnsService;
import com.yy.gslbsdk.thread.ThreadPoolMgr;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.dns.CommonUtilsKt;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.smartdns.GSLBDnsExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GslbDns {
    private static final String Tag = "GslbDns";
    private final String accountID = "ed37610f-36c7-45db-8e2f-e615cd1e99d6";
    private HttpDnsService mHttpDnsService = null;
    private static GslbDns mInstance = null;
    private boolean enableIpv6 = false;
    public static final long E_IPSTACK_NONE = 0L;
    public static final long E_IPSTACK_IPV4 = 1L;
    public static final long E_IPSTACK_IPV6 = 2L;
    public static final long E_IPSTACK_DUAL = 3L;

    private GslbDns() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GslbDns inst() {
        if (mInstance != null) return mInstance;
        Class<GslbDns> clazz = GslbDns.class;
        synchronized (GslbDns.class) {
            if (mInstance != null) return mInstance;
            mInstance = new GslbDns();
            mInstance.initHttpDns();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public List<String> getIps(String hostname) {
        DnsResultInfo info = this.mHttpDnsService.getIpsByHost(hostname);
        if (info != null && info.mIps != null && info.mIps.length > 0) {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < info.mIps.length; ++i) {
                list.add(info.mIps[i]);
            }
            MLog.info(Tag, "hostname:" + hostname + " mDataSource:" + info.mDataSource + " mErrorCode:" + info.mErrorCode + " res.IPList:" + Arrays.asList(info.mIps), new Object[0]);
            return list;
        }
        MLog.info(Tag, "getIpsByHost error.hostname:" + hostname + " mErrorCode:" + info.mErrorCode, new Object[0]);
        return null;
    }

    public void setEnableIpv6(boolean ableIpv6) {
        this.enableIpv6 = ableIpv6;
        if (this.mHttpDnsService != null) {
            this.mHttpDnsService.setNetworkSupportV6(ableIpv6);
            if (ableIpv6) {
                this.mHttpDnsService.setEnableIpv6(ableIpv6);
            }
            MLog.info(Tag, "GslbDns_ setEnableIpv6:" + ableIpv6, new Object[0]);
        }
    }

    public boolean isEnableIpv6() {
        return this.enableIpv6;
    }

    private void initHttpDns() {
        this.mHttpDnsService = HttpDnsService.getService((Context)BasicConfig.getInstance().getAppContext(), (String)"ed37610f-36c7-45db-8e2f-e615cd1e99d6", (ThreadPoolMgr.ITaskExecutor)new GSLBDnsExecutor(), (String)"");
        this.mHttpDnsService.setLogEnabled(true);
        this.enableIpv6 = GslbDns.canEnableGslbIpv6(false);
        this.mHttpDnsService.setEnableIpv6(this.enableIpv6);
        this.mHttpDnsService.setHttpsEnable(2);
        this.mHttpDnsService.setGslbEventMessager(new GslbEvent.GslbEventListener(){

            public void onMessage(String s) {
            }
        });
    }

    public static boolean canEnableGslbIpv6(boolean config) {
        boolean isDoubleStack = CommonUtilsKt.INSTANCE.isDoubleStack(false);
        boolean isIPv6Only = CommonUtilsKt.INSTANCE.isIpv6Only(false);
        boolean isIPv4Only = CommonUtilsKt.INSTANCE.isIpv4Only(false);
        if (isIPv4Only) {
            MLog.info(Tag, "canEnableGslbIpv6 config = " + config + "isIPv4Only is true, , isDoubleStack = " + isDoubleStack + ", isIPv6Only = " + isIPv6Only, new Object[0]);
            return false;
        }
        MLog.info(Tag, "canEnableGslbIpv6 config = " + config + ", isDoubleStack = " + isDoubleStack + ", isIPv6Only = " + isIPv6Only, new Object[0]);
        return config && isDoubleStack || isIPv6Only;
    }

    public void updateIpv6ConfigAsync(boolean config, CommonUtilsKt.IP ip) {
        MLog.info(Tag, "updateIpv6ConfigAsync: current stack is %s, config = %b", new Object[]{ip, config});
        if (config && ip == CommonUtilsKt.IP.IPV6_V4 || ip == CommonUtilsKt.IP.IPV6_ONLY) {
            GslbDns.inst().setEnableIpv6(true);
        } else {
            GslbDns.inst().setEnableIpv6(false);
        }
    }

    public void setBackgroundModel(Boolean isBackground) {
        this.mHttpDnsService.setBackgroundModel(isBackground.booleanValue());
    }
}

