/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import android.os.SystemClock;
import com.yy.mobile.http.AuthFailureError;
import com.yy.mobile.http.BaseNetwork;
import com.yy.mobile.http.DownloadRequest;
import com.yy.mobile.http.HttpLog;
import com.yy.mobile.http.Request;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.ResponseData;
import com.yy.mobile.http.ServerError;
import com.yy.mobile.http.TimeoutError;
import com.yy.mobile.http.error.NetworkError;
import com.yy.mobile.http.error.NoConnectionError;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import okhttp3.Response;
import org.apache.http.conn.ConnectTimeoutException;

public class HeaderNetwork
extends BaseNetwork {
    private static final long DEFAULT_PROGRESS_PERCENT = 100L;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final String TMP_SURFIX = ".tmp";
    protected String mDownloadFilePath;
    protected String mDownloadFileTempPath;
    protected DownloadRequest mDownloadRequest;

    @Override
    public ResponseData performRequest(Request<?> request) throws RequestError {
        long requestStart = SystemClock.elapsedRealtime();
        while (true) {
            int statusCode;
            Response response = null;
            byte[] responseContents = null;
            HashMap<String, String> responseHeaders = new HashMap();
            try {
                HashMap<String, String> headers = new HashMap<String, String>();
                this.addCacheHeaders(headers, request.getCacheEntry());
                response = this.executeOkHttpRequest(request, headers);
                statusCode = response.code();
                HttpLog.v("Network status code is %d", statusCode);
                responseHeaders = HeaderNetwork.convertHeaders(response.headers());
                if (statusCode == 304) {
                    return new ResponseData(304, request.getCacheEntry().data, responseHeaders, true);
                }
                responseContents = new byte[]{};
                this.abort();
                long requestLifetime = SystemClock.elapsedRealtime() - requestStart;
                this.logSlowRequests(requestLifetime, request, statusCode);
                if (statusCode < 200 || statusCode > 299) {
                    throw new IOException();
                }
                return new ResponseData(statusCode, responseContents, responseHeaders, false);
            }
            catch (SocketTimeoutException e) {
                this.attemptRetryOnException("Socket", request, new TimeoutError());
                continue;
            }
            catch (ConnectTimeoutException e) {
                this.attemptRetryOnException("Connection", request, new TimeoutError());
                continue;
            }
            catch (MalformedURLException e) {
                HttpLog.e(e, "Bad URL " + request.getUrl(), new Object[0]);
                throw new RuntimeException("Bad URL " + request.getUrl(), e);
            }
            catch (IOException e) {
                statusCode = 0;
                ResponseData responseData = null;
                if (response == null) {
                    HttpLog.e("no connection error " + e.getMessage() + ",url:" + request.getUrl(), new Object[0]);
                    throw new NoConnectionError(e);
                }
                statusCode = response.code();
                HttpLog.e(e, "Unexpected response code %d for %s", statusCode, request.getUrl());
                if (responseContents != null) {
                    responseData = new ResponseData(statusCode, responseContents, responseHeaders, false);
                    if (statusCode == 401 || statusCode == 403) {
                        this.attemptRetryOnException("auth", request, new AuthFailureError(responseData));
                        continue;
                    }
                    HttpLog.e(e, "Server error code:" + responseData.statusCode + ",url:" + request.getUrl() + ",data:" + new String(responseData.data), new Object[0]);
                    throw new ServerError(responseData);
                }
                throw new NetworkError(responseData);
            }
            break;
        }
    }
}

