/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import android.os.SystemClock;
import com.yy.mobile.http.AuthFailureError;
import com.yy.mobile.http.BaseHttpClient;
import com.yy.mobile.http.ByteArrayPool;
import com.yy.mobile.http.Cache;
import com.yy.mobile.http.HttpLog;
import com.yy.mobile.http.Network;
import com.yy.mobile.http.PoolingByteArrayOutputStream;
import com.yy.mobile.http.ProgressInfo;
import com.yy.mobile.http.Request;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.ResponseData;
import com.yy.mobile.http.RetryPolicy;
import com.yy.mobile.http.ServerError;
import com.yy.mobile.http.TimeoutError;
import com.yy.mobile.http.dns.GslbDns;
import com.yy.mobile.http.dnsparser.DnsParser;
import com.yy.mobile.http.error.NetworkError;
import com.yy.mobile.http.error.NoConnectionError;
import com.yy.mobile.http.httpsparser.HttpsParser;
import com.yy.mobile.http.utils.Utils;
import com.yy.mobile.util.NetworkUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.http.conn.ConnectTimeoutException;

public class BaseNetwork
implements Network {
    protected static int SLOW_REQUEST_THRESHOLD_MS = 3000;
    protected static final long DEFAULT_PROGRESS_PERCENT = 100L;
    protected static final String SOCKET_ERR_RESET_BY_PEER = "Connection reset by peer";
    protected long progressStep = 0L;
    protected long progressPercent = 100L;
    protected Call mCall;
    protected static Map<String, String> COMMON_HEADERS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseData performRequest(Request<?> request) throws RequestError {
        long requestStart = SystemClock.elapsedRealtime();
        boolean hit = false;
        boolean loopcnt = false;
        while (true) {
            String localIP;
            Response response = null;
            byte[] responseContents = null;
            Map<String, String> responseHeaders = new HashMap<String, String>();
            try {
                HashMap<String, String> headers = new HashMap<String, String>();
                this.addCacheHeaders(headers, request.getCacheEntry());
                String orgUrl = request.getUrl();
                if (HttpLog.isDebug()) {
                    hit = true;
                }
                this.addCommonHeaders(headers);
                response = this.executeOkHttpRequest(request, headers);
                int statusCode = response.code();
                HttpLog.i("response:" + statusCode + " HttpRequestUrl:" + request.getUrl() + ", traceId = " + request.getHeaders().get("x-traceid"), new Object[0]);
                responseHeaders = BaseNetwork.convertHeaders(response.headers());
                if (statusCode == 304) {
                    ResponseData rd = new ResponseData(304, request.getCacheEntry().data, responseHeaders, true);
                    if (hit) {
                        HttpLog.v(Thread.currentThread().getName(), new Object[0]);
                    }
                    ResponseData responseData = rd;
                    return responseData;
                }
                responseContents = response != null && response.body() != null ? this.entityToBytes(request, response) : new byte[]{};
                long requestLifetime = SystemClock.elapsedRealtime() - requestStart;
                this.logSlowRequests(requestLifetime, request, statusCode);
                if (statusCode < 200 || statusCode > 299) {
                    throw new IOException();
                }
                ResponseData rd = new ResponseData(statusCode, responseContents, responseHeaders, false);
                if (hit) {
                    HttpLog.v(Thread.currentThread().getName(), new Object[0]);
                }
                ResponseData responseData = rd;
                return responseData;
            }
            catch (SocketTimeoutException e) {
                localIP = NetworkUtils.getIpDnsInfo().getIp();
                HttpLog.e("guozhi,localIP:" + localIP + " SocketTimeoutException " + e.getMessage() + ",url:" + request.getUrl(), new Object[0]);
                this.attemptRetryOnException("Socket", request, new TimeoutError(e));
                continue;
            }
            catch (ConnectTimeoutException e) {
                localIP = NetworkUtils.getIpDnsInfo().getIp();
                HttpLog.e("guozhi,localIP:" + localIP + " no connection error " + e.getMessage() + ",url:" + request.getUrl(), new Object[0]);
                this.attemptRetryOnException("Connection", request, new TimeoutError(e));
                continue;
            }
            catch (MalformedURLException e) {
                localIP = NetworkUtils.getIpDnsInfo().getIp();
                HttpLog.e(e, Thread.currentThread().getName() + " localIP:" + localIP + " Bad URL " + request.getUrl(), new Object[0]);
                throw new RuntimeException("localIP:" + localIP + " Bad URL :" + request.getUrl(), e);
            }
            catch (IOException e) {
                if (e instanceof SocketException && this.handleSocketException(request, (SocketException)e)) continue;
                int statusCode = 0;
                ResponseData responseData = null;
                if (response == null) {
                    HttpLog.e(Thread.currentThread().getName() + "guozhi, no connection error " + e.getMessage() + ",url:" + request.getUrl(), new Object[0]);
                    throw this.processingRequestError(new NoConnectionError(e), request);
                }
                statusCode = response.code();
                HttpLog.e(e, Thread.currentThread().getName() + "guozhi, Unexpected response code %d for %s", statusCode, request.getUrl());
                if (responseContents != null) {
                    responseData = new ResponseData(statusCode, responseContents, responseHeaders, false);
                    if (statusCode == 401 || statusCode == 403) {
                        this.attemptRetryOnException("auth", request, new AuthFailureError(responseData));
                        continue;
                    }
                    String dataStr = "";
                    dataStr = BaseNetwork.isUTF_8(responseData.data) ? new String(responseData.data) : "not utf8 format, length=" + responseData.data.length;
                    String localIP2 = NetworkUtils.getIpDnsInfo().getIp();
                    HttpLog.e(e, Thread.currentThread().getName() + " localIP:" + localIP2 + " Server error code:" + responseData.statusCode + ", url:" + request.getUrl() + ", data:" + dataStr, new Object[0]);
                    throw this.processingRequestError(new ServerError(responseData), request);
                }
                throw this.processingRequestError(new NetworkError(e), request);
            }
            finally {
                if (response == null || response.body() == null) continue;
                response.body().close();
                continue;
            }
            break;
        }
    }

    private RequestError processingRequestError(RequestError e, Request<?> request) {
        List<String> list;
        String localIP = NetworkUtils.getIpDnsInfo().getIp();
        String localDNS = NetworkUtils.getIpDnsInfo().getIp();
        String serverIP = "";
        String hostname = HttpsParser.getHost(request.getUrl());
        if (hostname != null && DnsParser.needsConvertOnly(hostname) && (list = GslbDns.inst().getIps(hostname)) != null) {
            serverIP = list.toString();
        }
        e.extendMsg.put("localIP", localIP);
        e.extendMsg.put("localDNS", localDNS);
        e.extendMsg.put("serverIP", serverIP);
        e.extendMsg.put("requestUrl", request.getUrl());
        return e;
    }

    private void addCommonHeaders(Map<String, String> headers) {
        if (COMMON_HEADERS != null && !COMMON_HEADERS.isEmpty()) {
            headers.putAll(COMMON_HEADERS);
        }
    }

    public static void setCommonHeaders(Map<String, String> commonHeaders) {
        COMMON_HEADERS = commonHeaders;
    }

    protected boolean handleSocketException(Request request, SocketException e) throws RequestError {
        if (e.getMessage().contains(SOCKET_ERR_RESET_BY_PEER)) {
            this.attemptRetryOnException(SOCKET_ERR_RESET_BY_PEER, request, new TimeoutError());
            return true;
        }
        return false;
    }

    protected void logSlowRequests(long requestLifetime, Request<?> request, int code) {
        if (requestLifetime > (long)SLOW_REQUEST_THRESHOLD_MS && HttpLog.isDebug()) {
            HttpLog.d("Slow request lifetime=%d, sc=%d, retryCount=%s, request=%s ", requestLifetime, code, request.getRetryPolicy().getCurrentRetryCount(), request);
        }
    }

    protected void attemptRetryOnException(String logPrefix, Request<?> request, RequestError exception) throws RequestError {
        RetryPolicy retryPolicy = request.getRetryPolicy();
        try {
            retryPolicy.retry(request, exception);
        }
        catch (RequestError e) {
            throw this.processingRequestError(e, request);
        }
    }

    protected void addCacheHeaders(Map<String, String> headers, Cache.Entry entry) {
        if (entry == null) {
            return;
        }
        if (entry.etag != null) {
            headers.put("If-None-Match", entry.etag);
        }
        if (entry.serverDate > 0L) {
            Date refTime = new Date(entry.serverDate);
            String formatData = refTime.toString();
            headers.put("If-Modified-Since", formatData.substring(0, formatData.length() - 6));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public byte[] entityToBytes(Request<?> request, Response response) throws IOException, ServerError {
        int count;
        if (response.header("Content-Encoding") != null && response.header("Content-Encoding").equals("gzip")) {
            return response.body().source().readByteArray();
        }
        ByteArrayPool pool = Utils.getByteArrayPool();
        PoolingByteArrayOutputStream bytes = new PoolingByteArrayOutputStream(pool, (int)response.body().contentLength());
        byte[] buffer = null;
        InputStream in = null;
        in = response.body().byteStream();
        if (in == null) {
            throw new ServerError();
        }
        buffer = pool.getBuf(1024);
        long progress = 0L;
        long total = response.body().contentLength();
        while ((count = in.read(buffer)) != -1) {
            bytes.write(buffer, 0, count);
            if (!this.needProgress(count, total, request, progress += (long)count)) continue;
            ProgressInfo progressInfo = new ProgressInfo(progress, total);
            request.postProgress(progressInfo);
        }
        byte[] byArray = bytes.toByteArray();
        try {
            response.body().close();
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                HttpLog.e(e, "InputStream close error.", e);
            }
        }
        catch (Exception e) {
            HttpLog.v("entity to bytes consumingContent error", new Object[0]);
        }
        pool.returnBuf(buffer);
        bytes.close();
        return byArray;
        catch (OutOfMemoryError oom) {
            byte[] byArray2;
            try {
                HttpLog.e(oom, "Bytes.toByteArray from network oom.", new Object[0]);
                System.gc();
                byArray2 = new byte[]{};
            }
            catch (Throwable throwable) {
                try {
                    response.body().close();
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        HttpLog.e(e, "InputStream close error.", e);
                    }
                }
                catch (Exception e) {
                    HttpLog.v("entity to bytes consumingContent error", new Object[0]);
                }
                pool.returnBuf(buffer);
                bytes.close();
                throw throwable;
            }
            try {
                response.body().close();
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    HttpLog.e(e, "InputStream close error.", e);
                }
            }
            catch (Exception e) {
                HttpLog.v("entity to bytes consumingContent error", new Object[0]);
            }
            pool.returnBuf(buffer);
            bytes.close();
            return byArray2;
        }
    }

    private InputStream getContentStream(Response response) throws IOException {
        if (response.header("Content-Encoding") != null && response.header("Content-Encoding").equals("gzip")) {
            new GZIPInputStream(response.body().byteStream());
        }
        return response.body().byteStream();
    }

    protected boolean needProgress(long count, long total, Request<?> request, long progress) {
        if (request.getProgressListener() == null) {
            return false;
        }
        if (total < 0L) {
            return false;
        }
        this.progressStep += count;
        if (this.progressStep > total / this.progressPercent || progress >= total) {
            this.progressStep = 0L;
            return true;
        }
        return false;
    }

    protected static Map<String, String> convertHeaders(Headers headers) {
        HashMap<String, String> result = new HashMap<String, String>();
        Set names = headers.names();
        for (String key : names) {
            result.put(key, headers.get(key));
        }
        return result;
    }

    protected okhttp3.Request createHttpRequest(Request<?> request, Map<String, String> additionalHeaders) {
        Request.Builder builder = new Request.Builder();
        switch (request.getMethod()) {
            case 0: {
                builder.get();
                break;
            }
            case 1: {
                builder.post(request.getRequestBody());
                break;
            }
            case 2: {
                builder.put(request.getRequestBody());
                break;
            }
            case 3: {
                builder.delete();
                break;
            }
            default: {
                HttpLog.e("Unknown request method.", new Object[0]);
                builder.get();
            }
        }
        HashMap<String, String> header = new HashMap<String, String>();
        for (String key : additionalHeaders.keySet()) {
            header.put(key, additionalHeaders.get(key));
        }
        for (String key : request.getHeaders().keySet()) {
            header.put(key, request.getHeaders().get(key));
        }
        for (String key : request.getHttpParams().keySet()) {
            header.put(key, request.getHttpParams().get(key).toString());
        }
        builder.url(request.getUrl());
        if (request.getHttpParams().containsKey("http.virtual-host")) {
            header.put("Host", HttpsParser.getHost(request.getHttpParams().get("http.virtual-host").toString()));
        }
        for (String key : header.keySet()) {
            builder.addHeader(this.encodeOKHttpChar(key), this.encodeOKHttpChar((String)header.get(key)));
        }
        builder.tag(request.getTag());
        return builder.build();
    }

    private String encodeOKHttpChar(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (c <= '\u001f' || c >= '\u007f') {
                stringBuffer.append(String.format("\\u%04x", c));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public Response executeOkHttpRequest(Request<?> request, Map<String, String> additionalHeaders) throws IOException, AuthFailureError, IllegalStateException {
        this.mCall = BaseHttpClient.getOkHttpClient().newCall(this.createHttpRequest(request, additionalHeaders));
        return this.mCall.execute();
    }

    public static String getValueEncoded(String value, String charset) {
        if (value == null) {
            return "null";
        }
        String newValue = value;
        int length = newValue.length();
        for (int i = 0; i < length; ++i) {
            char c = newValue.charAt(i);
            if (c > '\u001f' && c < '\u007f') continue;
            try {
                HttpLog.e("guozhi,URLEncoder.encode \u4e2d\u6587 :" + newValue, new Object[0]);
                return URLEncoder.encode(newValue, charset);
            }
            catch (Exception e) {
                HttpLog.e("guozhi,URLEncoder.encode error :" + newValue, new Object[0]);
                return newValue;
            }
        }
        return newValue;
    }

    @Override
    public void abort() {
        if (this.mCall != null) {
            this.mCall.cancel();
        }
    }

    public static boolean isUTF_8(byte[] str) {
        if (str.length < 3) {
            return false;
        }
        return (str[0] & 0xFF) == 239 && (str[1] & 0xFF) == 187 && (str[2] & 0xFF) == 191;
    }
}

