/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.guid;

import android.content.Context;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.file.FileRequestException;
import com.yy.mobile.file.FileRequestManager;
import com.yy.mobile.file.FileResponse;
import com.yy.mobile.file.FileResponseData;
import com.yy.mobile.file.FileResponseErrorListener;
import com.yy.mobile.file.FileResponseListener;
import com.yy.mobile.file.data.DefaultFileDataParam;
import com.yy.mobile.file.data.FileDataParam;
import com.yy.mobile.file.data.FileGetRequest;
import com.yy.mobile.file.data.FilePutRequest;
import com.yy.mobile.guid.AESCrypto;
import com.yy.mobile.guid.Crypto;
import com.yy.mobile.guid.GuidPref;
import com.yy.mobile.guid.IGuid;
import com.yy.mobile.util.Base64Utils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import java.util.UUID;

public class GuidImpl
implements IGuid {
    public static final String UUID_KEY = "uuid";
    public static final String FILE_PATH = "Android/data/.dat";
    protected String mGuid = "";
    private String mSDCardValue;
    protected Crypto mCrypto = new AESCrypto();

    @Override
    public void init() {
        MLog.info("GUID_LOG", "init", new Object[0]);
        this.queryUUIDFromSDCard();
    }

    @Override
    public String getGuid() {
        try {
            if (this.mGuid.length() < 1) {
                this.mGuid = this.queryUUIDFromPref();
            }
        }
        catch (Throwable e) {
            MLog.error((Object)"GUID_LOG", "getGuid error:", e, new Object[0]);
            this.mGuid = "";
        }
        return this.mGuid;
    }

    protected String generateUUID() {
        String uuid = UUID.randomUUID().toString();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug("GUID_LOG", "Generate UUID =%s", uuid);
        }
        return uuid;
    }

    protected void saveUUID(String value) {
        this.saveUUIDToSDCard(value);
        this.saveUUIDToPref(value);
    }

    protected void saveUUIDToPref(String value) {
        byte[] result;
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug("GUID_LOG", "Save UUID to pref=%s", value);
        }
        if ((result = this.mCrypto.encode(value.getBytes())) != null) {
            value = Base64Utils.encodeToString(result, 2);
        }
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug("GUID_LOG", "Save UUID to pref after encode=%s", value);
        }
        GuidPref.instance().putUUID(value);
    }

    protected String queryUUIDFromPref() {
        String uuid = GuidPref.instance().getUUID();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug("GUID_LOG", "Query UUID from pref=%s", uuid);
        }
        if (uuid != null && uuid.length() > 0) {
            try {
                byte[] decodeData = Base64Utils.decode(uuid, 2);
                byte[] result = this.mCrypto.decode(decodeData);
                if (result != null) {
                    uuid = new String(result);
                    if (!this.isValidUUID(uuid)) {
                        MLog.warn("GUID_LOG", "Query from pref error[invalid]", new Object[0]);
                        uuid = "";
                    }
                } else {
                    MLog.warn("GUID_LOG", "Query from pref error[null]", new Object[0]);
                    uuid = "";
                }
            }
            catch (Exception e) {
                MLog.warn("GUID_LOG", "Query from pref error[64]", new Object[0]);
                uuid = "";
            }
        }
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug("GUID_LOG", "Query UUID from pref after=%s", uuid);
        }
        return uuid;
    }

    protected boolean isValidUUID(String value) {
        return value.matches("[A-Za-z0-9\\-]{36}");
    }

    protected void queryUUIDFromSDCard() {
        DefaultFileDataParam param = new DefaultFileDataParam(FILE_PATH, UUID_KEY);
        CryptoFileGetRequest request = new CryptoFileGetRequest(BasicConfig.getInstance().getAppContext(), param);
        request.setSuccessListener(new FileResponseListener<byte[]>(){

            @Override
            public void onResponse(final byte[] response) {
                YYTaskExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        String prefValue;
                        GuidImpl.this.mSDCardValue = new String(response);
                        if (MLog.isLogLevelAboveDebug()) {
                            MLog.debug("GUID_LOG", "QueryUUIDFromSDCard = %s", GuidImpl.this.mSDCardValue);
                        }
                        if ((prefValue = GuidImpl.this.queryUUIDFromPref()) == null || prefValue.length() < 1) {
                            GuidImpl.this.saveUUIDToPref(GuidImpl.this.mSDCardValue);
                        }
                    }
                });
            }
        });
        request.setErrorListener(new FileResponseErrorListener(){

            @Override
            public void onErrorResponse(final FileRequestException error) {
                YYTaskExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        MLog.error((Object)"GUID_LOG", "Guid request error:", error, new Object[0]);
                        String prefValue = GuidImpl.this.queryUUIDFromPref();
                        if (prefValue == null || prefValue.length() < 1) {
                            GuidImpl.this.mGuid = GuidImpl.this.generateUUID();
                            GuidImpl.this.saveUUID(GuidImpl.this.mGuid);
                        } else {
                            GuidImpl.this.mGuid = prefValue;
                            GuidImpl.this.saveUUIDToSDCard(GuidImpl.this.mGuid);
                        }
                    }
                });
            }
        });
        FileRequestManager.instance().submitFileRequest(request);
    }

    protected void saveUUIDToSDCard(String value) {
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose("GUID_LOG", "saveUUIDToSDCard %s", value);
        }
        DefaultFileDataParam param = new DefaultFileDataParam(FILE_PATH, UUID_KEY);
        CryptoFilePutRequest request = new CryptoFilePutRequest(BasicConfig.getInstance().getAppContext(), param, value.getBytes());
        FileRequestManager.instance().submitFileRequest(request);
    }

    class CryptoFilePutRequest
    extends FilePutRequest {
        public CryptoFilePutRequest(Context context, FileDataParam config, byte[] data) {
            super(context, config, data);
        }

        @Override
        public FileResponseData performRequest() throws FileRequestException {
            this.mData = GuidImpl.this.mCrypto.encode(this.mData);
            if (this.mData == null) {
                throw new RuntimeException("Crypto decode error");
            }
            return super.performRequest();
        }
    }

    class CryptoFileGetRequest
    extends FileGetRequest {
        public CryptoFileGetRequest(Context context, FileDataParam config) {
            super(context, config);
        }

        @Override
        public void parseDataToResponse(FileResponseData responseData) {
            if (responseData != null) {
                byte[] result = GuidImpl.this.mCrypto.decode(responseData.getData());
                if (result == null) {
                    throw new RuntimeException("Crypto decode error");
                }
                this.mResponse = FileResponse.success(result);
            }
        }
    }
}

