/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.guid;

import android.util.Log;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.guid.Crypto;
import com.yy.mobile.util.log.MLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.security.Key;
import javax.crypto.Cipher;

public class AESCrypto
implements Crypto {
    protected static final String AES = "AES";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encode(byte[] src) {
        OutputStream fosData = null;
        try {
            Cipher cipher = Cipher.getInstance(AES);
            Key key = this.getKey();
            cipher.init(1, key);
            byte[] byArray = cipher.doFinal(src);
            return byArray;
        }
        catch (Exception e) {
            MLog.error((Object)"GUID_LOG", "Encode error.", e, new Object[0]);
        }
        finally {
            this.safeOsClose(fosData);
        }
        return null;
    }

    protected void safeOsClose(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e) {
                Log.e((String)"AESCrypto", (String)"Empty Catch on safeOsClose", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] decode(byte[] src) {
        InputStream is = null;
        try {
            Cipher cipher = Cipher.getInstance(AES);
            Key key = this.getKey();
            cipher.init(2, key);
            byte[] byArray = cipher.doFinal(src);
            return byArray;
        }
        catch (Exception e) {
            MLog.error((Object)"GUID_LOG", "Decode error.Data len=" + src.length, e, new Object[0]);
        }
        finally {
            this.safeIsClose(is);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Key getKey() {
        InputStream fisKey = null;
        ObjectInputStream oisKey = null;
        Key key = null;
        try {
            fisKey = BasicConfig.getInstance().getAppContext().getAssets().open("guk");
            oisKey = new ObjectInputStream(fisKey);
            key = (Key)oisKey.readObject();
            this.safeIsClose(oisKey);
            this.safeIsClose(fisKey);
        }
        catch (Exception e) {
            try {
                MLog.error((Object)"GUID_LOG", "Get key error.", e, new Object[0]);
                this.safeIsClose(oisKey);
                this.safeIsClose(fisKey);
            }
            catch (Throwable throwable) {
                this.safeIsClose(oisKey);
                this.safeIsClose(fisKey);
                throw throwable;
            }
        }
        return key;
    }

    protected void safeIsClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                Log.e((String)"AESCrypto", (String)"Empty Catch on safeIsClose", (Throwable)e);
            }
        }
    }
}

