/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.file;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.util.ArrayMap;
import com.yy.mobile.file.FileDispatcher;
import com.yy.mobile.file.FileProcessor;
import com.yy.mobile.file.FileRequest;
import com.yy.mobile.http.ByteArrayPool;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.log.MLog;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultFileProcessor
implements FileProcessor {
    protected static int DEFAULT_POOL_SIZE = 4096;
    protected final Map<String, Queue<FileRequest>> mWaitingRequests = new ArrayMap(3);
    protected final Set<FileRequest> mCurrentRequests = new HashSet<FileRequest>(3);
    protected final PriorityBlockingQueue<FileRequest> mRequestQueue = new PriorityBlockingQueue(5);
    protected static final int DEFAULT_NETWORK_THREAD_POOL_SIZE = 1;
    protected AtomicInteger mSequenceGenerator = new AtomicInteger();
    protected FileDispatcher[] mFileDispatchers;
    protected Handler mHandler;
    protected final ByteArrayPool mPool;
    protected final String mName;
    protected final Context mContext;

    public DefaultFileProcessor(int threadPoolSize, Handler handler, String name, Context context) {
        this.mFileDispatchers = new FileDispatcher[threadPoolSize];
        this.mHandler = handler;
        this.mPool = new ByteArrayPool(DEFAULT_POOL_SIZE);
        this.mName = name;
        this.mContext = context;
    }

    public DefaultFileProcessor(int threadPoolSize, String name, Context context) {
        this(threadPoolSize, new SafeDispatchHandler(Looper.getMainLooper()), name, context);
    }

    @Override
    public void start() {
        this.stop();
        for (int i = 0; i < this.mFileDispatchers.length; ++i) {
            FileDispatcher networkDispatcher;
            this.mFileDispatchers[i] = networkDispatcher = new FileDispatcher(this.mRequestQueue, this.mName, this);
            networkDispatcher.start();
        }
    }

    @Override
    public void stop() {
        for (int i = 0; i < this.mFileDispatchers.length; ++i) {
            if (this.mFileDispatchers[i] == null) continue;
            this.mFileDispatchers[i].quit();
        }
    }

    public int getSequenceNumber() {
        return this.mSequenceGenerator.incrementAndGet();
    }

    @Override
    public void setHandler(Handler handler) {
        this.mHandler = handler;
    }

    @Override
    public Handler getHandler() {
        return this.mHandler;
    }

    @Override
    public ByteArrayPool getByteArrayPool() {
        return this.mPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAll(FileProcessor.FileRequestFilter filter) {
        if (filter == null) {
            return;
        }
        Set<FileRequest> set = this.mCurrentRequests;
        synchronized (set) {
            for (FileRequest request : this.mCurrentRequests) {
                if (!filter.apply(request)) continue;
                request.cancel();
            }
        }
    }

    @Override
    public void cancelAll(final Object tag) {
        if (tag == null) {
            return;
        }
        this.cancelAll(new FileProcessor.FileRequestFilter(){

            @Override
            public boolean apply(FileRequest<?> request) {
                return request.getTag() == tag;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileRequest add(FileRequest request) {
        if (request == null) {
            return request;
        }
        request.setRequestProcessor(this);
        Set<FileRequest> set = this.mCurrentRequests;
        synchronized (set) {
            this.mCurrentRequests.add(request);
        }
        request.setSequence(this.getSequenceNumber());
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose("FileRequest", "Add to queue", new Object[0]);
        }
        this.mRequestQueue.add(request);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish(FileRequest request) {
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose("FileRequest", "finish", new Object[0]);
        }
        if (request == null) {
            return;
        }
        Set<FileRequest> set = this.mCurrentRequests;
        synchronized (set) {
            this.mCurrentRequests.remove(request);
        }
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }
}

