/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.file;

import android.os.Handler;
import com.yy.mobile.file.FileProcessor;
import com.yy.mobile.file.FileProgressInfo;
import com.yy.mobile.file.FileProgressListener;
import com.yy.mobile.file.FileRequest;
import com.yy.mobile.file.FileRequestException;
import com.yy.mobile.file.FileResponse;
import com.yy.mobile.file.FileResponseErrorListener;
import com.yy.mobile.file.FileResponseListener;
import com.yy.mobile.util.log.MLog;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class BaseFileRequest<T>
implements FileRequest<T> {
    protected Object mTag;
    protected Integer mSequence;
    protected FileProcessor mRequestProcessor;
    protected AtomicBoolean mCanceled = new AtomicBoolean(false);
    protected boolean mResponseDelivered = false;
    protected FileResponse<T> mResponse;
    protected FileResponseListener mSuccessListener;
    protected FileResponseErrorListener mErrorListener;
    protected FileProgressListener mProgressListener;
    protected FileRequest.Priority mPriority = FileRequest.Priority.NORMAL;

    @Override
    public void setTag(Object tag) {
        this.mTag = tag;
    }

    @Override
    public Object getTag() {
        return this.mTag;
    }

    @Override
    public void finish(String tag) {
        if (this.mRequestProcessor != null) {
            this.mRequestProcessor.finish(this);
        }
    }

    @Override
    public void setRequestProcessor(FileProcessor requestProcessor) {
        this.mRequestProcessor = requestProcessor;
    }

    @Override
    public FileProcessor getRequestProcessor() {
        return this.mRequestProcessor;
    }

    @Override
    public void setSequence(int sequence) {
        this.mSequence = sequence;
    }

    @Override
    public int getSequence() {
        return this.mSequence;
    }

    @Override
    public void cancel() {
        this.mCanceled.set(true);
    }

    @Override
    public boolean isCanceled() {
        return this.mCanceled.get();
    }

    @Override
    public FileRequest.Priority getPriority() {
        return this.mPriority;
    }

    @Override
    public void setPriority(FileRequest.Priority priority) {
        this.mPriority = priority;
    }

    @Override
    public FileResponse<T> getResponse() {
        return this.mResponse;
    }

    @Override
    public void markDelivered() {
        this.mResponseDelivered = true;
    }

    @Override
    public boolean hasHadResponseDelivered() {
        return this.mResponseDelivered;
    }

    @Override
    public FileResponseListener getSuccessListener() {
        return this.mSuccessListener;
    }

    @Override
    public FileResponseErrorListener getErrorListener() {
        return this.mErrorListener;
    }

    @Override
    public FileProgressListener getProgressListener() {
        return this.mProgressListener;
    }

    @Override
    public void setSuccessListener(FileResponseListener successListener) {
        this.mSuccessListener = successListener;
    }

    @Override
    public void setErrorListener(FileResponseErrorListener errorListener) {
        this.mErrorListener = errorListener;
    }

    @Override
    public void setProgressListener(FileProgressListener progressListener) {
        this.mProgressListener = progressListener;
    }

    @Override
    public void postResponse() {
        this.postResponse(null);
    }

    @Override
    public void postResponse(Runnable runnable) {
        if (this.mRequestProcessor != null) {
            Handler handler = this.mRequestProcessor.getHandler();
            if (handler == null) {
                new ResponseDeliveryRunnable(this, this.getResponse(), runnable).run();
            } else {
                handler.post((Runnable)new ResponseDeliveryRunnable(this, this.getResponse(), runnable));
            }
        }
    }

    @Override
    public void postError(FileRequestException error) {
        this.mResponse = FileResponse.error(error);
        this.postResponse();
    }

    @Override
    public void postProgress(FileProgressInfo progressInfo) {
        if (this.mRequestProcessor != null) {
            Handler handler = this.mRequestProcessor.getHandler();
            if (handler == null) {
                new ProgressDeliveryRunnable(this, this.mProgressListener, progressInfo).run();
            } else {
                handler.post((Runnable)new ProgressDeliveryRunnable(this, this.mProgressListener, progressInfo));
            }
        }
    }

    @Override
    public int compareTo(FileRequest<T> other) {
        FileRequest.Priority right;
        FileRequest.Priority left = this.getPriority();
        return left == (right = other.getPriority()) ? this.getSequence() - other.getSequence() : right.ordinal() - left.ordinal();
    }

    public String toString() {
        return this.getClass().getName() + "mUrl='" + this.getKey() + '\'' + '}';
    }

    protected class ProgressDeliveryRunnable
    implements Runnable {
        private final FileRequest mRequest;
        private final FileProgressInfo mInfo;
        private final FileProgressListener mListener;

        public ProgressDeliveryRunnable(FileRequest request, FileProgressListener progressListener, FileProgressInfo progressInfo) {
            this.mRequest = request;
            this.mListener = progressListener;
            this.mInfo = progressInfo;
        }

        @Override
        public void run() {
            if (this.mRequest.isCanceled()) {
                this.mRequest.finish("Canceled in delivery runnable");
                return;
            }
            if (this.mListener != null) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug("FileRequest", "On progress delivery " + this.mInfo, new Object[0]);
                }
                this.mListener.onProgress(this.mInfo);
            }
        }
    }

    private class ResponseDeliveryRunnable
    implements Runnable {
        private final FileRequest mRequest;
        private final FileResponse mResponse;
        private final Runnable mRunnable;

        public ResponseDeliveryRunnable(FileRequest request, FileResponse response, Runnable runnable) {
            this.mRequest = request;
            this.mRunnable = runnable;
            this.mResponse = response;
        }

        @Override
        public void run() {
            if (this.mRequest.isCanceled()) {
                this.mRequest.finish("canceled-at-delivery");
                return;
            }
            if (this.mResponse.isSuccess()) {
                if (this.mRequest.getSuccessListener() != null) {
                    this.mRequest.getSuccessListener().onResponse(this.mResponse.result);
                }
            } else if (this.mRequest.getErrorListener() != null) {
                this.mRequest.getErrorListener().onErrorResponse(this.mResponse.exception);
            }
            if (this.mResponse.intermediate) {
                if (!MLog.isLogLevelAboveVerbose()) {
                    MLog.verbose("FileRequest", "intermediate-response", new Object[0]);
                }
            } else {
                this.mRequest.finish("done");
            }
            if (this.mRunnable != null) {
                this.mRunnable.run();
            }
        }
    }
}

