/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile;

import android.support.annotation.NonNull;
import android.util.Log;
import android.view.View;
import com.jakewharton.rxrelay2.Relay;
import com.trello.rxlifecycle2.RxLifecycle;
import com.trello.rxlifecycle2.android.ActivityEvent;
import com.trello.rxlifecycle2.android.FragmentEvent;
import com.trello.rxlifecycle2.android.RxLifecycleAndroid;
import com.trello.rxlifecycle2.components.RxActivity;
import com.trello.rxlifecycle2.components.RxFragment;
import com.trello.rxlifecycle2.components.support.RxDialogFragment;
import com.trello.rxlifecycle2.components.support.RxFragmentActivity;
import com.yy.android.sniper.api.event.EventApi;
import com.yy.mobile.rxbus.EventFlowableFromObservable;
import com.yy.mobile.rxbus.EventPredictable;
import com.yy.mobile.rxbus.EventPublishRelay;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.BackpressureKind;
import io.reactivex.annotations.BackpressureSupport;
import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.annotations.SchedulerSupport;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.functions.Functions;
import io.reactivex.internal.operators.flowable.FlowableOnBackpressureError;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.schedulers.Schedulers;
import java.security.InvalidParameterException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class RxBus {
    private static final String TAG = "RxBus";
    private static final RxBus mDefault = new RxBus(0, "Default");
    private final Relay<Object> mRelay;
    private ConcurrentHashMap<Class, Object> mStickyHashMap = new ConcurrentHashMap();
    private static final int DEFAULT_TIMEOUT_SECONDS = 5;
    private final int mMaxBufferSize;
    private final String mName;

    public String getName() {
        return this.mName;
    }

    public String toString() {
        return "RxBus{MaxBufferSize=" + this.mMaxBufferSize + ", Name='" + this.mName + '\'' + '}';
    }

    private RxBus(int maxBufferSize, @NonNull String name) {
        this.mMaxBufferSize = maxBufferSize;
        this.mName = name;
        this.mRelay = EventPublishRelay.create();
    }

    public static RxBus getDefault() {
        return mDefault;
    }

    public static RxBus create(int maxBufferSize, @NonNull String name) {
        if (EventApi.getPluginBus((String)name) != null) {
            return (RxBus)EventApi.getPluginBus((String)name);
        }
        RxBus instance2 = new RxBus(maxBufferSize, name);
        EventApi.registerPluginBus((String)name, (Object)instance2);
        return instance2;
    }

    @Deprecated
    public static RxBus createBySniper(int maxBufferSize, @NonNull String name) {
        return new RxBus(maxBufferSize, name);
    }

    public void post(Object event) {
        this.mRelay.accept(event);
    }

    public void postDelay(final Object event, long milliSecs) {
        Observable.timer((long)milliSecs, (TimeUnit)TimeUnit.MILLISECONDS).subscribe((Consumer)new Consumer<Long>(){

            public void accept(@io.reactivex.annotations.NonNull Long aLong) throws Exception {
                RxBus.this.mRelay.accept(event);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(@io.reactivex.annotations.NonNull Throwable throwable) throws Exception {
                Log.e((String)RxBus.TAG, (String)"Post Delay failed.", (Throwable)throwable);
            }
        });
    }

    public void postStick(Object event) {
        Object t = this.mStickyHashMap.get(event.getClass());
        this.mStickyHashMap.put(event.getClass(), event);
        this.post(event);
    }

    public <T> Observable<T> register(Class<T> cls) {
        if (this.mMaxBufferSize > 0) {
            return this.toFlowable(this.mRelay, BackpressureStrategy.BUFFER).filter((Predicate)new EventPredictable(cls)).onBackpressureBuffer(this.mMaxBufferSize).cast(cls).toObservable();
        }
        return this.mRelay.filter((Predicate)new EventPredictable(cls)).cast(cls);
    }

    public <T> Observable<T> registerSticky(Class<T> cls) {
        final Object t = this.mStickyHashMap.get(cls);
        Observable<T> observable = this.register(cls);
        if (t == null) {
            return observable;
        }
        return observable.mergeWith((ObservableSource)Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<T>(){

            public void subscribe(ObservableEmitter<T> emitter) throws Exception {
                emitter.onNext(t);
            }
        }));
    }

    public <T> Disposable singleCall(Class<T> cls, Consumer<? super T> onSuccess) {
        return this.singleCall(cls, onSuccess, (Consumer<? super Throwable>)Functions.ON_ERROR_MISSING);
    }

    public <T> Disposable singleCall(Class<T> cls, Consumer<? super T> onSuccess, Consumer<? super Throwable> onError) {
        return this.register(cls).firstOrError().subscribe(onSuccess, onError);
    }

    public <T> void maybeCall(Class<T> cls, Consumer<? super T> onSuccess) {
        this.maybeCall(cls, onSuccess, 5);
    }

    public <T> void maybeCall(Class<T> cls, Consumer<? super T> onSuccess, int second) {
        this.maybeCall(cls, onSuccess, (Consumer<? super Throwable>)Functions.ON_ERROR_MISSING, second);
    }

    public <T> void maybeCall(Class<T> cls, Consumer<? super T> onSuccess, Consumer<? super Throwable> onError) {
        this.maybeCall(cls, onSuccess, onError, 5);
    }

    public <T> void maybeCall(Class<T> cls, Consumer<? super T> onSuccess, Consumer<? super Throwable> onError, int second) {
        this.register(cls).timeout((long)second, TimeUnit.SECONDS).firstOrError().toMaybe().subscribe(onSuccess, onError);
    }

    public <T> Observable<T> register(@NonNull Class<T> cls, Object lifecycleObject) {
        if (lifecycleObject == null) {
            throw new InvalidParameterException("lifecycleObject can not be null");
        }
        Log.v((String)TAG, (String)("Register for class: " + cls.getName() + ", lifecycleObject type: " + lifecycleObject.getClass().getName()));
        if (lifecycleObject instanceof RxActivity) {
            RxActivity rxActivity = (RxActivity)lifecycleObject;
            return this.registerOnActivity(cls, rxActivity);
        }
        if (lifecycleObject instanceof RxFragmentActivity) {
            RxFragmentActivity rxActivity = (RxFragmentActivity)lifecycleObject;
            return this.registerOnActivity(cls, rxActivity);
        }
        if (lifecycleObject instanceof com.trello.rxlifecycle2.components.support.RxFragment) {
            com.trello.rxlifecycle2.components.support.RxFragment rxFragment = (com.trello.rxlifecycle2.components.support.RxFragment)lifecycleObject;
            return this.registerOnFragment(cls, rxFragment);
        }
        if (lifecycleObject instanceof RxFragment) {
            RxFragment rxFragment = (RxFragment)lifecycleObject;
            return this.registerOnFragment(cls, rxFragment);
        }
        if (lifecycleObject instanceof com.trello.rxlifecycle2.components.RxDialogFragment) {
            com.trello.rxlifecycle2.components.RxDialogFragment rxFragment = (com.trello.rxlifecycle2.components.RxDialogFragment)lifecycleObject;
            return this.registerOnDialogFragment(cls, rxFragment);
        }
        if (lifecycleObject instanceof RxDialogFragment) {
            RxDialogFragment rxFragment = (RxDialogFragment)lifecycleObject;
            return this.registerOnDialogFragment(cls, rxFragment);
        }
        if (lifecycleObject instanceof View) {
            View view = (View)lifecycleObject;
            return this.registerOnView(cls, view);
        }
        Log.w((String)TAG, (String)("Type of lifecycleObject is: [" + lifecycleObject.getClass().getName() + "], which is not supported. You should un-subscribe from the returned Observable object yourself."));
        throw new IllegalArgumentException("lifecycleObject is not supported.");
    }

    public <T> Observable<T> registerOnActivity(Class<T> cls, RxActivity activity) {
        if (activity == null) {
            throw new InvalidParameterException("activity can not be null");
        }
        return this.register(cls).compose((ObservableTransformer)RxLifecycle.bindUntilEvent((Observable)activity.lifecycle(), (Object)ActivityEvent.DESTROY));
    }

    public <T> Observable<T> registerOnActivity(Class<T> cls, RxFragmentActivity activity) {
        if (activity == null) {
            throw new InvalidParameterException("activity can not be null");
        }
        return this.register(cls).compose((ObservableTransformer)RxLifecycle.bindUntilEvent((Observable)activity.lifecycle(), (Object)ActivityEvent.DESTROY));
    }

    public <T> Observable<T> registerOnFragment(Class<T> cls, com.trello.rxlifecycle2.components.support.RxFragment fragment) {
        if (fragment == null) {
            throw new InvalidParameterException("fragment can not be null");
        }
        return this.register(cls).compose((ObservableTransformer)RxLifecycle.bindUntilEvent((Observable)fragment.lifecycle(), (Object)FragmentEvent.DESTROY));
    }

    public <T> Observable<T> registerOnFragment(Class<T> cls, RxFragment fragment) {
        if (fragment == null) {
            throw new InvalidParameterException("fragment can not be null");
        }
        return this.register(cls).compose((ObservableTransformer)RxLifecycle.bindUntilEvent((Observable)fragment.lifecycle(), (Object)FragmentEvent.DESTROY));
    }

    public <T> Observable<T> registerOnDialogFragment(Class<T> cls, com.trello.rxlifecycle2.components.RxDialogFragment dlgFragment) {
        if (dlgFragment == null) {
            throw new InvalidParameterException("dlgFragment can not be null");
        }
        return this.register(cls).compose((ObservableTransformer)RxLifecycle.bindUntilEvent((Observable)dlgFragment.lifecycle(), (Object)FragmentEvent.DESTROY));
    }

    public <T> Observable<T> registerOnDialogFragment(Class<T> cls, RxDialogFragment dlgFragment) {
        if (dlgFragment == null) {
            throw new InvalidParameterException("dlgFragment can not be null");
        }
        return this.register(cls).compose((ObservableTransformer)RxLifecycle.bindUntilEvent((Observable)dlgFragment.lifecycle(), (Object)FragmentEvent.DESTROY));
    }

    public <T> Observable<T> registerOnView(Class<T> cls, View view) {
        if (view == null) {
            throw new InvalidParameterException("view can not be null");
        }
        return this.register(cls).compose((ObservableTransformer)RxLifecycleAndroid.bindView((View)view));
    }

    @Deprecated
    public <T> Observable<T> register(Class<T> cls, boolean mainThread) {
        return this.register(cls, mainThread, false);
    }

    public <T> Observable<T> register(Class<T> cls, boolean mainThread, boolean sync) {
        Observable observable = this.mMaxBufferSize > 0 ? this.toFlowable(this.mRelay, BackpressureStrategy.BUFFER).filter((Predicate)new EventPredictable(cls)).onBackpressureBuffer(this.mMaxBufferSize).cast(cls).toObservable() : this.mRelay.filter((Predicate)new EventPredictable(cls)).cast(cls);
        if (!sync) {
            observable = mainThread ? observable.observeOn(AndroidSchedulers.mainThread()) : observable.subscribeOn(Schedulers.computation());
            observable = observable.unsubscribeOn(Schedulers.computation());
        }
        return observable;
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    private <T> Flowable<T> toFlowable(Relay<T> relay, BackpressureStrategy strategy) {
        EventFlowableFromObservable<T> o = new EventFlowableFromObservable<T>(relay);
        switch (strategy) {
            case DROP: {
                return o.onBackpressureDrop();
            }
            case LATEST: {
                return o.onBackpressureLatest();
            }
            case MISSING: {
                return o;
            }
            case ERROR: {
                return RxJavaPlugins.onAssembly((Flowable)new FlowableOnBackpressureError(o));
            }
        }
        return o.onBackpressureBuffer();
    }

    public <T> void removeSticky(Class<T> cls) {
        this.mStickyHashMap.remove(cls);
    }

    public void removeAllSticky() {
        this.mStickyHashMap.clear();
    }
}

