/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.comble;

import android.animation.Animator;
import android.animation.Keyframe;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.os.Message;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yy.mobile.framework.R;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.SafeDispatchHandler;
import java.lang.ref.WeakReference;

public class ArrowShakeManager {
    private Context mContext;
    private ViewGroup mRootView;
    private RecycleImageView arrowImg;
    private boolean animationIsRun = false;
    private RelativeLayout.LayoutParams layoutParamsPortrait;
    private RelativeLayout.LayoutParams layoutParamsLandscape;
    private InnerHandler handler;
    private boolean animationStart = false;

    public ArrowShakeManager(Context context, ViewGroup viewGroup) {
        this.mContext = context;
        this.mRootView = viewGroup;
        this.arrowImg = new RecycleImageView(context);
        this.arrowImg.setImageResource(R.drawable.arrow_fcg);
        this.layoutParamsPortrait = this.getASMPortraitLayout();
        this.mRootView.addView((View)this.arrowImg, (ViewGroup.LayoutParams)this.layoutParamsPortrait);
        this.arrowImg.setVisibility(4);
        this.handler = new InnerHandler(this);
    }

    public void setInVisible() {
        if (this.arrowImg == null) {
            return;
        }
        if (this.animationIsRun) {
            this.endAnimation();
        }
        this.arrowImg.setVisibility(4);
    }

    public void showGuideArrow() {
        if (this.arrowImg == null) {
            return;
        }
        if (this.arrowImg.getVisibility() == 4 || this.arrowImg.getVisibility() == 8) {
            this.arrowImg.setVisibility(0);
        }
        if (!this.animationStart) {
            this.animationIsRun = true;
            this.animationStart = true;
            this.startAnimation();
        }
    }

    public void onOrientationChanges(boolean isLandscape) {
        if (isLandscape) {
            this.arrowImg.setLayoutParams((ViewGroup.LayoutParams)this.getASMLandscapeLayout());
        } else {
            this.arrowImg.setLayoutParams((ViewGroup.LayoutParams)this.getASMPortraitLayout());
        }
    }

    private void endAnimation() {
        this.animationIsRun = false;
        this.animationStart = false;
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
        }
    }

    private void startAnimation() {
        ObjectAnimator objectAnimator = this.shakeAnimator((View)this.arrowImg);
        objectAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (ArrowShakeManager.this.animationIsRun && ArrowShakeManager.this.handler != null) {
                    ArrowShakeManager.this.handler.sendEmptyMessage(0);
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        objectAnimator.start();
    }

    private ObjectAnimator shakeAnimator(View view) {
        int delta = (int)ResolutionUtils.convertDpToPixel(5.0f, this.mContext);
        PropertyValuesHolder pvhTranslateY = PropertyValuesHolder.ofKeyframe((Property)View.TRANSLATION_Y, (Keyframe[])new Keyframe[]{Keyframe.ofFloat((float)0.0f, (float)0.0f), Keyframe.ofFloat((float)0.1f, (float)delta), Keyframe.ofFloat((float)0.26f, (float)(-delta)), Keyframe.ofFloat((float)0.42f, (float)delta), Keyframe.ofFloat((float)0.58f, (float)(-delta)), Keyframe.ofFloat((float)0.74f, (float)delta), Keyframe.ofFloat((float)0.9f, (float)(-delta)), Keyframe.ofFloat((float)1.0f, (float)0.0f)});
        return ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{pvhTranslateY}).setDuration(1000L);
    }

    private RelativeLayout.LayoutParams getASMPortraitLayout() {
        if (this.layoutParamsPortrait == null) {
            this.layoutParamsPortrait = new RelativeLayout.LayoutParams(-2, -2);
            this.layoutParamsPortrait.addRule(12);
            this.layoutParamsPortrait.addRule(11);
            this.layoutParamsPortrait.rightMargin = (int)ResolutionUtils.convertDpToPixel(55.0f, this.mContext);
            this.layoutParamsPortrait.bottomMargin = (int)ResolutionUtils.convertDpToPixel(161.0f, this.mContext);
        }
        return this.layoutParamsPortrait;
    }

    private RelativeLayout.LayoutParams getASMLandscapeLayout() {
        if (this.layoutParamsLandscape == null) {
            this.layoutParamsLandscape = new RelativeLayout.LayoutParams(-2, -2);
            this.layoutParamsLandscape.addRule(12);
            this.layoutParamsLandscape.addRule(11);
            this.layoutParamsLandscape.rightMargin = (int)ResolutionUtils.convertDpToPixel(55.0f, this.mContext);
            this.layoutParamsLandscape.bottomMargin = (int)ResolutionUtils.convertDpToPixel(200.0f, this.mContext);
        }
        return this.layoutParamsLandscape;
    }

    static class InnerHandler
    extends SafeDispatchHandler {
        WeakReference<ArrowShakeManager> wr;

        public InnerHandler(ArrowShakeManager gc) {
            this.wr = new WeakReference<ArrowShakeManager>(gc);
        }

        public void handleMessage(Message msg) {
            if (this.wr != null) {
                ArrowShakeManager stec = (ArrowShakeManager)this.wr.get();
                stec.startAnimation();
            }
        }
    }
}

