/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.yy.mobile.framework.R;

public class CustomGridLayout
extends ViewGroup {
    private static final String TAG = "MyGridLayout";
    int margin = 2;
    int colums = 2;
    private int mMaxChildWidth = 0;
    private int mMaxChildHeight = 0;
    int count = 0;
    GridAdatper adapter;

    public CustomGridLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.CustomGridLayout);
            this.colums = a.getInteger(R.styleable.CustomGridLayout_gridColumns, 2);
            this.margin = (int)a.getDimension(R.styleable.CustomGridLayout_gridMargin, 2.0f);
            a.recycle();
        }
    }

    public CustomGridLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CustomGridLayout(Context context) {
        this(context, null);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mMaxChildWidth = 0;
        this.mMaxChildHeight = 0;
        int modeW = 0;
        int modeH = 0;
        if (View.MeasureSpec.getMode((int)widthMeasureSpec) != 0) {
            modeW = 0;
        }
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) != 0) {
            modeH = 0;
        }
        int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)widthMeasureSpec), (int)modeW);
        int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)heightMeasureSpec), (int)modeH);
        this.count = this.getChildCount();
        if (this.count == 0) {
            super.onMeasure(childWidthMeasureSpec, childHeightMeasureSpec);
            return;
        }
        for (int i = 0; i < this.count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            this.mMaxChildWidth = Math.max(this.mMaxChildWidth, child.getMeasuredWidth());
            this.mMaxChildHeight = Math.max(this.mMaxChildHeight, child.getMeasuredHeight());
        }
        this.setMeasuredDimension(CustomGridLayout.resolveSize((int)this.mMaxChildWidth, (int)widthMeasureSpec), CustomGridLayout.resolveSize((int)this.mMaxChildHeight, (int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int rows;
        int height = b - t;
        int width = r - l;
        int n = rows = this.count % this.colums == 0 ? this.count / this.colums : this.count / this.colums + 1;
        if (this.count == 0) {
            return;
        }
        int gridW = (width - this.margin * (this.colums - 1)) / this.colums;
        int gridH = (height - this.margin * rows) / rows;
        int left = 0;
        int top = this.margin;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < this.colums; ++j) {
                View child = this.getChildAt(i * this.colums + j);
                if (child == null) {
                    return;
                }
                left = j * gridW + j * this.margin;
                if (gridW != child.getMeasuredWidth() || gridH != child.getMeasuredHeight()) {
                    child.measure(View.MeasureSpec.makeMeasureSpec((int)gridW, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)gridH, (int)0x40000000));
                }
                child.layout(left, top, left + gridW, top + gridH);
            }
            top += gridH + this.margin;
        }
    }

    public void setGridAdapter(GridAdatper adapter) {
        this.adapter = adapter;
        int size = adapter.getCount();
        for (int i = 0; i < size; ++i) {
            this.addView(adapter.getView(i));
        }
    }

    public void setOnItemClickListener(final OnItemClickListener click) {
        if (this.adapter == null) {
            return;
        }
        for (int i = 0; i < this.adapter.getCount(); ++i) {
            final int index = i;
            View view = this.getChildAt(i);
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    click.onItemClick(v, index);
                }
            });
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(View var1, int var2);
    }

    public static interface GridAdatper {
        public View getView(int var1);

        public int getCount();
    }
}

