/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.pref2;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.log.MLog;
import java.io.File;
import java.util.HashMap;

public class SharedPreferencesUtils {
    private static final HashMap<String, SharedPreferences> sSharedPrefs = new HashMap();
    private static volatile File sSharedPrefDir = null;
    private static SharedPreferences mDefaultPrf;
    private static final String DEFAULT_PRF_NAME = "default";

    private static File getSharedPrefsFile(Context context, String name) {
        if (sSharedPrefDir != null) {
            return new File(sSharedPrefDir, name + ".xml");
        }
        ApplicationInfo info = context.getApplicationContext() == null ? context.getApplicationInfo() : context.getApplicationContext().getApplicationInfo();
        File dir = new File(info.dataDir);
        MLog.info("SharedPreferencesUtils", dir.toString(), new Object[0]);
        File sharedPrefDir = new File(dir, "/shared_prefs");
        if (!sharedPrefDir.exists()) {
            if (sharedPrefDir.mkdir()) {
                sSharedPrefDir = sharedPrefDir;
            }
        } else {
            sSharedPrefDir = sharedPrefDir;
        }
        return new File(sharedPrefDir, name + ".xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SharedPreferences getDefaultPrf() {
        if (mDefaultPrf != null) return mDefaultPrf;
        Class<SharedPreferencesUtils> clazz = SharedPreferencesUtils.class;
        synchronized (SharedPreferencesUtils.class) {
            if (mDefaultPrf != null) return mDefaultPrf;
            mDefaultPrf = SharedPreferencesUtils.getSharedPreferences(BasicConfig.getInstance().getAppContext(), DEFAULT_PRF_NAME, 0);
            // ** MonitorExit[var0] (shouldn't be in output)
            return mDefaultPrf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SharedPreferences getSharedPreferences(Context context, String name, int mode) {
        SharedPreferences sp;
        HashMap<String, SharedPreferences> hashMap = sSharedPrefs;
        synchronized (hashMap) {
            sp = sSharedPrefs.get(name);
            if (sp == null) {
                if (context == null) {
                    MLog.error((Object)"SharedPreferencesUtils", "context is null", new Throwable(), new Object[0]);
                    Context tmp = BasicConfig.getInstance().getAppContext();
                    if (tmp == null) {
                        MLog.error((Object)"SharedPreferencesUtils", "context is still null", new Throwable(), new Object[0]);
                        tmp = YYActivityManager.INSTANCE.getApplication();
                    }
                    sp = tmp.getSharedPreferences(name, mode);
                } else {
                    sp = context.getSharedPreferences(name, mode);
                }
                sSharedPrefs.put(name, sp);
                return sp;
            }
        }
        return sp;
    }
}

