/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http.dns;

import com.yy.mobile.http.dns.CommonUtilsKt;
import com.yy.mobile.http.dns.NetStackCheck;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.channels.DatagramChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u0006\u0010\u001e\u001a\u00020\u001dJ\u0006\u0010\u001f\u001a\u00020\u001dJ\u0006\u0010 \u001a\u00020\u001dJ\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u0006\u0010\"\u001a\u00020\u001dJ\u0006\u0010#\u001a\u00020\u001dJ\u0006\u0010$\u001a\u00020\u001dJ\u0010\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020'H\u0002J\u0019\u0010(\u001a\u00020\u00112\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040*\u00a2\u0006\u0002\u0010+J\u000e\u0010,\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u0004J&\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015H\u0002J\u0010\u0010/\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u0004H\u0002J\u0010\u00100\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/yy/mobile/http/dns/NetStackCheck;", "", "()V", "ALI_DNS", "", "ALI_V4_0", "ALI_V4_1", "ALI_V6_0", "ALI_V6_1", "BUF_SIZE", "", "PORT", "TIME_OUT", "asyncCheckCurrentStack", "Lio/reactivex/Single;", "Lcom/yy/mobile/http/dns/CommonUtilsKt$IP;", "decodeDNSMessage", "", "input", "Ljava/io/DataInputStream;", "ipList", "", "encodeDNSMessage", "output", "Ljava/io/DataOutputStream;", "domainName", "encodeDomainName", "haveV4Async", "Lio/reactivex/Observable;", "", "haveV4sync", "haveV4syncExThrow", "haveV4syncThrow", "haveV6Aync", "haveV6sync", "haveV6syncExThrow", "haveV6syncThrow", "longToIp", "ip", "", "main", "args", "", "([Ljava/lang/String;)V", "ping", "query", "dnsServerIP", "queryDns", "skipDomainName", "framework_release"})
public final class NetStackCheck {
    private static final int TIME_OUT = 5000;
    private static final int PORT = 53;
    private static final int BUF_SIZE = 8192;
    private static final String ALI_DNS = "alidns.com";
    private static final String ALI_V4_0 = "223.5.5.5";
    private static final String ALI_V4_1 = "223.6.6.6";
    private static final String ALI_V6_0 = "2400:3200::1";
    private static final String ALI_V6_1 = "2400:3200:baba::1";
    public static final NetStackCheck INSTANCE;

    public final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        String[] stringArray = args;
        boolean bl = false;
        boolean bl2 = false;
        String[] it = stringArray;
        boolean bl3 = false;
        ArrayList ipList = new ArrayList();
        try {
            this.query(ALI_V4_0, ALI_DNS, ipList);
        }
        catch (SocketTimeoutException ex) {
            String string = "Timeout";
            boolean bl4 = false;
            System.out.println((Object)string);
        }
        catch (IOException ex) {
            String string = "Unexpected IOException: " + ex;
            boolean bl5 = false;
            System.out.println((Object)string);
            ex.printStackTrace(System.out);
        }
        boolean bl6 = false;
        System.out.println();
    }

    public final boolean haveV4sync() {
        return this.queryDns(ALI_V4_0);
    }

    public final boolean haveV4syncThrow() throws IOException {
        ArrayList ipList = new ArrayList();
        this.query(ALI_V4_0, ALI_DNS, ipList);
        Collection collection = ipList;
        boolean bl = false;
        return !collection.isEmpty();
    }

    public final boolean haveV6syncThrow() throws IOException {
        ArrayList ipList = new ArrayList();
        this.query(ALI_V6_0, ALI_DNS, ipList);
        Collection collection = ipList;
        boolean bl = false;
        return !collection.isEmpty();
    }

    public final boolean haveV6syncExThrow() throws IOException {
        boolean v6_0 = false;
        try {
            v6_0 = this.ping(ALI_V6_0);
            return v6_0;
        }
        catch (Throwable throwable) {
            boolean bl;
            try {
                bl = v6_0 = this.ping(ALI_V6_1);
            }
            catch (Throwable e) {
                bl = false;
            }
            return bl;
        }
    }

    public final boolean haveV4syncExThrow() throws IOException {
        boolean v4_0 = false;
        try {
            v4_0 = this.ping(ALI_V4_0);
            return v4_0;
        }
        catch (Throwable throwable) {
            boolean bl;
            try {
                bl = v4_0 = this.ping(ALI_V4_1);
            }
            catch (Throwable e) {
                bl = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean ping(@NotNull String ip) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)ip, (String)"ip");
        DatagramChannel dc = DatagramChannel.open();
        boolean state = false;
        Closeable closeable = dc;
        boolean bl = false;
        Throwable throwable = null;
        try {
            DatagramChannel dc2 = (DatagramChannel)closeable;
            boolean bl2 = false;
            int port = 53;
            dc2.configureBlocking(false);
            InetSocketAddress address = new InetSocketAddress(InetAddress.getByName(ip), port);
            dc2.connect(address);
            state = true;
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        dc.close();
        return state;
    }

    private final boolean queryDns(String ip) {
        boolean bl;
        try {
            ArrayList ipList = new ArrayList();
            this.query(ip, ALI_DNS, ipList);
            Collection collection = ipList;
            boolean bl2 = false;
            bl = !collection.isEmpty();
        }
        catch (Throwable t) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final Observable<Boolean> haveV4Async() {
        Observable observable = Observable.just((Object)"").subscribeOn(Schedulers.io()).flatMap((Function)haveV4Async.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Observable.just(\"\")\n    \u2026NotEmpty())\n            }");
        return observable;
    }

    public final boolean haveV6sync() {
        return this.queryDns(ALI_V6_0);
    }

    @NotNull
    public final Observable<Boolean> haveV6Aync() {
        Observable observable = Observable.just((Object)"").subscribeOn(Schedulers.io()).flatMap((Function)haveV6Aync.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Observable.just(\"\")\n    \u2026NotEmpty())\n            }");
        return observable;
    }

    @NotNull
    public final Single<CommonUtilsKt.IP> asyncCheckCurrentStack() {
        Single single = Single.create((SingleOnSubscribe)asyncCheckCurrentStack.1.INSTANCE).subscribeOn(Schedulers.io());
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.create(SingleOnSu\u2026scribeOn(Schedulers.io())");
        return single;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void query(String dnsServerIP, String domainName, List<String> ipList) throws IOException {
        block32: {
            DatagramSocket socket = new DatagramSocket(0);
            socket.setSoTimeout(5000);
            ByteArrayOutputStream outBuf = new ByteArrayOutputStream(8192);
            DataOutputStream output = new DataOutputStream(outBuf);
            ByteArrayInputStream inBufArray = null;
            DataInputStream input = null;
            this.encodeDNSMessage(output, domainName);
            InetAddress host = InetAddress.getByName(dnsServerIP);
            DatagramPacket request = new DatagramPacket(outBuf.toByteArray(), outBuf.size(), host, 53);
            socket.send(request);
            byte[] inBuf = new byte[8192];
            inBufArray = new ByteArrayInputStream(inBuf);
            input = new DataInputStream(inBufArray);
            DatagramPacket response = new DatagramPacket(inBuf, inBuf.length);
            socket.receive(response);
            this.decodeDNSMessage(input, ipList);
            try {
                input.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                inBufArray.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                output.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                outBuf.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            socket.close();
            break block32;
            catch (SocketTimeoutException socketTimeoutException) {
                try {
                    DataInputStream dataInputStream = input;
                    if (dataInputStream != null) {
                        dataInputStream.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    ByteArrayInputStream byteArrayInputStream = inBufArray;
                    if (byteArrayInputStream != null) {
                        byteArrayInputStream.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    output.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    outBuf.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                socket.close();
                catch (Throwable throwable) {
                    try {
                        DataInputStream dataInputStream = input;
                        if (dataInputStream != null) {
                            dataInputStream.close();
                        }
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    try {
                        ByteArrayInputStream byteArrayInputStream = inBufArray;
                        if (byteArrayInputStream != null) {
                            byteArrayInputStream.close();
                        }
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                    try {
                        output.close();
                    }
                    catch (Throwable throwable4) {
                        // empty catch block
                    }
                    try {
                        outBuf.close();
                    }
                    catch (Throwable throwable5) {
                        // empty catch block
                    }
                    socket.close();
                    throw throwable;
                }
            }
        }
    }

    private final void encodeDNSMessage(DataOutputStream output, String domainName) throws IOException {
        output.writeShort(1);
        output.writeShort(256);
        output.writeShort(1);
        output.writeShort(0);
        output.writeShort(0);
        output.writeShort(0);
        this.encodeDomainName(output, domainName);
        output.writeShort(1);
        output.writeShort(1);
        output.flush();
    }

    private final void encodeDomainName(DataOutputStream output, String domainName) throws IOException {
        String[] array;
        List list;
        boolean bl;
        Object object;
        CharSequence charSequence = domainName;
        String string = "\\.";
        int n = 0;
        string = new Regex(string);
        n = 0;
        boolean bl2 = false;
        List $this$dropLastWhile$iv = string.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl3 = false;
                object = it;
                bl = false;
                if (object.length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection collection = $this$toTypedArray$iv;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        for (String label : array = stringArray) {
            byte[] byArray;
            output.writeByte((byte)label.length());
            String string2 = label;
            DataOutputStream dataOutputStream = output;
            object = Charsets.UTF_8;
            bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string3.getBytes((Charset)object), (String)"(this as java.lang.String).getBytes(charset)");
            dataOutputStream.write(byArray);
        }
        output.writeByte(0);
    }

    /*
     * WARNING - void declaration
     */
    private final void decodeDNSMessage(DataInputStream input, List<String> ipList) throws IOException {
        input.skip(2L);
        input.skip(2L);
        input.skip(2L);
        short numberOfAnswer = input.readShort();
        input.skip(2L);
        input.skip(2L);
        this.skipDomainName(input);
        input.skip(2L);
        input.skip(2L);
        short s = 0;
        short s2 = numberOfAnswer;
        while (s < s2) {
            void i;
            input.mark(1);
            byte ahead = input.readByte();
            input.reset();
            if ((ahead & 0xC0) == 192) {
                input.skip(2L);
            } else {
                this.skipDomainName(input);
            }
            short type = input.readShort();
            input.skip(2L);
            input.skip(4L);
            short addrLen = input.readShort();
            if (type == 1 && addrLen == 4) {
                int addr = input.readInt();
                ipList.add(this.longToIp(addr));
            } else {
                input.skip(addrLen);
            }
            ++i;
        }
    }

    private final void skipDomainName(DataInputStream input) throws IOException {
        byte labelLength = 0;
        do {
            labelLength = input.readByte();
            input.skip(labelLength);
        } while (labelLength != 0);
    }

    private final String longToIp(long ip) {
        return String.valueOf(ip >> 24 & 0xFFL) + "." + (ip >> 16 & 0xFFL) + "." + (ip >> 8 & 0xFFL) + "." + (ip & 0xFFL);
    }

    private NetStackCheck() {
    }

    static {
        NetStackCheck netStackCheck;
        INSTANCE = netStackCheck = new NetStackCheck();
    }

    public static final /* synthetic */ void access$query(NetStackCheck $this, String dnsServerIP, String domainName, List ipList) {
        $this.query(dnsServerIP, domainName, ipList);
    }
}

