/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import android.text.TextUtils;
import com.yy.mobile.http.AbstractUploadRequest;
import com.yy.mobile.http.HttpLog;
import com.yy.mobile.http.ProgressListener;
import com.yy.mobile.http.RequestParam;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.http.form.RandomProgressStreamEntity;
import com.yy.mobile.http.form.RandomStreamToByte;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public class FileUploadRequest<String>
extends AbstractUploadRequest {
    public static final String DEFAULT_CHARSET = "utf-8";
    private String tag = "FileUploadRequest";
    protected File mFile;
    protected String mContentType = "application/octet-stream";
    protected String mCharset = "utf-8";
    protected long mStart;
    protected long mEnd;
    protected byte[] mRequestBodyByte;

    public FileUploadRequest(String url, RequestParam param, ResponseListener<String> successListener, ResponseErrorListener errorListener, File file) {
        this(url, param, successListener, errorListener, null, file);
    }

    public FileUploadRequest(String url, RequestParam param, ResponseListener<String> successListener, ResponseErrorListener errorListener, ProgressListener progressListener, File file) {
        super(url, param, successListener, errorListener, progressListener);
        this.mFile = file;
        if (this.mFile != null) {
            this.mEnd = this.mFile.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public RequestBody getRequestBody() {
        RequestBody requestBody;
        block25: {
            requestBody = null;
            RandomProgressStreamEntity entity = null;
            try {
                FileInputStream fileInputStream = new FileInputStream(this.mFile);
                entity = new RandomProgressStreamEntity(fileInputStream, this, this.mFile, this.mStart, this.mEnd);
            }
            catch (Throwable e) {
                HttpLog.e(e, "FilePostRequest getPostEntity error.", new Object[0]);
            }
            finally {
                try {
                    if (entity != null) {
                        entity.consumeContent();
                    }
                }
                catch (IOException e1) {
                    HttpLog.e(e1, "FilePostRequest consumeContent error.", new Object[0]);
                }
            }
            if (entity != null) {
                ByteArrayOutputStream result = new ByteArrayOutputStream((int)entity.getContentLength());
                entity.writeTo(result);
                if (this.getHeaders().get("Content-Tyrpe") != null && !TextUtils.isEmpty((CharSequence)this.getHeaders().get("Content-Type").toString())) {
                    this.mContentType = this.getHeaders().get("Content-Type").toString();
                }
                this.mRequestBodyByte = result.toByteArray();
                requestBody = RequestBody.create((MediaType)MediaType.parse((String)(this.mContentType + "; charset=" + this.mCharset)), (byte[])this.mRequestBodyByte);
                try {
                    result.close();
                }
                catch (Throwable e) {
                    HttpLog.e(this.tag, e);
                }
                break block25;
                catch (Throwable e) {
                    try {
                        HttpLog.e(this.tag, e);
                    }
                    catch (Throwable throwable) {
                        try {
                            result.close();
                        }
                        catch (Throwable e2) {
                            HttpLog.e(this.tag, e2);
                        }
                        throw throwable;
                    }
                    try {
                        result.close();
                    }
                    catch (Throwable e3) {
                        HttpLog.e(this.tag, e3);
                    }
                }
            }
        }
        return requestBody;
    }

    public void setContentType(String contentType) {
        this.mContentType = contentType;
    }

    public void setCharset(String charset) {
        this.mCharset = charset;
    }

    public void setStart(long start) {
        this.mStart = start;
    }

    public byte[] getRequestBodyByte() {
        if (this.mRequestBodyByte == null) {
            try {
                RandomStreamToByte randomStreamToByte = new RandomStreamToByte(this.mFile, this.mStart, this.mEnd);
                this.mRequestBodyByte = randomStreamToByte.writeTo();
            }
            catch (Throwable throwable) {
                HttpLog.e(this.tag, "getRequestBodyByte " + throwable);
            }
        }
        return this.mRequestBodyByte;
    }

    public void setEnd(long end) {
        if (end < this.mStart) {
            end = this.mStart;
        }
        if (end == 0L && this.mFile != null) {
            end = this.mFile.length();
        }
        this.mEnd = end;
    }
}

