/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.activity;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.yy.mobile.util.log.MLog;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public enum YYActivityManager {
    INSTANCE;

    public static final String TAG_LOG = "BaseActivity";
    public static final String TAG = "YYActivityManager";
    private Application mApplication;
    private Activity mActivity;
    private List<Application.ActivityLifecycleCallbacks> activityLifecycleCallbacks = new CopyOnWriteArrayList<Application.ActivityLifecycleCallbacks>();

    public void init(Application application) {
        this.mApplication = application;
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                MLog.info(YYActivityManager.TAG_LOG, "activity onCreate: %s", activity);
                YYActivityManager.this.setCurrentActivity(activity);
                for (Application.ActivityLifecycleCallbacks callback : YYActivityManager.this.activityLifecycleCallbacks) {
                    callback.onActivityCreated(activity, savedInstanceState);
                }
            }

            public void onActivityStarted(Activity activity) {
                for (Application.ActivityLifecycleCallbacks callback : YYActivityManager.this.activityLifecycleCallbacks) {
                    callback.onActivityStarted(activity);
                }
            }

            public void onActivityResumed(Activity activity) {
                MLog.info(YYActivityManager.TAG_LOG, "activity onResume: %s", activity);
                YYActivityManager.this.setCurrentActivity(activity);
                for (Application.ActivityLifecycleCallbacks callback : YYActivityManager.this.activityLifecycleCallbacks) {
                    callback.onActivityResumed(activity);
                }
            }

            public void onActivityPaused(Activity activity) {
                MLog.info(YYActivityManager.TAG_LOG, "activity onPause: %s", activity);
                for (Application.ActivityLifecycleCallbacks callback : YYActivityManager.this.activityLifecycleCallbacks) {
                    callback.onActivityPaused(activity);
                }
            }

            public void onActivityStopped(Activity activity) {
                for (Application.ActivityLifecycleCallbacks callback : YYActivityManager.this.activityLifecycleCallbacks) {
                    callback.onActivityStopped(activity);
                }
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                for (Application.ActivityLifecycleCallbacks callback : YYActivityManager.this.activityLifecycleCallbacks) {
                    callback.onActivitySaveInstanceState(activity, outState);
                }
            }

            public void onActivityDestroyed(Activity activity) {
                MLog.info(YYActivityManager.TAG_LOG, "activity onDestroy: %s", activity);
                if (YYActivityManager.this.isCurrentActivity(activity)) {
                    YYActivityManager.this.setCurrentActivity(null);
                }
                for (Application.ActivityLifecycleCallbacks callback : YYActivityManager.this.activityLifecycleCallbacks) {
                    callback.onActivityDestroyed(activity);
                }
            }
        });
    }

    public Application getApplication() {
        return this.mApplication;
    }

    public void registerActivityLifecycleCallbacks(Application.ActivityLifecycleCallbacks callback) {
        this.activityLifecycleCallbacks.add(callback);
    }

    public void unregisterActivityLifecycleCallbacks(Application.ActivityLifecycleCallbacks callback) {
        this.activityLifecycleCallbacks.remove(callback);
    }

    private boolean isCurrentActivity(Activity activity) {
        return activity == this.getCurrentActivity();
    }

    public Activity getCurrentActivity() {
        if (this.mActivity == null) {
            return null;
        }
        return this.mActivity;
    }

    public void setCurrentActivity(Activity activity) {
        MLog.info(TAG, "set current activity: %s", activity);
        if (activity == null) {
            this.mActivity = null;
        } else if (this.mActivity == null || this.mActivity != activity) {
            this.mActivity = activity;
        }
    }
}

