/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.yy.mobile.util.asynctask.ScheduledTask;
import java.lang.reflect.Field;

public class ImeUtil {
    public static void hideIME(Activity activity) {
        if (activity == null) {
            return;
        }
        View view = activity.getCurrentFocus();
        if (null != view) {
            ImeUtil.hideIME((Context)activity, view);
        }
    }

    public static void hideIME(Context context, View v) {
        if (context == null || v == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.hideSoftInputFromWindow(v.getWindowToken(), 0);
    }

    @SuppressLint(value={"PrivateApi"})
    public static void showIME(Activity activity, View view) {
        if (null == view && null == (view = activity.getCurrentFocus())) {
            return;
        }
        InputMethodManager input = (InputMethodManager)activity.getSystemService("input_method");
        if (input == null) {
            return;
        }
        try {
            Field mNextServedView = input.getClass().getDeclaredField("mNextServedView");
            mNextServedView.setAccessible(true);
            mNextServedView.set(input, view);
        }
        catch (Throwable error) {
            Log.e((String)"ImeUtil", (String)error.getMessage());
        }
        input.showSoftInput(view, 2);
    }

    public static void showIME(Activity activity, View view, int flag) {
        if (null == view && null == (view = activity.getCurrentFocus())) {
            return;
        }
        ((InputMethodManager)activity.getSystemService("input_method")).showSoftInput(view, flag);
    }

    public static void showIMEDelay(final Activity activity, final View view, long time) {
        ScheduledTask.getInstance().scheduledDelayed(new Runnable(){

            @Override
            public void run() {
                ImeUtil.showIME(activity, view);
            }
        }, time);
    }
}

