/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.ripple;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;

public class TouchEffectAnimator {
    private static final int EASE_ANIM_DURATION = 200;
    private static final int RIPPLE_ANIM_DURATION = 300;
    private static final int MAX_RIPPLE_ALPHA = 255;
    private View mView;
    private int mClipRadius;
    private boolean hasRippleEffect = false;
    private int animDuration = 200;
    private int requiredRadius;
    private float mDownX;
    private float mDownY;
    private float mRadius;
    private int mCircleAlpha = 255;
    private int mRectAlpha = 0;
    private Paint mCirclePaint = new Paint();
    private Paint mRectPaint = new Paint();
    private Path mCirclePath = new Path();
    private Path mRectPath = new Path();
    private boolean isTouchReleased = false;
    private boolean isAnimatingFadeIn = false;
    private RectF rectF = new RectF();
    private Animation.AnimationListener animationListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
            TouchEffectAnimator.this.isAnimatingFadeIn = true;
        }

        public void onAnimationEnd(Animation animation) {
            TouchEffectAnimator.this.isAnimatingFadeIn = false;
            if (TouchEffectAnimator.this.isTouchReleased) {
                TouchEffectAnimator.this.fadeOutEffect();
            }
        }

        public void onAnimationRepeat(Animation animation) {
        }
    };

    public TouchEffectAnimator(View mView) {
        this.mView = mView;
    }

    public void setHasRippleEffect(boolean hasRippleEffect) {
        this.hasRippleEffect = hasRippleEffect;
        if (hasRippleEffect) {
            this.animDuration = 300;
        }
    }

    public void setAnimDuration(int animDuration) {
        this.animDuration = animDuration;
    }

    public void setEffectColor(int effectColor) {
        this.mCirclePaint.setColor(effectColor);
        this.mCirclePaint.setAlpha(this.mCircleAlpha);
        this.mRectPaint.setColor(effectColor);
        this.mRectPaint.setAlpha(this.mRectAlpha);
    }

    public void setClipRadius(int mClipRadius) {
        this.mClipRadius = mClipRadius;
    }

    public void onTouchEvent(MotionEvent event) {
        if (event.getActionMasked() == 3) {
            this.isTouchReleased = true;
            if (!this.isAnimatingFadeIn) {
                this.fadeOutEffect();
            }
        }
        if (event.getActionMasked() == 1) {
            this.isTouchReleased = true;
            if (!this.isAnimatingFadeIn) {
                this.fadeOutEffect();
            }
        } else if (event.getActionMasked() == 0) {
            this.requiredRadius = this.mView.getWidth() > this.mView.getHeight() ? this.mView.getWidth() : this.mView.getHeight();
            this.requiredRadius = (int)((double)this.requiredRadius * 1.2);
            this.isTouchReleased = false;
            this.mDownX = event.getX();
            this.mDownY = event.getY();
            this.mCircleAlpha = 255;
            this.mRectAlpha = 0;
            ValueGeneratorAnim valueGeneratorAnim = new ValueGeneratorAnim(new InterpolatedTimeCallback(){

                @Override
                public void onTimeUpdate(float interpolatedTime) {
                    if (TouchEffectAnimator.this.hasRippleEffect) {
                        TouchEffectAnimator.this.mRadius = (float)TouchEffectAnimator.this.requiredRadius * interpolatedTime;
                    }
                    TouchEffectAnimator.this.mRectAlpha = (int)(interpolatedTime * 255.0f);
                    TouchEffectAnimator.this.mView.invalidate();
                }
            });
            valueGeneratorAnim.setInterpolator((Interpolator)new DecelerateInterpolator());
            valueGeneratorAnim.setDuration(this.animDuration);
            valueGeneratorAnim.setAnimationListener(this.animationListener);
            this.mView.startAnimation((Animation)valueGeneratorAnim);
        }
    }

    public void onDraw(Canvas canvas) {
        if (this.hasRippleEffect) {
            this.mCirclePath.reset();
            this.mCirclePaint.setAlpha(this.mCircleAlpha);
            this.rectF.set(0.0f, 0.0f, (float)this.mView.getWidth(), (float)this.mView.getHeight());
            this.mCirclePath.addRoundRect(this.rectF, (float)this.mClipRadius, (float)this.mClipRadius, Path.Direction.CW);
            canvas.clipPath(this.mCirclePath);
            canvas.drawCircle(this.mDownX, this.mDownY, this.mRadius, this.mCirclePaint);
        }
        this.mRectPath.reset();
        if (this.hasRippleEffect && this.mCircleAlpha != 255) {
            this.mRectAlpha = this.mCircleAlpha / 2;
        }
        this.mRectPaint.setAlpha(this.mRectAlpha);
        this.rectF.set(0.0f, 0.0f, (float)this.mView.getWidth(), (float)this.mView.getHeight());
        canvas.drawRoundRect(this.rectF, (float)this.mClipRadius, (float)this.mClipRadius, this.mRectPaint);
    }

    private void fadeOutEffect() {
        ValueGeneratorAnim valueGeneratorAnim = new ValueGeneratorAnim(new InterpolatedTimeCallback(){

            @Override
            public void onTimeUpdate(float interpolatedTime) {
                TouchEffectAnimator.this.mCircleAlpha = (int)(255.0f - 255.0f * interpolatedTime);
                TouchEffectAnimator.this.mRectAlpha = TouchEffectAnimator.this.mCircleAlpha;
                TouchEffectAnimator.this.mView.invalidate();
            }
        });
        valueGeneratorAnim.setDuration(this.animDuration);
        this.mView.startAnimation((Animation)valueGeneratorAnim);
    }

    static interface InterpolatedTimeCallback {
        public void onTimeUpdate(float var1);
    }

    class ValueGeneratorAnim
    extends Animation {
        private InterpolatedTimeCallback interpolatedTimeCallback;

        ValueGeneratorAnim(InterpolatedTimeCallback interpolatedTimeCallback) {
            this.interpolatedTimeCallback = interpolatedTimeCallback;
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            this.interpolatedTimeCallback.onTimeUpdate(interpolatedTime);
        }
    }
}

