/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.imageloader;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.ExifInterface;
import android.os.Build;
import android.view.View;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.Cache;
import com.yy.mobile.http.DiskCache;
import com.yy.mobile.http.HttpLog;
import com.yy.mobile.http.httpsparser.HttpsParser;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import java.io.File;

public class ImageUtil {
    private static Cache sCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initDiskCache(String cacheDir) {
        Class<Cache> clazz = Cache.class;
        synchronized (Cache.class) {
            if (sCache == null) {
                sCache = new DiskCache(DiskCache.getCacheDir(BasicConfig.getInstance().getAppContext(), cacheDir), 0x1400000L, 0.15f);
                sCache.initialize();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Cache getCache() {
        return sCache;
    }

    private static String getCacheKey(String url, int width, int height) {
        String convertUrl = HttpsParser.convertToHttps(url);
        return new StringBuilder(convertUrl.length() + 12).append("#W").append(width).append("#H").append(height).append(convertUrl).toString();
    }

    public static void loadImageResource(int resource, RecycleImageView recycleImageView, ImageConfig imageConfig) {
        if (recycleImageView == null) {
            HttpLog.e("recycleImageView is null", new Object[0]);
            return;
        }
        BitmapDrawable resourceDrawable = ImageUtil.getBitmapDrawableFromResource(imageConfig.getImagePrecision().getWidth(), imageConfig.getImagePrecision().getHeight(), resource);
        recycleImageView.setImageDrawable((Drawable)resourceDrawable);
    }

    public static void loadImageResource(String resource, RecycleImageView recycleImageView, ImageConfig imageConfig, int blankBitmapResource) {
        if (recycleImageView == null) {
            HttpLog.e("recycleImageView is null", new Object[0]);
            return;
        }
        int resourceId = BasicConfig.getInstance().getAppContext().getResources().getIdentifier(resource, "drawable", BasicConfig.getInstance().getAppContext().getPackageName());
        if (resourceId == 0) {
            resourceId = blankBitmapResource;
        }
        BitmapDrawable resourceDrawable = ImageUtil.getBitmapDrawableFromResource(imageConfig.getImagePrecision().getWidth(), imageConfig.getImagePrecision().getHeight(), resourceId);
        recycleImageView.setImageDrawable((Drawable)resourceDrawable);
    }

    public static void loadImageBackgroundResource(int resource, View view, ImageConfig imageConfig) {
        if (view == null) {
            return;
        }
        BitmapDrawable resourceDrawable = ImageUtil.getBitmapDrawableFromResource(imageConfig.getImagePrecision().getWidth(), imageConfig.getImagePrecision().getHeight(), resource);
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground((Drawable)resourceDrawable);
        } else {
            view.setBackgroundDrawable((Drawable)resourceDrawable);
        }
    }

    public static void loadImageBackgroundResource(String resource, View view, ImageConfig imageConfig, int blankBitmapResource) {
        if (view == null) {
            return;
        }
        int resourceId = BasicConfig.getInstance().getAppContext().getResources().getIdentifier(resource, "drawable", BasicConfig.getInstance().getAppContext().getPackageName());
        if (resourceId == 0) {
            resourceId = blankBitmapResource;
        }
        BitmapDrawable resourceDrawable = ImageUtil.getBitmapDrawableFromResource(imageConfig.getImagePrecision().getWidth(), imageConfig.getImagePrecision().getHeight(), resourceId);
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground((Drawable)resourceDrawable);
        } else {
            view.setBackgroundDrawable((Drawable)resourceDrawable);
        }
    }

    public static void loadImageBackgroundResource(String resource, RecycleImageView recycleImageView, ImageConfig imageConfig, int blankBitmapResource) {
        if (recycleImageView == null) {
            HttpLog.e("recycleImageView is null", new Object[0]);
            return;
        }
        int resourceId = BasicConfig.getInstance().getAppContext().getResources().getIdentifier(resource, "drawable", BasicConfig.getInstance().getAppContext().getPackageName());
        if (resourceId == 0) {
            resourceId = blankBitmapResource;
        }
        BitmapDrawable resourceDrawable = ImageUtil.getBitmapDrawableFromResource(imageConfig.getImagePrecision().getWidth(), imageConfig.getImagePrecision().getHeight(), resourceId);
        recycleImageView.setBackgroundDrawable((Drawable)resourceDrawable);
    }

    public static BitmapDrawable getBitmapDrawableFromResource(int imageWidth, int imageHeight, int loadingBitmapResource) {
        String key = ImageUtil.getCacheKey(String.valueOf(loadingBitmapResource), imageWidth, imageHeight);
        BitmapDrawable loadingBitmapDrawable = ImageLoader.getBitmapFromCache(key);
        if (loadingBitmapDrawable == null && loadingBitmapResource > 0) {
            Bitmap loadingBitmap = ImageUtil.decodeSampledBitmapFromResourceId(BasicConfig.getInstance().getAppContext(), loadingBitmapResource, imageWidth, imageHeight, null);
            loadingBitmapDrawable = Build.VERSION.SDK_INT > 11 ? new BitmapDrawable(BasicConfig.getInstance().getAppContext().getResources(), loadingBitmap) : new BitmapDrawable(BasicConfig.getInstance().getAppContext().getResources(), loadingBitmap);
            if (loadingBitmap != null) {
                ImageLoader.addBitmapToCache(key, loadingBitmapDrawable);
            }
        }
        return loadingBitmapDrawable;
    }

    public static BitmapDrawable getBitmapDrawableFromResource(int loadingBitmapResource, ImageConfig config) {
        String key = ImageUtil.getCacheKey(String.valueOf(loadingBitmapResource), config.getImagePrecision().getWidth(), config.getImagePrecision().getHeight());
        BitmapDrawable loadingBitmapDrawable = ImageLoader.getBitmapFromCache(key);
        if (loadingBitmapDrawable == null && loadingBitmapResource > 0) {
            Bitmap loadingBitmap = ImageUtil.decodeSampledBitmapFromResourceId(BasicConfig.getInstance().getAppContext(), loadingBitmapResource, config);
            loadingBitmapDrawable = Build.VERSION.SDK_INT > 11 ? new BitmapDrawable(BasicConfig.getInstance().getAppContext().getResources(), loadingBitmap) : new BitmapDrawable(BasicConfig.getInstance().getAppContext().getResources(), loadingBitmap);
            if (loadingBitmap != null) {
                ImageLoader.addBitmapToCache(key, loadingBitmapDrawable);
            }
        }
        return loadingBitmapDrawable;
    }

    public static Bitmap decodeSampledBitmapFile(String path, ImageConfig config) {
        return ImageUtil.decodeSampledBitmapFile(path, config, false);
    }

    public static Bitmap decodeSampledBitmapFile(String path, ImageConfig config, boolean rorate) {
        if (path == null || path.length() == 0) {
            if (HttpLog.isDebug()) {
                HttpLog.d("DecodeSampledBitmapFile path is empty", new Object[0]);
            }
            return null;
        }
        File file = new File(path);
        if (!file.exists()) {
            if (HttpLog.isDebug()) {
                HttpLog.d("DecodeSampledBitmapFile file not exists", new Object[0]);
            }
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = config.getImageTransparency().getBitmapConfig();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)file.getPath(), (BitmapFactory.Options)options);
        options.inSampleSize = ImageUtil.calculateInSampleSize(options, config.getImagePrecision().getWidth(), config.getImagePrecision().getHeight());
        options.inJustDecodeBounds = false;
        Bitmap bitmap = null;
        try {
            bitmap = BitmapFactory.decodeFile((String)file.getPath(), (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError e) {
            HttpLog.e(e, "Decode file oom.", new Object[0]);
            System.gc();
        }
        if (rorate) {
            bitmap = ImageUtil.rorateBitmap(path, bitmap);
        }
        return bitmap;
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            int n = inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
            if (inSampleSize <= 0) {
                inSampleSize = 1;
            }
            float totalPixels = width * height;
            float totalReqPixelsCap = reqWidth * reqHeight * 2;
            while (totalPixels / (float)(inSampleSize * inSampleSize) > totalReqPixelsCap || ImageUtil.isBitmapOverSize(inSampleSize, width, height)) {
                ++inSampleSize;
            }
        }
        return inSampleSize;
    }

    public static Bitmap rorateBitmap(String filePath, Bitmap bitmap) {
        Bitmap resizedBitmap = null;
        try {
            ExifInterface exif = new ExifInterface(filePath);
            int orientation = exif.getAttributeInt("Orientation", 1);
            Matrix matrix = new Matrix();
            int rotate = 0;
            switch (orientation) {
                case 8: {
                    rotate = 270;
                    break;
                }
                case 3: {
                    rotate = 180;
                    break;
                }
                case 6: {
                    rotate = 90;
                    break;
                }
                case 5: {
                    rotate = 45;
                    break;
                }
            }
            matrix.postRotate((float)rotate);
            resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)false);
        }
        catch (Exception e) {
            HttpLog.e(e, "RotateBitmap error", new Object[0]);
            return bitmap;
        }
        return resizedBitmap;
    }

    public static boolean isBitmapOverSize(int sampleSize, int width, int height) {
        int correctSampleSize = sampleSize;
        if (sampleSize > 2) {
            correctSampleSize = sampleSize / 2 * 2;
        }
        return width / correctSampleSize > 4096 || height / correctSampleSize > 4096;
    }

    public static Bitmap decodeSampledBitmapFromResourceId(Context context, int resourceId, ImageConfig config) {
        return ImageUtil.decodeSampledBitmapFromResourceId(context, resourceId, config.getImagePrecision().getWidth(), config.getImagePrecision().getHeight(), config);
    }

    public static Bitmap decodeSampledBitmapFromResourceId(Context context, int resourceId, int reqWidth, int reqHeight, ImageConfig imageConfig) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inPreferredConfig = imageConfig != null ? imageConfig.getImageTransparency().getBitmapConfig() : Bitmap.Config.RGB_565;
        BitmapFactory.decodeResource((Resources)context.getResources(), (int)resourceId, (BitmapFactory.Options)options);
        options.inSampleSize = ImageUtil.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        try {
            return BitmapFactory.decodeResource((Resources)context.getResources(), (int)resourceId, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError e) {
            HttpLog.e(e, "decodeSampledBitmapFromResourceId oom.", new Object[0]);
            System.gc();
            return null;
        }
    }

    public static Bitmap decodeSampledBitmapFromByteArray(byte[] bytes, int reqWidth, int reqHeight, Object cache, ImageConfig imageConfig) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inPreferredConfig = imageConfig != null ? imageConfig.getImageTransparency().getBitmapConfig() : Bitmap.Config.RGB_565;
        BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
        options.inSampleSize = ImageUtil.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        if (Build.VERSION.SDK_INT > 11) {
            ImageUtil.addInBitmapOptions(options, cache);
        }
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
    }

    @TargetApi(value=11)
    private static void addInBitmapOptions(BitmapFactory.Options options, Object cache) {
    }

    public static Bitmap decodeSampledBitmapFromByteArray(byte[] bytes, ImageConfig imageConfig) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inPreferredConfig = imageConfig != null ? imageConfig.getImageTransparency().getBitmapConfig() : Bitmap.Config.RGB_565;
        BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
        options.inSampleSize = imageConfig == null ? ImageUtil.calculateInSampleSize(options, ImageConfig.defaultImageConfig().getImagePrecision().getWidth(), ImageConfig.defaultImageConfig().getImagePrecision().getHeight()) : ImageUtil.calculateInSampleSize(options, imageConfig.getImagePrecision().getWidth(), imageConfig.getImagePrecision().getHeight());
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
    }

    public static int getBitmapSize(Bitmap bitmap) {
        if (bitmap == null) {
            return 0;
        }
        if (Build.VERSION.SDK_INT > 12) {
            return bitmap.getByteCount();
        }
        return bitmap.getRowBytes() * bitmap.getHeight();
    }
}

