/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http.form;

import com.yy.mobile.http.HttpLog;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RandomStreamToByte {
    protected static final int BUFFER_SIZE = 2048;
    protected static final long DEFAULT_PROGRESS_PERCENT = 100L;
    protected final long length;
    protected final RandomAccessFile mRaf;
    protected final long mStart;
    protected final long mEnd;
    protected long progressStep;
    protected long progressPercent = 100L;
    protected final FileInputStream inStream;

    public RandomStreamToByte(File file, long start, long end) throws FileNotFoundException {
        if (start < 0L) {
            throw new IllegalArgumentException("Start index could not less than 0");
        }
        if (end <= 0L) {
            throw new IllegalArgumentException("End index must be more than 0");
        }
        if (end <= start) {
            throw new IllegalArgumentException("End index could not less than start");
        }
        this.length = end - start;
        this.inStream = new FileInputStream(file);
        this.mRaf = new RandomAccessFile(file, "rwd");
        this.mStart = start;
        this.mEnd = end;
    }

    public long getContentLength() {
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] writeTo() throws IOException {
        byte[] fileByte = null;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream((int)this.length);
        byte[] buffer = new byte[2048];
        long chunkSize = this.length / this.progressPercent;
        long progress = 0L;
        try {
            if (this.length < 0L) {
                int l;
                while ((l = this.inStream.read(buffer)) != -1) {
                    outStream.write(buffer, 0, l);
                }
            } else {
                int l;
                long remaining = this.length;
                this.mRaf.seek(this.mStart);
                while (remaining > 0L && (l = this.mRaf.read(buffer, 0, (int)Math.min(2048L, remaining))) != -1) {
                    outStream.write(buffer, 0, l);
                    remaining -= (long)l;
                    progress += (long)l;
                    if (!this.needProgress(l, this.length, chunkSize) || !HttpLog.isDebug()) continue;
                    HttpLog.d("RamdomProgressStreamEntity progress=%d,total=%d", progress, this.length);
                }
            }
            fileByte = outStream.toByteArray();
        }
        catch (IOException e) {
            HttpLog.i("RandomStreamToByte", e);
        }
        finally {
            this.mRaf.close();
            this.inStream.close();
            outStream.close();
        }
        return fileByte;
    }

    public boolean needProgress(long progress, long total, long chunkSize) {
        this.progressStep += progress;
        if (this.progressStep > chunkSize || progress >= total) {
            this.progressStep = 0L;
            return true;
        }
        return false;
    }
}

