/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.log;

import android.os.Build;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.guid.GuidFactory;
import com.yy.mobile.perf.PerfSDK;
import com.yy.mobile.perf.loggable.LogReporter;
import com.yy.mobile.perf.loggable.model.CommonLogData;
import com.yy.mobile.ui.utils.DateUtils;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.VersionUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import java.util.Date;

public class PerfLog {
    private static long mUid = 0L;
    private static String mPhone = "";
    private static final String TAG = "PerfLog";

    public static synchronized void init(long uid, String phone) {
        mUid = uid;
        mPhone = phone;
    }

    public static void webLog(final String tag, final String s) {
        YYTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                CommonLogData logdata = PerfLog.constructData(tag, s);
                PerfLog.report(logdata);
            }
        });
    }

    private static CommonLogData constructData(String tag, String s) {
        CommonLogData logData = new CommonLogData();
        logData.scode = 50062;
        logData.devId = GuidFactory.getInstance().getGuid();
        logData.model = Build.MANUFACTURER + "_" + Build.MODEL;
        logData.plat = "android";
        logData.osVer = Build.VERSION.RELEASE;
        logData.net = NetworkUtils.getNetworkName(BasicConfig.getInstance().getAppContext());
        logData.uid = mUid;
        logData.phoneNum = mPhone;
        logData.app = "YYLive";
        logData.ver = VersionUtil.getLocalVer(BasicConfig.getInstance().getAppContext()).toString();
        logData.time = DateUtils.dateToString(new Date(), "yyyy-MM-dd HH:mm:ss");
        logData.addInfoItem(tag, s);
        return logData;
    }

    private static void report(CommonLogData logDate) {
        PerfSDK.instance().reportCommonLog(logDate, new LogReporter.Callback(){

            public void onError(Exception e) {
                MLog.error((Object)PerfLog.TAG, "PerfLog webLog exception:%s", e.getMessage());
            }

            public void onSuccess() {
                MLog.debug(PerfLog.TAG, "PerfLog webLog success", new Object[0]);
            }
        });
    }
}

