/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.log;

import android.text.TextUtils;
import android.util.Log;
import com.unionyy.mobile.spdt.Spdt;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.CommonUtils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.LogManager;
import com.yy.mobile.util.log.PerfLog;
import com.yy.mobile.util.log.SpdtLogInit;
import com.yy.mobile.util.log.logger.GeneralLogger;
import com.yy.mobile.util.log.logger.Utils;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tv.athena.core.axis.Axis;
import tv.athena.klog.api.ILogConfig;
import tv.athena.klog.api.ILogService;
import tv.athena.klog.api.KLog;

public class MLog {
    public static final int MAX_FILE_SIZE = 5;
    public static final int DEFAULT_BAK_FILE_NUM_LIMIT = 5;
    public static final int DEFAULT_BUFF_SIZE = 32768;
    private static volatile LogOptions sOptions = new LogOptions();
    private static volatile String sDir;
    private static volatile boolean isProcessIdle;
    private static String PATTERN_STR;
    private static Pattern PATTERN;
    private static final String BAK_EXT = ".bak";
    private static final String BAK_DATE_FORMAT_STR = "-yyyyMMdd-kkmmss.SSS";

    public static String getCurrentLogFile() {
        ILogService service = (ILogService)Axis.Companion.getService(ILogService.class);
        if (service == null) {
            return "";
        }
        File[] array = service.fileLogList();
        if (array != null && array.length > 0) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (!LogManager.getInstance().containsPattern(array[i])) continue;
                return array[i].getAbsolutePath();
            }
        }
        return "";
    }

    public static boolean initialize(String directory, LogOptions options) {
        if (options == null) {
            options = new LogOptions();
        }
        sOptions = options;
        MLog.sOptions.logIdentifier = MLog.sOptions.logFileName.substring(0, MLog.sOptions.logFileName.indexOf("."));
        if (Utils.isEmpty(directory).booleanValue() || Utils.isEmpty(MLog.sOptions.logIdentifier).booleanValue()) {
            return false;
        }
        ILogConfig config = ((ILogService)Axis.Companion.getService(ILogService.class)).config();
        if (config != null) {
            config.logCacheMaxSiz(0x6400000L).singleLogMaxSize(0x400000).logLevel(MLog.sOptions.logLevel).processTag(MLog.sOptions.logIdentifier).logPath(directory);
            if (((SpdtLogInit)Spdt.of(SpdtLogInit.class)).needEncryption()) {
                config.publicKey("9f7af9d4f8e9210e5e9be21a56b8b4c7372612caeb494ba6abe9d58e4df816f448aa950ce3de9584d3592b8acafe2eeb8b63df9b1fd2df16eff80f08c38c0e3b");
            }
            config.apply();
        }
        sDir = directory;
        return true;
    }

    public static void notifyProcessIdle(boolean state) {
        isProcessIdle = state;
    }

    public static void setMainLogger(String dir, GeneralLogger mainLogger) {
    }

    public static void verbose(Object obj, String format, Object ... args) {
        KLog.v((String)String.valueOf(obj), (String)String.valueOf(format), (Object[])args);
    }

    @Deprecated
    public static void verboseWithoutLineNumber(Object obj, String format, Object ... args) {
        KLog.v((String)String.valueOf(obj), (String)String.valueOf(format), (Object[])args);
    }

    public static void debug(Object obj, String format, Object ... args) {
        KLog.d((String)String.valueOf(obj), (String)String.valueOf(format), (Object[])args);
    }

    @Deprecated
    public static void debugWithoutLineNumber(Object obj, String format, Object ... args) {
        KLog.d((String)String.valueOf(obj), (String)String.valueOf(format), (Object[])args);
    }

    public static void info(Object obj, String format, Object ... args) {
        KLog.i((String)String.valueOf(obj), (String)String.valueOf(format), (Object[])args);
    }

    @Deprecated
    public static void infoWithoutLineNumber(Object obj, String format, Object ... args) {
        KLog.i((String)String.valueOf(obj), (String)String.valueOf(format), (Object[])args);
    }

    public static void warn(Object obj, String format, Object ... args) {
        KLog.w((String)String.valueOf(obj), (String)String.valueOf(format), (Object[])args);
    }

    @Deprecated
    public static void warnWithoutLineNumber(Object obj, String format, Object ... args) {
        KLog.w((String)String.valueOf(obj), (String)String.valueOf(format), (Object[])args);
    }

    public static void error(Object obj, String format, Object ... args) {
        KLog.e((String)String.valueOf(obj), (String)String.valueOf(format), (Object[])args);
    }

    @Deprecated
    public static void errorWithoutLineNumber(Object obj, String format, Object ... args) {
        KLog.e((String)String.valueOf(obj), (String)String.valueOf(format), (Object[])args);
    }

    public static void error(Object obj, String format, Throwable t, Object ... args) {
        KLog.e((String)String.valueOf(obj), (String)String.valueOf(format), (Throwable)t, (Object[])args);
    }

    @Deprecated
    public static void errorWithoutLineNumber(Object obj, String format, Throwable t, Object ... args) {
        KLog.e((String)String.valueOf(obj), (String)String.valueOf(format), (Throwable)t, (Object[])args);
    }

    public static void error(Object obj, Throwable t) {
        KLog.e((String)String.valueOf(obj), (String)"", (Throwable)t, (Object[])new Object[0]);
    }

    public static void flush() {
        ILogService service = (ILogService)Axis.Companion.getService(ILogService.class);
        if (service != null) {
            service.flush();
        }
    }

    public static void close() {
    }

    public static void updateLogLevel(int level) {
        if (level < 1) {
            return;
        }
        if (BasicConfig.getInstance().isDebuggable() && level > 2) {
            return;
        }
        if (sOptions != null) {
            MLog.sOptions.logLevel = level;
            ILogConfig config = ((ILogService)Axis.Companion.getService(ILogService.class)).config();
            if (config != null) {
                config.logLevel(level).apply();
            }
        }
    }

    public static int getLogLevel() {
        if (sOptions != null) {
            return MLog.sOptions.logLevel;
        }
        return 1;
    }

    public static boolean isLogLevelAboveDebug() {
        return BasicConfig.getInstance().isDebuggable();
    }

    public static boolean isLogLevelAboveVerbose() {
        return BasicConfig.getInstance().isDebuggable();
    }

    public static void setUniformTag(String tag) {
        if (tag != null && tag.length() != 0) {
            MLog.sOptions.uniformTag = tag;
        }
    }

    public static String getLogPath() {
        return sDir;
    }

    public static LogOptions getOptions() {
        return sOptions;
    }

    public static String getThreadName() {
        return Utils.getCurrentThreadName();
    }

    public static LogOutputPaths getLogOutputPaths() {
        LogOutputPaths ret = new LogOutputPaths();
        if (!MLog.getLogOutputPaths(ret)) {
            MLog.error((Object)"MLog", "failed to get log output paths.", new Object[0]);
        }
        return ret;
    }

    public static boolean getLogOutputPaths(LogOutputPaths out) {
        out.currentLogFile = MLog.getCurrentLogFile();
        out.dir = sDir;
        File folder = new File(sDir);
        File[] files = folder.listFiles();
        if (files != null) {
            long maxBackupTime = 0L;
            String dest = null;
            for (File e : files) {
                long tempTime = MLog.getLogFileBackupTime(e);
                if (tempTime <= maxBackupTime) continue;
                maxBackupTime = tempTime;
                dest = e.getAbsolutePath();
            }
            out.latestBackupFile = "";
        }
        return true;
    }

    private static long getLogFileBackupTime(File file) {
        if (file == null || !file.exists() || !MLog.isBakFile(file.getAbsolutePath())) {
            return 0L;
        }
        long time = 0L;
        try {
            String filename = file.getName();
            Matcher matcher = PATTERN.matcher(filename);
            if (matcher.find()) {
                String dateStr = filename.substring(matcher.start(), matcher.end());
                time = CommonUtils.getSimpleDateFormat(BAK_DATE_FORMAT_STR).parse(dateStr).getTime();
                Log.i((String)"MLog", (String)(".bak name:" + dateStr + ", time" + time + ", str:" + dateStr));
            } else {
                time = file.lastModified();
                PerfLog.webLog("mlog", ".bak find time format wrong, filename:" + filename + ", lastModified:" + time);
                Log.i((String)"MLog", (String)(".bak find time format wrong, filename:" + filename + ", lastModified:" + time));
            }
        }
        catch (Throwable throwable) {
            Log.e((String)"MLog", (String)("getLogFileBackupTime error" + throwable));
            time = file.lastModified();
            Log.i((String)"MLog", (String)(".bak lastModified:" + time));
        }
        return time;
    }

    private static boolean isBakFile(String file) {
        return file.endsWith(BAK_EXT);
    }

    private static String getThreadStacksKeyword() {
        return MLog.sOptions.stackTraceFilterKeyword;
    }

    public static void printThreadStacks() {
        MLog.printThreadStacks(MLog.sOptions.uniformTag == null ? "CallStack" : MLog.sOptions.uniformTag, MLog.getThreadStacksKeyword(), false, false);
    }

    public static void printThreadStacks(String tag) {
        MLog.printThreadStacks(tag, MLog.getThreadStacksKeyword(), Utils.isEmpty(MLog.getThreadStacksKeyword()), false);
    }

    public static void printThreadStacks(Throwable e, String tag) {
        MLog.printStackTraces(e.getStackTrace(), tag);
    }

    public static void printThreadStacks(String tag, String keyword) {
        MLog.printThreadStacks(tag, keyword, false, false);
    }

    public static void printThreadStacks(String tag, String keyword, boolean fullLog, boolean release) {
        MLog.printStackTraces(Thread.currentThread().getStackTrace(), tag, keyword, fullLog, release);
    }

    public static void printStackTraces(StackTraceElement[] traces, String tag) {
        MLog.printStackTraces(traces, tag, MLog.getThreadStacksKeyword(), Utils.isEmpty(MLog.sOptions.stackTraceFilterKeyword), false);
    }

    private static void printStackTraces(StackTraceElement[] traces, String tag, String keyword, boolean fullLog, boolean release) {
        MLog.printLog(tag, "------------------------------------", release);
        for (StackTraceElement e : traces) {
            String info = e.toString();
            if (!fullLog && (Utils.isEmpty(keyword).booleanValue() || info.indexOf(keyword) == -1)) continue;
            MLog.printLog(tag, info, release);
        }
        MLog.printLog(tag, "------------------------------------", release);
    }

    private static void printLog(String tag, String log, boolean release) {
        if (release) {
            MLog.info(tag, log, new Object[0]);
        } else {
            MLog.debug(tag, log, new Object[0]);
        }
    }

    public static String stackTraceOf(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            t.printStackTrace(pw);
        }
        catch (Throwable throwable) {
            MLog.error((Object)"stackTraceOf", "" + throwable, new Object[0]);
            PerfLog.webLog("mlog", "stackTraceOf " + throwable.getMessage());
        }
        return sw.toString();
    }

    public static String stackTrace() {
        Object[] traces = Thread.currentThread().getStackTrace();
        return TextUtils.join((CharSequence)"\n", (Object[])traces);
    }

    public static <T> int getLogCollectionSize(Collection<T> infos) {
        return FP.empty(infos) ? 0 : infos.size();
    }

    public static <T, V> int getLogMapSize(Map<T, V> infos) {
        return FP.empty(infos) ? 0 : infos.size();
    }

    static {
        PATTERN_STR = "-[0-9]{8}-[0-9]{6}.[0-9]{3}";
        PATTERN = Pattern.compile(PATTERN_STR);
    }

    public static class LogOutputPaths {
        public String dir;
        public String currentLogFile;
        public String latestBackupFile;
    }

    public static class LogOptions {
        public static final int LEVEL_VERBOSE = 1;
        public static final int LEVEL_DEBUG = 2;
        public static final int LEVEL_INFO = 3;
        public static final int LEVEL_WARN = 4;
        public static final int LEVEL_ERROR = 5;
        public String uniformTag;
        public String stackTraceFilterKeyword;
        public int logLevel = 1;
        public boolean honorVerbose = false;
        public int backUpLogLimitInMB = 25;
        public int buffSizeInBytes = 32768;
        public String logFileName = "logs.txt";
        public String logIdentifier = "logs";
    }
}

