/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import android.annotation.SuppressLint;
import android.util.Log;
import android.util.Printer;
import com.yy.mobile.util.CommonUtils;
import java.text.SimpleDateFormat;

public final class StopWatch {
    private static final String TAG = "StopWatch";
    private static final int STATE_UNSTARTED = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_STOPPED = 2;
    private static final int STATE_SUSPENDED = 3;
    private static final int STATE_UNSPLIT = 10;
    private static final int STATE_SPLIT = 11;
    private int runningState = 0;
    private int splitState = 10;
    private long startTime = -1L;
    private long stopTime = -1L;
    private Printer printer;

    public void setPrinter(Printer printer) {
        this.printer = printer;
    }

    public void start() {
        if (this.runningState == 2) {
            Log.w((String)TAG, (String)"Stopwatch must be reset before being restarted. ");
            return;
        }
        if (this.runningState != 0) {
            Log.w((String)TAG, (String)"Stopwatch already started. ");
            return;
        }
        this.stopTime = -1L;
        this.startTime = System.currentTimeMillis();
        this.runningState = 1;
        if (this.printer != null) {
            this.printer.println("start");
        }
    }

    public void stop() {
        if (this.runningState != 1 && this.runningState != 3) {
            Log.w((String)TAG, (String)"Stopwatch is not running. ");
            return;
        }
        if (this.runningState == 1) {
            this.stopTime = System.currentTimeMillis();
        }
        this.runningState = 2;
        if (this.printer != null) {
            this.printer.println("stopped time used " + (this.stopTime - this.startTime));
        }
    }

    public void reset() {
        this.runningState = 0;
        this.splitState = 10;
        this.startTime = -1L;
        this.stopTime = -1L;
    }

    public void split() {
        this.split(null);
    }

    public void split(String tag) {
        if (this.runningState != 1) {
            Log.w((String)TAG, (String)"Stopwatch is not running. ");
            return;
        }
        long lastSplitTime = this.stopTime == -1L ? this.startTime : this.stopTime;
        this.stopTime = System.currentTimeMillis();
        this.splitState = 11;
        if (this.printer != null) {
            StringBuilder sb = new StringBuilder(16);
            sb.append("[").append(tag).append("]").append(" split ").append(this.stopTime - lastSplitTime).append("/").append(this.stopTime - this.startTime);
            this.printer.println(sb.toString());
        }
    }

    public void unsplit() {
        if (this.splitState != 11) {
            Log.w((String)TAG, (String)"Stopwatch has not been split. ");
            return;
        }
        this.stopTime = -1L;
        this.splitState = 10;
    }

    public void suspend() {
        if (this.runningState != 1) {
            Log.w((String)TAG, (String)"Stopwatch must be running to suspend. ");
            return;
        }
        this.stopTime = System.currentTimeMillis();
        this.runningState = 3;
    }

    public void resume() {
        if (this.runningState != 3) {
            Log.w((String)TAG, (String)"Stopwatch must be suspended to resume. ");
            return;
        }
        this.startTime += System.currentTimeMillis() - this.stopTime;
        this.stopTime = -1L;
        this.runningState = 1;
    }

    public long getTime() {
        if (this.runningState == 2 || this.runningState == 3) {
            return this.stopTime - this.startTime;
        }
        if (this.runningState == 0) {
            return 0L;
        }
        if (this.runningState == 1) {
            return System.currentTimeMillis() - this.startTime;
        }
        Log.e((String)TAG, (String)"Illegal running state has occurred. ");
        return -1L;
    }

    public long getSplitTime() {
        if (this.splitState != 11) {
            Log.w((String)TAG, (String)"Stopwatch must be split to get the split time. ");
            return -1L;
        }
        return this.stopTime - this.startTime;
    }

    public long getStartTime() {
        if (this.runningState == 0) {
            Log.w((String)TAG, (String)"Stopwatch has not been started");
            return -1L;
        }
        return this.startTime;
    }

    public String toString() {
        SimpleDateFormat format = CommonUtils.getSimpleDateFormat("mm:ss:SSS");
        long time = this.getTime();
        if (time <= 0L) {
            return "";
        }
        return format.format(this.getTime());
    }

    @SuppressLint(value={"DefaultLocale"})
    private static String formatTime(long ms) {
        if (ms <= 0L) {
            return "00:00:000";
        }
        long minutes = ms / 60000L;
        long seconds = (ms - minutes * 60L * 1000L) / 1000L;
        long mi = ms % 1000L;
        return String.format("%02d:%02d:%03d", minutes, seconds, mi);
    }

    public String toSplitString() {
        return StopWatch.formatTime(this.getSplitTime());
    }

    public boolean isRunning() {
        return this.runningState == 1;
    }
}

