/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.emoticons.adapter;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import com.yy.mobile.framework.R;
import com.yy.mobile.ui.widget.emoticons.IEmoticonsDataInterface;
import java.util.List;

public class EmoticonsGridAdapter<T extends IEmoticonsDataInterface>
extends BaseAdapter {
    private Context mContext;
    private List<T> iconList;
    private IEmoticonsInsertListener<T> mListener;

    public EmoticonsGridAdapter(Context context, List<T> list, IEmoticonsInsertListener<T> listener) {
        this.mContext = context;
        this.iconList = list;
        this.mListener = listener;
    }

    public int getCount() {
        return this.iconList.size();
    }

    public T getItem(int position) {
        return (T)((IEmoticonsDataInterface)this.iconList.get(position));
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Object t;
        View view = convertView;
        if (view == null) {
            view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.emoticons_item, null, false);
        }
        if ((t = this.getItem(position)) != null) {
            ImageView emoticon = (ImageView)view.findViewById(R.id.emoticon_view);
            BitmapDrawable drawable2 = new BitmapDrawable(this.mContext.getResources(), t.getBitmap());
            drawable2.setAlpha(t.getAlphaValue());
            emoticon.setImageDrawable((Drawable)drawable2);
            emoticon.setTag(t);
            emoticon.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    EmoticonsGridAdapter.this.mListener.onInsertSmiley((IEmoticonsDataInterface)v.getTag());
                }
            });
        }
        return view;
    }

    public static interface IEmoticonsInsertListener<T> {
        public void onInsertSmiley(T var1);
    }
}

