/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Spannable;
import android.text.TextPaint;
import android.text.style.BackgroundColorSpan;
import android.text.style.CharacterStyle;
import android.text.style.DynamicDrawableSpan;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.TextView;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public class MTextView
extends TextView {
    private static HashMap<String, SoftReference<MeasuredData>> measuredData = new HashMap();
    private static int hashIndex = 0;
    ArrayList<LINE> contentList = new ArrayList();
    private Context context;
    private TextPaint paint = new TextPaint();
    private Paint.FontMetricsInt mSpanFmInt = new Paint.FontMetricsInt();
    private Paint.FontMetrics mFontMetrics = new Paint.FontMetrics();
    private int textColor = -16777216;
    private float lineSpacing;
    private int lineSpacingDP = 5;
    private int paragraphSpacing = -1;
    private int maxWidth;
    private int oneLineWidth = -1;
    private float lineWidthMax = -1.0f;
    private ArrayList<Object> obList = new ArrayList();
    private boolean useDefault = false;
    protected CharSequence text = "";
    private int minHeight;
    private DisplayMetrics displayMetrics;
    private Paint textBgColorPaint = new Paint();
    private Rect textBgColorRect = new Rect();

    public MTextView(Context context) {
        super(context);
        this.init(context);
    }

    public MTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public MTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    public void init(Context context) {
        this.context = context;
        this.paint.setAntiAlias(true);
        this.lineSpacing = MTextView.dip2px(context, this.lineSpacingDP);
        this.minHeight = MTextView.dip2px(context, 30.0f);
        this.displayMetrics = new DisplayMetrics();
    }

    public static int px2sp(Context context, float pxValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public void setMaxWidth(int maxpixels) {
        super.setMaxWidth(maxpixels);
        this.maxWidth = maxpixels;
    }

    public void setMinHeight(int minHeight) {
        super.setMinHeight(minHeight);
        this.minHeight = minHeight;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.useDefault) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int width = 0;
        int height = 0;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        switch (widthMode) {
            case 0x40000000: {
                width = widthSize;
                break;
            }
            case -2147483648: {
                width = widthSize;
                break;
            }
            case 0: {
                ((Activity)this.context).getWindowManager().getDefaultDisplay().getMetrics(this.displayMetrics);
                width = this.displayMetrics.widthPixels;
                break;
            }
        }
        if (this.maxWidth > 0) {
            width = Math.min(width, this.maxWidth);
        }
        this.paint.setTextSize(this.getTextSize());
        this.paint.setColor(this.textColor);
        int realHeight = this.measureContentHeight(width);
        int leftPadding = this.getCompoundPaddingLeft();
        int rightPadding = this.getCompoundPaddingRight();
        width = Math.min(width, (int)this.lineWidthMax + leftPadding + rightPadding);
        if (this.oneLineWidth > -1) {
            width = this.oneLineWidth;
        }
        switch (heightMode) {
            case 0x40000000: {
                height = heightSize;
                break;
            }
            case -2147483648: {
                height = realHeight;
                break;
            }
            case 0: {
                height = realHeight;
                break;
            }
        }
        height += this.getCompoundPaddingTop() + this.getCompoundPaddingBottom();
        height = Math.max(height, this.minHeight);
        this.setMeasuredDimension(width, height);
    }

    protected void onDraw(Canvas canvas) {
        if (this.useDefault) {
            super.onDraw(canvas);
            return;
        }
        if (this.contentList.isEmpty()) {
            return;
        }
        int leftPadding = this.getCompoundPaddingLeft();
        int topPadding = this.getCompoundPaddingTop();
        float height = (float)(0 + topPadding) + this.lineSpacing;
        if (this.oneLineWidth != -1) {
            height = (float)(this.getMeasuredHeight() / 2) - this.contentList.get((int)0).height / 2.0f;
        }
        for (LINE aContentList : this.contentList) {
            float realDrawedWidth = leftPadding;
            boolean newParagraph = false;
            for (int j = 0; j < aContentList.line.size(); ++j) {
                Object ob = aContentList.line.get(j);
                int width = aContentList.widthList.get(j);
                this.paint.getFontMetrics(this.mFontMetrics);
                float x = realDrawedWidth;
                float y = height + aContentList.height - this.paint.getFontMetrics().descent;
                float top = y - aContentList.height;
                float bottom = y + this.mFontMetrics.descent;
                if (ob instanceof String) {
                    canvas.drawText((String)ob, realDrawedWidth, y, (Paint)this.paint);
                    realDrawedWidth += (float)width;
                    if (!((String)ob).endsWith("\n") || j != aContentList.line.size() - 1) continue;
                    newParagraph = true;
                    continue;
                }
                if (!(ob instanceof SpanObject)) continue;
                Object span = ((SpanObject)ob).span;
                if (span instanceof DynamicDrawableSpan) {
                    int start = ((Spannable)this.text).getSpanStart(span);
                    int end = ((Spannable)this.text).getSpanEnd(span);
                    ((DynamicDrawableSpan)span).draw(canvas, this.text, start, end, (float)((int)x), (int)top, (int)y, (int)bottom, (Paint)this.paint);
                    realDrawedWidth += (float)width;
                    continue;
                }
                if (span instanceof BackgroundColorSpan) {
                    this.textBgColorPaint.setColor(((BackgroundColorSpan)span).getBackgroundColor());
                    this.textBgColorPaint.setStyle(Paint.Style.FILL);
                    this.textBgColorRect.left = (int)realDrawedWidth;
                    int textHeight = (int)this.getTextSize();
                    this.textBgColorRect.top = (int)(height + aContentList.height - (float)textHeight - this.mFontMetrics.descent);
                    this.textBgColorRect.right = this.textBgColorRect.left + width;
                    this.textBgColorRect.bottom = (int)(height + aContentList.height + this.lineSpacing - this.mFontMetrics.descent);
                    canvas.drawRect(this.textBgColorRect, this.textBgColorPaint);
                    canvas.drawText(((SpanObject)ob).source.toString(), realDrawedWidth, height + aContentList.height - this.mFontMetrics.descent, (Paint)this.paint);
                    realDrawedWidth += (float)width;
                    continue;
                }
                canvas.drawText(((SpanObject)ob).source.toString(), realDrawedWidth, height + aContentList.height - this.mFontMetrics.descent, (Paint)this.paint);
                realDrawedWidth += (float)width;
            }
            if (newParagraph) {
                height += aContentList.height + (float)this.paragraphSpacing;
                continue;
            }
            height += aContentList.height + this.lineSpacing;
        }
    }

    public void setTextColor(int color2) {
        super.setTextColor(color2);
        this.textColor = color2;
    }

    private int measureContentHeight(int width) {
        int cachedHeight = this.getCachedData(this.text.toString(), width);
        if (cachedHeight > 0) {
            return cachedHeight;
        }
        float obWidth = 0.0f;
        float obHeight = 0.0f;
        float textSize = this.getTextSize();
        Paint.FontMetrics fontMetrics = this.paint.getFontMetrics();
        float lineHeight = fontMetrics.bottom - fontMetrics.top;
        float height = this.lineSpacing;
        int leftPadding = this.getCompoundPaddingLeft();
        int rightPadding = this.getCompoundPaddingRight();
        float drawedWidth = 0.0f;
        boolean splitFlag = false;
        width = width - leftPadding - rightPadding;
        this.oneLineWidth = -1;
        this.contentList.clear();
        LINE line = new LINE();
        for (int i = 0; i < this.obList.size(); ++i) {
            Object ob = this.obList.get(i);
            if (ob instanceof String) {
                obWidth = this.paint.measureText((String)ob);
                obHeight = textSize;
                if ("\n".equals(ob)) {
                    obWidth = (float)width - drawedWidth;
                }
            } else if (ob instanceof SpanObject) {
                Object span = ((SpanObject)ob).span;
                if (span instanceof DynamicDrawableSpan) {
                    int start = ((Spannable)this.text).getSpanStart(span);
                    int end = ((Spannable)this.text).getSpanEnd(span);
                    obWidth = ((DynamicDrawableSpan)span).getSize((Paint)this.getPaint(), this.text, start, end, this.mSpanFmInt);
                    obHeight = Math.abs(this.mSpanFmInt.top) + Math.abs(this.mSpanFmInt.bottom);
                    if (obHeight > lineHeight) {
                        lineHeight = obHeight;
                    }
                } else if (span instanceof BackgroundColorSpan) {
                    String str = ((SpanObject)ob).source.toString();
                    obWidth = this.paint.measureText(str);
                    obHeight = textSize;
                    int k = str.length() - 1;
                    while ((float)width - drawedWidth < obWidth) {
                        obWidth = this.paint.measureText(str.substring(0, k--));
                    }
                    if (k < str.length() - 1) {
                        splitFlag = true;
                        SpanObject so1 = new SpanObject();
                        so1.start = ((SpanObject)ob).start;
                        so1.end = so1.start + k;
                        so1.source = str.substring(0, k + 1);
                        so1.span = ((SpanObject)ob).span;
                        SpanObject so2 = new SpanObject();
                        so2.start = so1.end;
                        so2.end = ((SpanObject)ob).end;
                        so2.source = str.substring(k + 1, str.length());
                        so2.span = ((SpanObject)ob).span;
                        ob = so1;
                        this.obList.set(i, so2);
                        --i;
                    }
                } else {
                    String str = ((SpanObject)ob).source.toString();
                    obWidth = this.paint.measureText(str);
                    obHeight = textSize;
                }
            }
            if ((float)width - drawedWidth < obWidth || splitFlag) {
                splitFlag = false;
                this.contentList.add(line);
                if (drawedWidth > this.lineWidthMax) {
                    this.lineWidthMax = drawedWidth;
                }
                drawedWidth = 0.0f;
                int objNum = line.line.size();
                height = this.paragraphSpacing > 0 && objNum > 0 && line.line.get(objNum - 1) instanceof String && "\n".equals(line.line.get(objNum - 1)) ? (height += line.height + (float)this.paragraphSpacing) : (height += line.height + this.lineSpacing);
                lineHeight = obHeight;
                line = new LINE();
            }
            drawedWidth += obWidth;
            if (ob instanceof String && line.line.size() > 0 && line.line.get(line.line.size() - 1) instanceof String) {
                int size = line.line.size();
                StringBuilder sb = new StringBuilder();
                sb.append(line.line.get(size - 1));
                sb.append(ob);
                ob = sb.toString();
                line.line.set(size - 1, ob);
                line.widthList.set(size - 1, (int)(obWidth += (float)line.widthList.get(size - 1).intValue()));
                line.height = (int)lineHeight;
                continue;
            }
            line.line.add(ob);
            line.widthList.add((int)obWidth);
            line.height = (int)lineHeight;
        }
        if (drawedWidth > this.lineWidthMax) {
            this.lineWidthMax = drawedWidth;
        }
        if (line != null && line.line.size() > 0) {
            this.contentList.add(line);
            height += lineHeight + this.lineSpacing;
        }
        if (this.contentList.size() <= 1) {
            this.oneLineWidth = (int)drawedWidth + leftPadding + rightPadding;
            height = this.lineSpacing + lineHeight + this.lineSpacing;
        }
        this.cacheData(width, (int)height);
        return (int)height;
    }

    private int getCachedData(String text, int width) {
        SoftReference<MeasuredData> cache = measuredData.get(text);
        if (cache == null) {
            return -1;
        }
        MeasuredData md = cache.get();
        if (md != null && md.textSize == this.getTextSize() && width == md.width) {
            this.lineWidthMax = md.lineWidthMax;
            this.contentList = (ArrayList)md.contentList.clone();
            this.oneLineWidth = md.oneLineWidth;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.contentList.size(); ++i) {
                LINE line = this.contentList.get(i);
                sb.append(line.toString());
            }
            return md.measuredHeight;
        }
        return -1;
    }

    private void cacheData(int width, int height) {
        MeasuredData md = new MeasuredData();
        md.contentList = (ArrayList)this.contentList.clone();
        md.textSize = this.getTextSize();
        md.lineWidthMax = this.lineWidthMax;
        md.oneLineWidth = this.oneLineWidth;
        md.measuredHeight = height;
        md.width = width;
        md.hashIndex = ++hashIndex;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.contentList.size(); ++i) {
            LINE line = this.contentList.get(i);
            sb.append(line.toString());
        }
        SoftReference<MeasuredData> cache = new SoftReference<MeasuredData>(md);
        measuredData.put(this.text.toString(), cache);
    }

    public void setMText(CharSequence cs) {
        int i;
        this.text = cs;
        this.obList.clear();
        ArrayList<SpanObject> isList = new ArrayList<SpanObject>();
        this.useDefault = false;
        if (cs instanceof Spannable) {
            CharacterStyle[] spans = (CharacterStyle[])((Spannable)cs).getSpans(0, cs.length(), CharacterStyle.class);
            for (i = 0; i < spans.length; ++i) {
                int s = ((Spannable)cs).getSpanStart((Object)spans[i]);
                int e = ((Spannable)cs).getSpanEnd((Object)spans[i]);
                SpanObject iS = new SpanObject();
                iS.span = spans[i];
                iS.start = s;
                iS.end = e;
                iS.source = cs.subSequence(s, e);
                isList.add(iS);
            }
        }
        SpanObject[] spanArray = new SpanObject[isList.size()];
        isList.toArray(spanArray);
        Arrays.sort(spanArray, 0, spanArray.length, new SpanObjectComparator());
        isList.clear();
        for (i = 0; i < spanArray.length; ++i) {
            isList.add(spanArray[i]);
        }
        String str = cs.toString();
        int i2 = 0;
        int j = 0;
        while (i2 < cs.length()) {
            if (j < isList.size()) {
                SpanObject is = (SpanObject)isList.get(j);
                if (i2 < is.start) {
                    Integer cp = str.codePointAt(i2);
                    i2 = Character.isSupplementaryCodePoint(cp) ? (i2 += 2) : ++i2;
                    this.obList.add(new String(Character.toChars(cp)));
                    continue;
                }
                if (i2 < is.start) continue;
                this.obList.add(is);
                ++j;
                i2 = is.end;
                continue;
            }
            Integer cp = str.codePointAt(i2);
            i2 = Character.isSupplementaryCodePoint(cp) ? (i2 += 2) : ++i2;
            this.obList.add(new String(Character.toChars(cp)));
        }
        this.requestLayout();
    }

    public void setUseDefault(boolean useDefault) {
        this.useDefault = useDefault;
        if (useDefault) {
            this.setText(this.text);
            this.setTextColor(this.textColor);
        }
    }

    public void setLineSpacingDP(int lineSpacingDP) {
        this.lineSpacingDP = lineSpacingDP;
        this.lineSpacing = MTextView.dip2px(this.context, lineSpacingDP);
    }

    public void setParagraphSpacingDP(int paragraphSpacingDP) {
        this.paragraphSpacing = MTextView.dip2px(this.context, paragraphSpacingDP);
    }

    public int getLineSpacingDP() {
        return this.lineSpacingDP;
    }

    class MeasuredData {
        public int measuredHeight;
        public float textSize;
        public int width;
        public float lineWidthMax;
        public int oneLineWidth;
        public int hashIndex;
        ArrayList<LINE> contentList;

        MeasuredData() {
        }
    }

    class LINE {
        public ArrayList<Object> line = new ArrayList();
        public ArrayList<Integer> widthList = new ArrayList();
        public float height;

        LINE() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("height:" + this.height + "   ");
            for (int i = 0; i < this.line.size(); ++i) {
                sb.append(this.line.get(i) + ":" + this.widthList.get(i));
            }
            return sb.toString();
        }
    }

    class SpanObjectComparator
    implements Comparator<SpanObject> {
        SpanObjectComparator() {
        }

        @Override
        public int compare(SpanObject lhs, SpanObject rhs) {
            return lhs.start - rhs.start;
        }
    }

    class SpanObject {
        public Object span;
        public int start;
        public int end;
        public CharSequence source;

        SpanObject() {
        }
    }
}

