/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http.interceptor;

import com.yy.mobile.http.HttpLog;
import com.yy.mobile.http.qos.QosManager;
import com.yy.mobile.http.time.UUIDManager;
import com.yy.mobile.util.log.MLog;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/yy/mobile/http/interceptor/TraceIdInterceptor;", "Lokhttp3/Interceptor;", "()V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "framework_release"})
public final class TraceIdInterceptor
implements Interceptor {
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Request request = chain.request().newBuilder().header("x-traceid", UUIDManager.INSTANCE.getTraceId()).build();
        long start = System.currentTimeMillis();
        HttpLog.i("HttpRequestUrl:" + request.url() + ", traceId = " + request.header("x-traceid"), new Object[0]);
        Response response = chain.proceed(request);
        long end = System.currentTimeMillis();
        try {
            QosManager qosManager = QosManager.Companion.getInstance();
            String string = request.url().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"request.url().toString()");
            Response response2 = response;
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
            qosManager.submitHttpQuality(string, end - start, !response2.isSuccessful());
        }
        catch (Exception e) {
            MLog.error("TraceIdInterceptor", e);
        }
        Response response3 = response;
        Intrinsics.checkExpressionValueIsNotNull((Object)response3, (String)"response");
        return response3;
    }
}

