/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.file.data;

import android.content.Context;
import com.yy.mobile.file.DefaultFileResponseData;
import com.yy.mobile.file.FileNotFoundException;
import com.yy.mobile.file.FileRequestException;
import com.yy.mobile.file.FileResponse;
import com.yy.mobile.file.FileResponseData;
import com.yy.mobile.file.data.BaseFileDataRequest;
import com.yy.mobile.file.data.FileDataParam;
import com.yy.mobile.util.log.MLog;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileGetRequest
extends BaseFileDataRequest<byte[]> {
    private static final String TAG = "FileGetRequest";
    private File mDataFile;

    public FileGetRequest(Context context, FileDataParam config) {
        this.mDataConfig = config;
    }

    @Override
    public FileResponseData performRequest() throws FileRequestException {
        InputStream cis = null;
        try {
            this.mDataFile = this.getDataFile(this.mDataConfig.getDataKey());
            if (!this.mDataFile.exists()) {
                throw new FileNotFoundException(this.mDataFile + " not found.");
            }
            cis = new BufferedInputStream(new FileInputStream(this.mDataFile));
            if (this.mDataFile == null || !this.mDataFile.exists()) {
                if (!MLog.isLogLevelAboveVerbose()) {
                    MLog.verbose("FileRequest", "Can't find file or not exists file=%s", this.mDataFile);
                }
                FileResponseData fileResponseData = null;
                return fileResponseData;
            }
            byte[] data = FileGetRequest.streamToBytes(cis, (int)this.mDataFile.length());
            DefaultFileResponseData defaultFileResponseData = new DefaultFileResponseData(data);
            return defaultFileResponseData;
        }
        catch (Exception e) {
            throw new FileRequestException(e);
        }
        finally {
            if (cis != null) {
                try {
                    cis.close();
                }
                catch (IOException ioe) {
                    return null;
                }
            }
        }
    }

    @Override
    public String getKey() {
        return this.mDataConfig.getDataKey();
    }

    @Override
    public void parseDataToResponse(FileResponseData responseData) {
        if (responseData != null) {
            this.mResponse = FileResponse.success(responseData.getData());
        }
    }

    @Override
    public String toString() {
        return "FileGetRequest{mDataFile=" + this.mDataFile + '}';
    }
}

