/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.log.logger.printer.writer;

import android.util.Log;
import com.yy.mobile.util.log.PerfLog;
import com.yy.mobile.util.log.logger.printer.AndroidPrinter;
import com.yy.mobile.util.log.logger.printer.writer.AbstractFileWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class SectionFileWriter
extends AbstractFileWriter {
    private static final int BUFFER_SIZE = 4096;
    private static final int WRITE_GAP = 2000;
    private long mLastFlushTime = -1L;
    private long mCurrentTime = 0L;
    private StringBuilder mMsgBuffer = new StringBuilder(5120);

    public SectionFileWriter() {
        this(null);
    }

    public SectionFileWriter(Writer fileWriter) {
        super(fileWriter);
    }

    @Override
    public void writer(String msg, long msgTime) throws IOException {
        if (msg == null) {
            return;
        }
        this.mMsgBuffer.append(msg);
        this.flushIfNeed();
    }

    @Override
    public void writer(String msg) throws IOException {
        if (msg == null) {
            return;
        }
        this.mMsgBuffer.append(msg);
        this.flushIfNeed();
    }

    @Override
    public void update(Writer fileWriter) {
        super.update(fileWriter);
        try {
            this.flushIfNeed();
        }
        catch (IOException e) {
            Log.e((String)"SectionFileWriter", (String)(" error ignore: " + e.getMessage()));
            PerfLog.webLog("mlog", "SectionFileWriter error ignore " + e.getMessage());
        }
    }

    @Override
    public Writer createWrite(File file) throws IOException {
        return new FileWriter(file);
    }

    private void flushIfNeed() throws IOException {
        if (!this.mUseBuffer) {
            this.flush();
            return;
        }
        if (this.mMsgBuffer.length() > 4096) {
            this.mLastFlushTime = System.currentTimeMillis();
            this.flush();
        } else {
            this.mCurrentTime = System.currentTimeMillis();
            if (this.mLastFlushTime == -1L) {
                this.mLastFlushTime = this.mCurrentTime;
            }
            if (this.mCurrentTime - this.mLastFlushTime > 2000L) {
                this.mLastFlushTime = this.mCurrentTime;
                this.flush();
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            PerfLog.webLog("mlog", "SectionFileWriter close error " + e.getMessage());
            AndroidPrinter.log("E/:", "SectionFileWriter", e, " close error", new Object[0]);
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            super.writer(this.mMsgBuffer.toString(), -1L);
            this.mMsgBuffer.setLength(0);
        }
        catch (IOException e) {
            PerfLog.webLog("mlog", "SectionFileWriter flush() " + e.getMessage());
            throw e;
        }
    }
}

