/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.support.annotation.Nullable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.util.Base64;
import android.util.Log;
import android.util.Pair;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class StringUtils {
    public static final boolean IGNORE_CASE = true;
    public static final boolean IGNORE_WIDTH = true;
    private static DecimalFormat commonSeperateFmt = null;
    private static final int SHA1_LENGTH = 40;

    public static String formatCommonSeperate(Object object) {
        if (commonSeperateFmt == null) {
            commonSeperateFmt = new DecimalFormat("#,###");
        }
        return commonSeperateFmt.format(object);
    }

    public static boolean isNullOrEmpty(String str) {
        return FP.empty(str);
    }

    public static boolean isAllWhitespaces(String str) {
        boolean ret = true;
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            ret = false;
            break;
        }
        return ret;
    }

    public static boolean isAllDigits(String str) {
        if (StringUtils.isEmpty(str).booleanValue()) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean equal(String s1, String s2) {
        return StringUtils.equal(s1, s2, false);
    }

    public static boolean equal(String s1, String s2, boolean ignoreCase) {
        if (s1 != null && s2 != null) {
            if (ignoreCase) {
                return s1.equalsIgnoreCase(s2);
            }
            return s1.equals(s2);
        }
        return s1 == null && s2 == null;
    }

    public static Vector<String> parseMediaUrls(String str, String beginTag, String endTag) {
        Vector<String> list = new Vector<String>();
        if (!StringUtils.isNullOrEmpty(str)) {
            int beginIndex = str.indexOf(beginTag, 0);
            int endIndex = str.indexOf(endTag, 0);
            while (beginIndex != -1 && endIndex != -1 && endIndex > beginIndex) {
                String imgUrl = str.substring(beginIndex += beginTag.length(), endIndex);
                if (!StringUtils.isNullOrEmpty(imgUrl) && imgUrl.charAt(0) != '[') {
                    list.add(imgUrl);
                }
                endIndex += endIndex + endTag.length();
                beginIndex = str.indexOf(beginTag, endIndex);
                endIndex = str.indexOf(endTag, endIndex);
            }
        }
        return list;
    }

    public static int find(String pattern, String s) {
        return StringUtils.find(pattern, s, false);
    }

    public static int find(String pattern, String s, boolean ignoreCase) {
        return StringUtils.find(pattern, s, ignoreCase, false);
    }

    public static int find(String pattern, String s, boolean ignoreCase, boolean ignoreWidth) {
        if (FP.empty(s)) {
            return -1;
        }
        pattern = FP.ref(pattern);
        if (ignoreCase) {
            pattern = pattern.toLowerCase();
            s = s.toLowerCase();
        }
        if (ignoreWidth) {
            pattern = StringUtils.narrow(pattern);
            s = StringUtils.narrow(s);
        }
        return s.indexOf(pattern);
    }

    public static String narrow(String s) {
        if (FP.empty(s)) {
            return "";
        }
        char[] cs = s.toCharArray();
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = StringUtils.narrow(cs[i]);
        }
        return new String(cs);
    }

    public static char narrow(char c) {
        char code = c;
        if (code >= '\uff01' && code <= '\uff5d') {
            return (char)(code - 65248);
        }
        if (code == '\u3000') {
            return (char)(code - 12288 + 32);
        }
        if (code == '\uff61') {
            return '\u3002';
        }
        if (code == '\u30fb') {
            return '\u00b7';
        }
        if (code == '\u2022') {
            return '\u00b7';
        }
        if (code == '\u2029') {
            return '\n';
        }
        return c;
    }

    public static int ord(char c) {
        if ('a' <= c && c <= 'z') {
            return c;
        }
        if ('A' <= c && c <= 'Z') {
            return c - 65 + 97;
        }
        return 0;
    }

    public static int compare(String x, String y) {
        return FP.ref(x).compareTo(FP.ref(y));
    }

    public static String getHashIfPassIsPlainText(String password) {
        if (!StringUtils.isNullOrEmpty(password) && password.length() < 40) {
            return StringUtils.sha1(password);
        }
        return password;
    }

    public static String sha1(String str) {
        StringBuffer sb = new StringBuffer();
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            byte[] digest = sha1.digest(str.getBytes());
            sb.append(StringUtils.bytesToHexString(digest));
        }
        catch (NoSuchAlgorithmException e) {
            MLog.error("StringUtils", e);
        }
        return sb.toString();
    }

    public static String bytesToHexString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (byte b : bytes) {
            int val = b & 0xFF;
            if (val < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(val));
        }
        return sb.toString();
    }

    public static boolean isValidMobileNumber(String phone) {
        if (phone == null || phone.length() != 11 || !phone.startsWith("1")) {
            return false;
        }
        return StringUtils.isAllDigits(phone);
    }

    public static boolean isNameMatchMobilePattern(String name) {
        return name != null && name.matches("1\\d{10}(y*|s*)");
    }

    public static String getMobileFromName(String name) {
        String mobile;
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug("StringUtil", "mobile user name %s", name);
        }
        if (name == null) {
            return "";
        }
        if (name.startsWith("1") && name.length() >= 11 && StringUtils.isValidMobileNumber(mobile = name.substring(0, 11))) {
            return mobile;
        }
        return "";
    }

    public static boolean isIpv4Addr(String addr) {
        return addr != null && addr.matches("(\\d{1,3}\\.){3}\\d{1,3}");
    }

    public static <A, B> String fromPair(Pair<A, B> p) {
        return p.first + ":" + p.second;
    }

    public static <A, B> String join(CharSequence delim, List<Pair<A, B>> xs) {
        return TextUtils.join((CharSequence)delim, FP.map(new FP.UnaryFunc<String, Pair<A, B>>(){

            @Override
            public String apply(Pair<A, B> p) {
                return StringUtils.fromPair(p);
            }
        }, xs));
    }

    public static <E> String join(CharSequence delim, SparseArray<E> xs) {
        return StringUtils.join(delim, FP.toList(xs));
    }

    public static String join(CharSequence delim, SparseIntArray xs) {
        return StringUtils.join(delim, FP.toList(xs));
    }

    public static String join(Collection collection, String separator) {
        if (collection == null) {
            return null;
        }
        return StringUtils.join(collection.iterator(), separator);
    }

    public static String join(Iterator iterator, String separator) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return "";
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return StringUtils.objectToString(first);
        }
        StringBuffer buf = new StringBuffer(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            Object obj;
            if (separator != null) {
                buf.append(separator);
            }
            if ((obj = iterator.next()) == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    public static String objectToString(Object obj) {
        return obj != null ? obj.toString() : "";
    }

    public static int getLevenshteinDistance(String s, String t) {
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        if (n > m) {
            String tmp = s;
            s = t;
            t = tmp;
            n = m;
            m = t.length();
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (int i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char tJ = t.charAt(j - 1);
            d[0] = j;
            for (int i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) != tJ ? 1 : 0;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] p1 = p;
            p = d;
            d = p1;
        }
        return p[n];
    }

    public static String filterSpecificChar(String str) throws Exception {
        String regEx = "[`~!@#$%^&*()+=|{}':;',//[//].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }

    public static SpannableString getHighlightText(String text, String keyword, int color2) {
        if (FP.empty(text)) {
            text = "";
        }
        SpannableString s = new SpannableString((CharSequence)text);
        try {
            Pattern p = Pattern.compile(keyword, 2);
            Matcher m = p.matcher((CharSequence)s);
            while (m.find()) {
                int start = m.start();
                int end = m.end();
                s.setSpan((Object)new ForegroundColorSpan(color2), start, end, 33);
            }
            return s;
        }
        catch (PatternSyntaxException e) {
            MLog.info("xxf-kaede", "\u5305\u542b\u7279\u6b8a\u5b57\u7b26", new Object[0]);
            return s;
        }
    }

    public static SpannableString getHighlightText(String text, String keyword) {
        return StringUtils.getHighlightText(text, keyword, Color.parseColor((String)"#fac200"));
    }

    public static String getTextPolished(String text, int length, String suffix) {
        if (text.length() <= length) {
            return text;
        }
        return text.substring(0, length - 1) + suffix;
    }

    public static Boolean isEmpty(String str) {
        return str == null || str.equals("");
    }

    public static int safeParseInt(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        int value = 0;
        try {
            value = Integer.valueOf(str);
        }
        catch (Throwable e) {
            MLog.error((Object)"StringUtils", "safeParseInt " + str, new Object[0]);
        }
        return value;
    }

    public static long safeParseLong(String str) {
        if (str == null || str.length() == 0) {
            return 0L;
        }
        long value = 0L;
        try {
            value = Long.valueOf(str);
        }
        catch (Throwable e) {
            MLog.error((Object)"StringUtils", "safeParseLong " + str, new Object[0]);
        }
        return value;
    }

    public static float safeParseFloat(String str) {
        if (str == null || str.length() == 0) {
            return 0.0f;
        }
        float value = 0.0f;
        try {
            value = Float.valueOf(str).floatValue();
        }
        catch (Throwable e) {
            MLog.error((Object)"StringUtils", "safeParseFloat " + str, new Object[0]);
        }
        return value;
    }

    public static double safeParseDouble(String str) {
        if (str == null || str.length() == 0) {
            return 0.0;
        }
        double value = 0.0;
        try {
            value = Double.valueOf(str);
        }
        catch (Throwable e) {
            MLog.error((Object)"StringUtils", "safeParseDouble " + str, new Object[0]);
        }
        return value;
    }

    public static boolean safeParseBoolean(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        boolean value = false;
        try {
            value = Boolean.valueOf(str);
        }
        catch (Throwable e) {
            MLog.error((Object)"StringUtils", "safeParseLong " + str, new Object[0]);
        }
        return value;
    }

    public static String toSBC(String input) {
        if (input == null) {
            return input;
        }
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u007f' || c[i] <= ' ') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String toDBC(String input) {
        if (input == null) {
            return input;
        }
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (!StringUtils.isChinese(c[i])) continue;
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static String stringFilter(String str) {
        str = str.replaceAll("\u3010", "[").replaceAll("\u3011", "]").replaceAll("\uff01", "!").replaceAll("\uff1a", ":");
        String regEx = "[\u300e\u300f]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }

    public static boolean isEmptyString(String str) {
        return str == null || str.length() == 0;
    }

    public static String parseLong(String format, long num) {
        if (null == format) {
            format = ",###,###";
        }
        BigDecimal bd = new BigDecimal(num);
        DecimalFormat df = new DecimalFormat(format);
        return df.format(bd);
    }

    public static long string2long(String string2, long def) {
        try {
            def = Long.parseLong(string2);
            return def;
        }
        finally {
            return def;
        }
    }

    public static boolean isHtmlText(String message) {
        try {
            return message.matches(".*<([^>]*)>.*");
        }
        catch (Exception e) {
            return false;
        }
    }

    @Nullable
    public static Bitmap decodeBase64Pic(String picBase64) {
        Bitmap bitmap = null;
        try {
            byte[] picBinary = Base64.decode((String)picBase64, (int)0);
            bitmap = BitmapFactory.decodeByteArray((byte[])picBinary, (int)0, (int)picBinary.length);
        }
        catch (Exception e) {
            Log.e((String)"StringUtils", (String)"printStackTrace", (Throwable)e);
        }
        return bitmap;
    }

    public static String memLevelStr(int memoryLevel) {
        String levelStr;
        switch (memoryLevel) {
            case 5: {
                levelStr = "TRIM_MEMORY_RUNNING_MODERATE";
                break;
            }
            case 10: {
                levelStr = "TRIM_MEMORY_RUNNING_LOW";
                break;
            }
            case 15: {
                levelStr = "TRIM_MEMORY_RUNNING_CRITICAL";
                break;
            }
            case 20: {
                levelStr = "TRIM_MEMORY_UI_HIDDEN";
                break;
            }
            case 40: {
                levelStr = "TRIM_MEMORY_BACKGROUND";
                break;
            }
            case 60: {
                levelStr = "TRIM_MEMORY_MODERATE";
                break;
            }
            case 80: {
                levelStr = "TRIM_MEMORY_COMPLETE";
                break;
            }
            default: {
                levelStr = "UNKNOWN";
            }
        }
        return levelStr;
    }
}

