/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.statistic;

import android.os.SystemClock;
import android.util.LogPrinter;
import android.util.Printer;
import com.yy.mobile.statistic.DurationStatisticDataModel;
import com.yy.mobile.util.LoggingStopWatch;
import com.yy.mobile.util.TimeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class BaseEventStatisticDataModel
extends DurationStatisticDataModel {
    public static LoggingStopWatch stopWatch;
    public static final long DEFAULT_TIME_OUT_MILLIS;

    public abstract Map<String, List<String>> getEventMap();

    public void begin() {
        stopWatch = new LoggingStopWatch("VideoTime");
        stopWatch.setPrinter((Printer)new LogPrinter(3, "TimeCount"));
        stopWatch.start();
        this.begin(DEFAULT_TIME_OUT_MILLIS, true);
    }

    public void begin(long timeoutMillis, boolean ignoreEnd) {
        if (this.getEventMap() != null) {
            this.getEventMap().clear();
        }
        this.onEventBegin(timeoutMillis, ignoreEnd);
    }

    public void end() {
        if (!this.isRunning()) {
            return;
        }
        this.onEventEnd();
        this.sendToContainer();
    }

    public void cancel() {
        this.onEventEnd();
    }

    public void addEvent(String eventId) {
        this.addEvent(eventId, null);
    }

    public void addEvent(String eventId, String eventValue) {
        if (this.getEventMap() == null || !this.isRunning()) {
            return;
        }
        String value = this.getValue(eventValue);
        List<String> tempList = this.getEventMap().get(eventId);
        if (tempList == null) {
            tempList = new ArrayList<String>();
            tempList.add(value);
            this.getEventMap().put(eventId, tempList);
        } else {
            tempList.add(value);
        }
    }

    public String getValue(String eventValue) {
        String value = String.valueOf(SystemClock.elapsedRealtime());
        if (eventValue != null && eventValue.length() > 0) {
            value = value + "_" + eventValue;
        }
        return value;
    }

    static {
        DEFAULT_TIME_OUT_MILLIS = TimeUtils.MINUTES.toMillis(1L);
    }
}

