/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.image;

import android.graphics.Bitmap;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.HttpLog;
import com.yy.mobile.util.ResolutionUtils;

public class ImageConfig {
    private ImagePrecision imagePrecision = ImagePrecision.Middle;
    private ImageTransparency imageTransparency = ImageTransparency.RGB_565;
    private static ImageConfig mDefaultImageConfig;
    private static ImageConfig mBigImageConfig;
    private static ImageConfig mSmallImageConfig;
    private static ImageConfig mFullImageConfig;
    private static ImageConfig mDefaultARGBImageConfig;
    private static ImageConfig mBigARGBImageConfig;
    private static ImageConfig mSmallARGBImageConfig;
    private static ImageConfig mFullARGBImageConfig;

    public ImageConfig(ImagePrecision imagePrecision, ImageTransparency imageTransparency) {
        this.imagePrecision = imagePrecision;
        this.imageTransparency = imageTransparency;
    }

    public ImageConfig(int imageWidth, int imageHeight) {
        this.imagePrecision = new ImagePrecision(imageWidth, imageHeight);
    }

    public ImagePrecision getImagePrecision() {
        return this.imagePrecision;
    }

    public ImageTransparency getImageTransparency() {
        return this.imageTransparency;
    }

    public static synchronized ImageConfig defaultImageConfig() {
        if (mDefaultImageConfig == null) {
            mDefaultImageConfig = new ImageConfig(ImagePrecision.Middle, ImageTransparency.RGB_565);
        }
        return mDefaultImageConfig;
    }

    public static synchronized ImageConfig bigImageConfig() {
        if (mBigImageConfig == null) {
            mBigImageConfig = new ImageConfig(ImagePrecision.Big, ImageTransparency.RGB_565);
        }
        return mBigImageConfig;
    }

    public static synchronized ImageConfig smallImageConfig() {
        if (mSmallImageConfig == null) {
            mSmallImageConfig = new ImageConfig(ImagePrecision.Small, ImageTransparency.RGB_565);
        }
        return mSmallImageConfig;
    }

    public static synchronized ImageConfig fullImageConfig() {
        if (mFullImageConfig == null) {
            mFullImageConfig = new ImageConfig(ImagePrecision.Full, ImageTransparency.RGB_565);
        }
        return mFullImageConfig;
    }

    public static synchronized ImageConfig defaultARGBImageConfig() {
        if (mDefaultARGBImageConfig == null) {
            mDefaultARGBImageConfig = new ImageConfig(ImagePrecision.Middle, ImageTransparency.ARGB_8888);
        }
        return mDefaultARGBImageConfig;
    }

    public static synchronized ImageConfig bigARGBImageConfig() {
        if (mBigARGBImageConfig == null) {
            mBigARGBImageConfig = new ImageConfig(ImagePrecision.Big, ImageTransparency.ARGB_8888);
        }
        return mBigARGBImageConfig;
    }

    public static synchronized ImageConfig smallARGBImageConfig() {
        if (mSmallARGBImageConfig == null) {
            mSmallARGBImageConfig = new ImageConfig(ImagePrecision.Small, ImageTransparency.ARGB_8888);
        }
        return mSmallARGBImageConfig;
    }

    public static synchronized ImageConfig fullARGBImageConfig() {
        if (mFullARGBImageConfig == null) {
            mFullARGBImageConfig = new ImageConfig(ImagePrecision.Full, ImageTransparency.ARGB_8888);
        }
        return mFullARGBImageConfig;
    }

    public static class ImageTransparency {
        public static final ImageTransparency RGB_565 = new ImageTransparency(Bitmap.Config.RGB_565);
        public static final ImageTransparency ARGB_8888 = new ImageTransparency(Bitmap.Config.ARGB_8888);
        private Bitmap.Config mConfig;

        public ImageTransparency(Bitmap.Config config) {
            this.mConfig = config;
        }

        public Bitmap.Config getBitmapConfig() {
            return this.mConfig;
        }
    }

    public static class ImagePrecision {
        public static final ImagePrecision Full = new ImagePrecision(1.0f);
        public static final ImagePrecision Big = new ImagePrecision(0.5f);
        public static final ImagePrecision Middle = new ImagePrecision(0.3f);
        public static final ImagePrecision Small = new ImagePrecision(0.1f);
        private float mPresisionRatio;
        private int mWidth;
        private int mHeight;

        public ImagePrecision(float presisionRatio) {
            this.mPresisionRatio = presisionRatio;
        }

        public ImagePrecision(int width, int height) {
            this.mWidth = width;
            this.mHeight = height;
        }

        public int getWidth() {
            if (this.mWidth > 0) {
                return this.mWidth;
            }
            try {
                this.mWidth = ResolutionUtils.getScreenWidth(BasicConfig.getInstance().getAppContext());
                this.mWidth = (int)((float)this.mWidth * this.mPresisionRatio);
                HttpLog.v("Screen width %d", this.mWidth);
            }
            catch (Exception e) {
                this.mWidth = 300;
                HttpLog.e(e, "Screen width error, use default", new Object[0]);
            }
            return this.mWidth;
        }

        public int getHeight() {
            if (this.mHeight > 0) {
                return this.mHeight;
            }
            try {
                this.mHeight = ResolutionUtils.getScreenHeight(BasicConfig.getInstance().getAppContext());
                HttpLog.v("Screen height %d", this.mHeight);
                this.mHeight = (int)((float)this.mHeight * this.mPresisionRatio);
            }
            catch (Exception e) {
                this.mHeight = 300;
                HttpLog.e(e, "Screen height error, use default", new Object[0]);
            }
            return this.mHeight;
        }
    }
}

