/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.taskexecutor.smartdns;

import com.yy.gslbsdk.thread.ThreadPoolMgr;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.HardwareUtil;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import java.util.ArrayList;

public class GSLBDnsExecutor
implements ThreadPoolMgr.ITaskExecutor {
    private final String tag = GSLBDnsExecutor.class.getName();
    private static final int MAX_CONCURRENCY_TASKS = HardwareUtil.getCpuCoreCount() >= 4 ? 15 : 12;
    private volatile int mCurrentActiveTasks = 0;
    private ArrayList<GSLBDnsRunnable> mRunnablesToPost = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTask(Runnable task) {
        GSLBDnsExecutor gSLBDnsExecutor = this;
        synchronized (gSLBDnsExecutor) {
            this.mRunnablesToPost.add(new GSLBDnsRunnable(task));
        }
        this.executeNext();
        return true;
    }

    private void onTaskFinished(GSLBDnsRunnable runnable) {
        --this.mCurrentActiveTasks;
        this.executeNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNext() {
        GSLBDnsRunnable myRunnable = null;
        GSLBDnsExecutor gSLBDnsExecutor = this;
        synchronized (gSLBDnsExecutor) {
            if (this.mCurrentActiveTasks < MAX_CONCURRENCY_TASKS && this.mRunnablesToPost.size() > 0) {
                myRunnable = this.mRunnablesToPost.get(0);
                this.mRunnablesToPost.remove(0);
                if (myRunnable != null) {
                    ++this.mCurrentActiveTasks;
                }
            }
        }
        if (myRunnable != null) {
            YYTaskExecutor.execute(myRunnable);
        }
    }

    public int getPoolSize() {
        return 20;
    }

    public int getActiveCount() {
        return this.mCurrentActiveTasks;
    }

    public boolean isShutdown() {
        return false;
    }

    public boolean isTerminated() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow(long timeoutMs) {
        GSLBDnsExecutor gSLBDnsExecutor = this;
        synchronized (gSLBDnsExecutor) {
            this.mRunnablesToPost.clear();
        }
    }

    private class GSLBDnsRunnable
    implements Runnable {
        private Runnable mRunnable;

        public GSLBDnsRunnable(Runnable runnable) {
            this.mRunnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: {
                try {
                    if (this.mRunnable != null) {
                        this.mRunnable.run();
                    }
                    GSLBDnsExecutor.this.onTaskFinished(this);
                    if (!BasicConfig.getInstance().isDebuggable() || this.mRunnable == null) break block6;
                    GSLBDnsExecutor gSLBDnsExecutor = GSLBDnsExecutor.this;
                    synchronized (gSLBDnsExecutor) {
                        MLog.info(GSLBDnsExecutor.this.tag, "onTaskFinished:" + this.mRunnable + "  RunnablesToPost" + GSLBDnsExecutor.this.mRunnablesToPost.size(), new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    GSLBDnsExecutor.this.onTaskFinished(this);
                    MLog.info(GSLBDnsExecutor.this.tag, "onTaskFinished:" + this.mRunnable + " error:" + throwable, new Object[0]);
                    throw throwable;
                }
            }
        }
    }
}

