/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.emoticons;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.yy.mobile.framework.R;
import com.yy.mobile.richtext.EmoticonFilter;
import com.yy.mobile.ui.widget.emoticons.adapter.EmoticonsGridAdapter;
import com.yy.mobile.ui.widget.emoticons.adapter.EmoticonsPageAdapter;
import java.util.ArrayList;
import java.util.List;

public class EmoticonsView {
    private Context mContext;
    private View rootView;
    private ViewPager yyEmoticonsPager;
    protected ScrollEmoticonsPageAdapter mScrollEmoticonsPageAdapter;
    protected LinearLayout cursorLayout;
    protected List<ImageView> cursorImageView = new ArrayList<ImageView>();
    private IEmoticonsMessageListener mListener;
    private IEmoticonLimitedListener mLimitedListener;
    private IMomoEmotionListener mIMomoEmotionListener;
    private int mCurrentPage = 0;
    private List<Integer> mAdapterIndex = new ArrayList<Integer>();
    private List<Integer> mAdapterItemIndex = new ArrayList<Integer>();

    public void setLimitedListener(IEmoticonLimitedListener listener) {
        this.mLimitedListener = listener;
    }

    public void setIMomoEmotionListener(IMomoEmotionListener mIMomoEmotionListener) {
        this.mIMomoEmotionListener = mIMomoEmotionListener;
    }

    public EmoticonsView(Activity activity, IEmoticonsMessageListener listener, EditText editText) {
        this.rootView = LayoutInflater.from((Context)activity).inflate(R.layout.emoticons_layout, null);
        this.mContext = activity;
        this.mListener = listener;
        this.init(editText);
    }

    public EmoticonsView(Context context, View root, IEmoticonsMessageListener listener, EditText editText) {
        this.rootView = root;
        this.mContext = context;
        this.mListener = listener;
        this.init(editText);
    }

    public EmoticonsView(Context context, View root, IEmoticonsMessageListener listener, EmoticonsGridAdapter.IEmoticonsInsertListener<EmoticonFilter.SmileItem> emoticonsInsertListener) {
        this.rootView = root;
        this.mContext = context;
        this.mListener = listener;
        this.initWithEmoticonsInsertListener(emoticonsInsertListener);
    }

    public View getRootView() {
        return this.rootView;
    }

    public void setVisibility(int visibility) {
        this.rootView.setVisibility(visibility);
    }

    public int getVisibility() {
        return this.rootView.getVisibility();
    }

    private void init(EditText editText) {
        this.cursorLayout = (LinearLayout)this.rootView.findViewById(R.id.cursor_layout);
        this.yyEmoticonsPager = (ViewPager)this.rootView.findViewById(R.id.emoticons_pager);
        EmoticonsPageAdapter<EmoticonFilter.SmileItem> adapter = new EmoticonsPageAdapter<EmoticonFilter.SmileItem>(this.mContext, EmoticonFilter.getInstance().getSmileList(this.mContext), this.getEmoticonsInsertListener(editText), 21, 7);
        ArrayList<EmoticonsPageAdapter> listAdapter = new ArrayList<EmoticonsPageAdapter>();
        listAdapter.add(adapter);
        this.mScrollEmoticonsPageAdapter = new ScrollEmoticonsPageAdapter(this.mContext, listAdapter);
        this.yyEmoticonsPager.setAdapter((PagerAdapter)this.mScrollEmoticonsPageAdapter);
        this.yyEmoticonsPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int i, float v, int i2) {
            }

            public void onPageSelected(int i) {
                EmoticonsView.this.mCurrentPage = i;
                EmoticonsView.this.updateCursorLayout();
            }

            public void onPageScrollStateChanged(int i) {
            }
        });
        if (Build.VERSION.SDK_INT >= 9) {
            this.yyEmoticonsPager.setOverScrollMode(2);
        }
        this.updateCursorLayout();
    }

    private void initWithEmoticonsInsertListener(EmoticonsGridAdapter.IEmoticonsInsertListener<EmoticonFilter.SmileItem> emoticonsInsertListener) {
        this.cursorLayout = (LinearLayout)this.rootView.findViewById(R.id.cursor_layout);
        this.yyEmoticonsPager = (ViewPager)this.rootView.findViewById(R.id.emoticons_pager);
        EmoticonsPageAdapter<EmoticonFilter.SmileItem> adapter = new EmoticonsPageAdapter<EmoticonFilter.SmileItem>(this.mContext, EmoticonFilter.getInstance().getSmileList(this.mContext), emoticonsInsertListener, 21, 7);
        ArrayList<EmoticonsPageAdapter> listAdapter = new ArrayList<EmoticonsPageAdapter>();
        listAdapter.add(adapter);
        this.mScrollEmoticonsPageAdapter = new ScrollEmoticonsPageAdapter(this.mContext, listAdapter);
        this.yyEmoticonsPager.setAdapter((PagerAdapter)this.mScrollEmoticonsPageAdapter);
        this.yyEmoticonsPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int i, float v, int i2) {
            }

            public void onPageSelected(int i) {
                EmoticonsView.this.mCurrentPage = i;
                EmoticonsView.this.updateCursorLayout();
            }

            public void onPageScrollStateChanged(int i) {
            }
        });
        if (Build.VERSION.SDK_INT >= 9) {
            this.yyEmoticonsPager.setOverScrollMode(2);
        }
        this.updateCursorLayout();
    }

    private void updateCursorLayout() {
        int count = ((EmoticonsPageAdapter)((Object)this.mScrollEmoticonsPageAdapter.mAdapterList.get(this.mScrollEmoticonsPageAdapter.getAdapterIndex(this.mCurrentPage)))).getCount();
        int index = this.mScrollEmoticonsPageAdapter.getAdapterItemIndex(this.mCurrentPage);
        this.cursorLayout.removeAllViews();
        this.cursorImageView.clear();
        for (int i = 0; i < count; ++i) {
            ImageView imageView = new ImageView(this.mContext);
            if (i == index) {
                imageView.setImageResource(R.drawable.dot_xuanzhong);
            } else {
                imageView.setImageResource(R.drawable.dot_weixuanzhong);
            }
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(new ViewGroup.LayoutParams(-2, -2));
            layoutParams.leftMargin = 10;
            layoutParams.rightMargin = 10;
            layoutParams.gravity = 48;
            this.cursorLayout.addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
            this.cursorImageView.add(imageView);
        }
        this.cursorLayout.setBackgroundColor(-1);
    }

    protected EmoticonsGridAdapter.IEmoticonsInsertListener<EmoticonFilter.SmileItem> getEmoticonsInsertListener(final EditText edit) {
        return new EmoticonsGridAdapter.IEmoticonsInsertListener<EmoticonFilter.SmileItem>(){

            @Override
            public void onInsertSmiley(EmoticonFilter.SmileItem s) {
                boolean overLimited;
                if (EmoticonsView.this.mIMomoEmotionListener != null) {
                    EmoticonsView.this.mIMomoEmotionListener.onIMomoEmotionClick(s.getText());
                }
                if (edit == null) {
                    return;
                }
                if (s.getText().equals("/{del")) {
                    KeyEvent deleteEvent = new KeyEvent(0, 67);
                    edit.onKeyDown(67, deleteEvent);
                    return;
                }
                String beforeAddSmileItemText = edit.getText().toString();
                Boolean isEndOfTheText = true;
                int beforeSeletionPosition = 0;
                String text = edit.getText().toString();
                if (edit.getSelectionStart() == text.length()) {
                    text = text + s.getText();
                } else {
                    isEndOfTheText = false;
                    beforeSeletionPosition = edit.getSelectionStart();
                    text = text.substring(0, edit.getSelectionStart()) + s.getText() + text.substring(edit.getSelectionStart(), text.length());
                }
                if (EmoticonsView.this.mLimitedListener != null && (overLimited = EmoticonsView.this.mLimitedListener.onEmoticonLimited(text))) {
                    return;
                }
                edit.setText((CharSequence)text);
                if (!edit.getText().toString().equals(text)) {
                    edit.setText((CharSequence)beforeAddSmileItemText);
                }
                if (isEndOfTheText.booleanValue()) {
                    edit.setSelection(edit.getText().toString().length());
                } else if (beforeAddSmileItemText.equals(edit.getText().toString())) {
                    edit.setSelection(beforeSeletionPosition);
                } else {
                    edit.setSelection(beforeSeletionPosition + s.getText().length());
                }
            }
        };
    }

    private void initIndex(List<EmoticonsPageAdapter> adapterList) {
        for (int i = 0; i < adapterList.size(); ++i) {
            for (int j = 0; j < adapterList.get(i).getCount(); ++j) {
                this.mAdapterIndex.add(i);
                this.mAdapterItemIndex.add(j);
            }
        }
    }

    public class ScrollEmoticonsPageAdapter
    extends PagerAdapter {
        private Context mContext;
        private List<EmoticonsPageAdapter> mAdapterList;

        public ScrollEmoticonsPageAdapter(Context context, List<EmoticonsPageAdapter> adapterList) {
            this.mContext = context;
            this.mAdapterList = adapterList;
            EmoticonsView.this.initIndex(this.mAdapterList);
        }

        public int getAdapterIndex(int position) {
            return (Integer)EmoticonsView.this.mAdapterIndex.get(position);
        }

        public int getAdapterItemIndex(int position) {
            return (Integer)EmoticonsView.this.mAdapterItemIndex.get(position);
        }

        public int getCount() {
            return EmoticonsView.this.mAdapterIndex.size();
        }

        public boolean isViewFromObject(View view, Object o) {
            return view == o;
        }

        public Object instantiateItem(ViewGroup container, int position) {
            return this.mAdapterList.get(this.getAdapterIndex(position)).instantiateItem(container, this.getAdapterItemIndex(position));
        }

        public void destroyItem(ViewGroup container, int position, Object view) {
            container.removeView((View)view);
        }
    }

    public static interface IEmoticonLimitedListener {
        public boolean onEmoticonLimited(String var1);
    }

    public static interface IMomoEmotionListener {
        public void onIMomoEmotionClick(String var1);
    }

    public static interface IEmoticonsMessageListener {
        public void sendMessageFromEmoticon(String var1);
    }
}

