/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.cropper.cropwindow.handle;

import android.graphics.Rect;
import com.yy.mobile.ui.widget.cropper.cropwindow.edge.Edge;
import com.yy.mobile.ui.widget.cropper.cropwindow.handle.HandleHelper;
import com.yy.mobile.ui.widget.cropper.util.AspectRatioUtil;

class VerticalHandleHelper
extends HandleHelper {
    private Edge mEdge;

    VerticalHandleHelper(Edge edge) {
        super(null, edge);
        this.mEdge = edge;
    }

    @Override
    void updateCropWindow(float x, float y, float targetAspectRatio, Rect imageRect, float snapRadius) {
        float offset;
        this.mEdge.adjustCoordinate(x, y, imageRect, snapRadius, targetAspectRatio);
        float left = Edge.LEFT.getCoordinate();
        float top = Edge.TOP.getCoordinate();
        float right = Edge.RIGHT.getCoordinate();
        float bottom = Edge.BOTTOM.getCoordinate();
        float targetHeight = AspectRatioUtil.calculateHeight(left, right, targetAspectRatio);
        float currentHeight = bottom - top;
        float difference = targetHeight - currentHeight;
        float halfDifference = difference / 2.0f;
        Edge.TOP.setCoordinate(top -= halfDifference);
        Edge.BOTTOM.setCoordinate(bottom += halfDifference);
        if (Edge.TOP.isOutsideMargin(imageRect, snapRadius) && !this.mEdge.isNewRectangleOutOfBounds(Edge.TOP, imageRect, targetAspectRatio)) {
            offset = Edge.TOP.snapToRect(imageRect);
            Edge.BOTTOM.offset(-offset);
            this.mEdge.adjustCoordinate(targetAspectRatio);
        }
        if (Edge.BOTTOM.isOutsideMargin(imageRect, snapRadius) && !this.mEdge.isNewRectangleOutOfBounds(Edge.BOTTOM, imageRect, targetAspectRatio)) {
            offset = Edge.BOTTOM.snapToRect(imageRect);
            Edge.TOP.offset(-offset);
            this.mEdge.adjustCoordinate(targetAspectRatio);
        }
    }
}

