/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.ImageView;
import com.yy.mobile.memoryrecycle.views.YYImageView;

public class RoundBgImageView
extends YYImageView {
    private Paint mPaint;
    private int mColor = 0;
    private int mSelectColor = 0;

    public RoundBgImageView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.mPaint = new Paint();
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setAntiAlias(true);
        this.setScaleType(ImageView.ScaleType.CENTER);
    }

    public RoundBgImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public RoundBgImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void setBackgroundColor(int color2) {
        this.mColor = color2;
        this.mSelectColor = color2;
        this.mPaint.setColor(color2);
        this.invalidate();
    }

    public void setBackgroundColor(int color2, int selectColor) {
        this.mColor = color2;
        this.mSelectColor = selectColor;
        this.mPaint.setColor(this.isSelected() ? selectColor : color2);
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), (float)(this.getHeight() / 2), this.mPaint);
        super.onDraw(canvas);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event == null) {
            if (this.mPaint.getColor() != this.mColor) {
                this.mPaint.setColor(this.mColor);
                this.invalidate();
            }
            return super.onTouchEvent(event);
        }
        if (event.getAction() == 0) {
            boolean result = super.onTouchEvent(event);
            if (result && this.mPaint.getColor() != this.mSelectColor) {
                this.mPaint.setColor(this.mSelectColor);
                this.invalidate();
            }
            return result;
        }
        if (event.getAction() == 1 || event.getAction() == 3) {
            if (this.mPaint.getColor() != this.mColor) {
                this.mPaint.setColor(this.mColor);
                this.invalidate();
            }
            return super.onTouchEvent(event);
        }
        return super.onTouchEvent(event);
    }
}

