/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewTreeObserver;
import com.yy.mobile.util.ScreenUtil;
import java.util.LinkedList;
import java.util.List;

public class SoftKeyboardStateHelper
implements ViewTreeObserver.OnGlobalLayoutListener {
    private static final String TAG = "SoftKeyboardStateHelper";
    private final List<SoftKeyboardStateListener> listeners = new LinkedList<SoftKeyboardStateListener>();
    private final View activityRootView;
    private int lastSoftKeyboardHeightInPx;
    private boolean isSoftKeyboardOpened;

    public SoftKeyboardStateHelper(View activityRootView) {
        this(activityRootView, false);
    }

    public SoftKeyboardStateHelper(View activityRootView, boolean isSoftKeyboardOpened) {
        this.activityRootView = activityRootView;
        this.isSoftKeyboardOpened = isSoftKeyboardOpened;
        activityRootView.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    private int getOffset() {
        return ScreenUtil.getStatusBarHeight() + ScreenUtil.getNavigationBarHeight();
    }

    public void onGlobalLayout() {
        Rect r = new Rect();
        this.activityRootView.getWindowVisibleDisplayFrame(r);
        int heightDiff = this.activityRootView.getRootView().getHeight() - (r.bottom - r.top);
        if (!this.isSoftKeyboardOpened && heightDiff > this.getOffset()) {
            this.isSoftKeyboardOpened = true;
            this.notifyOnSoftKeyboardOpened(heightDiff);
        } else if (this.isSoftKeyboardOpened && heightDiff <= this.getOffset()) {
            this.isSoftKeyboardOpened = false;
            this.notifyOnSoftKeyboardClosed();
        }
    }

    public void setIsSoftKeyboardOpened(boolean isSoftKeyboardOpened) {
        this.isSoftKeyboardOpened = isSoftKeyboardOpened;
    }

    public boolean isSoftKeyboardOpened() {
        return this.isSoftKeyboardOpened;
    }

    public int getLastSoftKeyboardHeightInPx() {
        return this.lastSoftKeyboardHeightInPx;
    }

    public void addSoftKeyboardStateListener(SoftKeyboardStateListener listener) {
        this.listeners.add(listener);
    }

    public void removeSoftKeyboardStateListener(SoftKeyboardStateListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyOnSoftKeyboardOpened(int keyboardHeightInPx) {
        this.lastSoftKeyboardHeightInPx = keyboardHeightInPx;
        for (SoftKeyboardStateListener listener : this.listeners) {
            if (listener == null) continue;
            listener.onSoftKeyboardOpened(keyboardHeightInPx);
        }
    }

    private void notifyOnSoftKeyboardClosed() {
        for (SoftKeyboardStateListener listener : this.listeners) {
            if (listener == null) continue;
            listener.onSoftKeyboardClosed();
        }
    }

    public static interface SoftKeyboardStateListener {
        public void onSoftKeyboardOpened(int var1);

        public void onSoftKeyboardClosed();
    }
}

