/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import android.util.Log;
import com.yy.mobile.http.dns.CommonUtilsKt;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.SdkInitStatusRecorder;
import com.yy.mobile.util.log.MLog;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/yy/mobile/http/GlideIPv6Interceptors;", "Lokhttp3/Interceptor;", "()V", "mInitFinish", "", "mNetDispose", "Lio/reactivex/disposables/Disposable;", "replaceList", "", "", "sdkInitStatus", "Ljava/util/concurrent/atomic/AtomicBoolean;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "sdkInitState", "updateFlag", "", "Companion", "framework_release"})
public final class GlideIPv6Interceptors
implements Interceptor {
    private final List<String> replaceList = CollectionsKt.listOf((Object[])new String[]{"emyfs.zhiniu8.com", "mobilelivephoto.bs2dl.myzhiniu.com", "mpstatic.zhiniu8.com"});
    private Disposable mNetDispose;
    private AtomicBoolean sdkInitStatus;
    private boolean mInitFinish;
    @NotNull
    public static final String TAG = "GlideIPv6Interceptors-GslbDns_";
    private static boolean abFlag;
    private static boolean mParseV6Host;
    public static final Companion Companion;

    private final void updateFlag() {
        this.sdkInitStatus.set(SdkInitStatusRecorder.INSTANCE.isInstalled().get());
        if (!this.sdkInitStatus.get()) {
            Log.d((String)TAG, (String)"sdk is not ready");
            return;
        }
        boolean v4Stack = CommonUtilsKt.INSTANCE.isIpv4Only(false);
        boolean v6Stack = CommonUtilsKt.INSTANCE.isIpv6Only(false);
        boolean ret = abFlag && !v4Stack;
        mParseV6Host = ret || v6Stack;
        MLog.info(TAG, "init canParse2Ipv6:" + mParseV6Host + ",v4Stack:" + v4Stack + ",v6Stack:" + v6Stack, new Object[0]);
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Request request = chain.request();
        MLog.info(TAG, "intercept url = " + request.url(), new Object[0]);
        if (this.sdkInitState() && !mParseV6Host) {
            Response response = chain.proceed(request);
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"chain.proceed(request)");
            return response;
        }
        String host = request.url().host();
        if (this.replaceList.contains(host)) {
            String schema = request.url().scheme();
            String string = request.url().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"request.url().toString()");
            String url = string;
            url = StringsKt.replace$default((String)url, (String)(schema + "://" + host), (String)("http://ipv6-" + host), (boolean)false, (int)4, null);
            MLog.info(TAG, "after replace = " + url, new Object[0]);
            HttpUrl.Builder builder = request.url().newBuilder(url);
            if (builder != null) {
                request = request.newBuilder().url(builder.build()).build();
            } else {
                MLog.error((Object)TAG, "wht:" + url, new Object[0]);
            }
        }
        Response response = chain.proceed(request);
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"chain.proceed(request)");
        return response;
    }

    private final boolean sdkInitState() {
        return !this.mInitFinish ? (this.mInitFinish = this.sdkInitStatus.get()) : true;
    }

    public GlideIPv6Interceptors() {
        NetworkUtils.addListenerList(new NetworkUtils.NetworkUpdateListener(){

            @Override
            public final void networkUpdate() {
                Disposable disposable = mNetDispose;
                if (disposable != null) {
                    disposable.dispose();
                }
                mNetDispose = Observable.just((Object)"go").subscribeOn(Schedulers.io()).delay(3L, TimeUnit.SECONDS).subscribe((Consumer)new Consumer<String>(){

                    public final void accept(String it) {
                        MLog.info(GlideIPv6Interceptors.TAG, "\u7f51\u7edc\u53d8\u5316", new Object[0]);
                        this.updateFlag();
                    }
                }, (Consumer)2.INSTANCE);
            }
        });
        this.sdkInitStatus = new AtomicBoolean(true);
        this.updateFlag();
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/yy/mobile/http/GlideIPv6Interceptors$Companion;", "", "()V", "TAG", "", "abFlag", "", "getAbFlag", "()Z", "setAbFlag", "(Z)V", "mParseV6Host", "updateParseV6Host", "", "ip", "Lcom/yy/mobile/http/dns/CommonUtilsKt$IP;", "framework_release"})
    public static final class Companion {
        public final boolean getAbFlag() {
            return abFlag;
        }

        public final void setAbFlag(boolean bl) {
            abFlag = bl;
        }

        public final void updateParseV6Host(@NotNull CommonUtilsKt.IP ip) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)ip), (String)"ip");
            mParseV6Host = this.getAbFlag() && ip != CommonUtilsKt.IP.IPV4_ONLY || ip == CommonUtilsKt.IP.IPV6_ONLY;
            MLog.info(GlideIPv6Interceptors.TAG, "updateParseV6Host: mParseV6Host = " + mParseV6Host, new Object[0]);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

