/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.smoothness;

import android.annotation.TargetApi;
import android.os.Build;
import android.view.Choreographer;
import com.yy.mobile.util.log.FastDateFormat;
import com.yy.mobile.util.log.MLog;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;

@TargetApi(value=16)
public class Smoothness
implements Choreographer.FrameCallback {
    private static final String TAG = "Smoothness";
    public static boolean DEBUG = true;
    private static Smoothness sSmoothness;
    private static final FastDateFormat sDateFormat;
    private static int sSkippedFrameWarningLimit;
    private long mFrameIntervalNanos;
    private long mLastFrameTime;
    private long mLastTimeMillis;

    public static synchronized Smoothness getInstance() {
        if (sSmoothness == null) {
            sSmoothness = new Smoothness();
        }
        return sSmoothness;
    }

    public void init() {
        try {
            if (Build.VERSION.SDK_INT >= 16) {
                this.mFrameIntervalNanos = (long)(1.0E9f / this.getRefreshRate());
                this.initSystemProperties();
                this.postFrameCallback();
                if (DEBUG && !MLog.isLogLevelAboveVerbose()) {
                    MLog.verbose(TAG, "Init interval:%d skipLimit:%d", this.mFrameIntervalNanos, sSkippedFrameWarningLimit);
                }
            }
        }
        catch (Throwable t) {
            MLog.error((Object)TAG, "Init error.", t, new Object[0]);
        }
    }

    private void initSystemProperties() {
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method m = c.getMethod("getInt", String.class, Integer.TYPE);
            sSkippedFrameWarningLimit = (Integer)m.invoke(null, "debug.choreographer.skipwarning", 30);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "Init SystemProperties error.", e, new Object[0]);
            sSkippedFrameWarningLimit = 30;
        }
    }

    private float getRefreshRate() {
        try {
            Class<?> c = Class.forName("android.hardware.display.DisplayManagerGlobal");
            Method getInstance = c.getMethod("getInstance", new Class[0]);
            Object instance2 = getInstance.invoke(null, new Object[0]);
            Method getDisplayInfo = c.getMethod("getDisplayInfo", Integer.TYPE);
            Object displayInfo = getDisplayInfo.invoke(instance2, 0);
            Class<?> displayInfoClass = Class.forName("android.view.DisplayInfo");
            Field refreshRate = displayInfoClass.getField("refreshRate");
            float refreshRateValue = refreshRate.getFloat(displayInfo);
            return refreshRateValue;
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "Init getRefreshRate error.", e, new Object[0]);
            return 60.0f;
        }
    }

    protected void postFrameCallback() {
        Choreographer choreographer = Choreographer.getInstance();
        choreographer.postFrameCallback((Choreographer.FrameCallback)this);
    }

    public void doFrame(long frameTimeNanos) {
        long diff = frameTimeNanos - this.mLastFrameTime;
        this.mLastFrameTime = frameTimeNanos;
        if (diff > this.mFrameIntervalNanos) {
            long skippedFrames = diff / this.mFrameIntervalNanos;
            if (skippedFrames >= (long)sSkippedFrameWarningLimit) {
                String dateString = sDateFormat.format(this.mLastTimeMillis);
                MLog.warn(TAG, "Skipped %d frames! The application may be doing too much work on its main thread.LastTime is %s", skippedFrames, dateString);
            } else if (DEBUG) {
                // empty if block
            }
        }
        this.mLastTimeMillis = System.currentTimeMillis();
        this.postFrameCallback();
    }

    public void printStack() {
        Map<Thread, StackTraceElement[]> traceMap = Thread.getAllStackTraces();
        for (StackTraceElement[] traces : traceMap.values()) {
            Throwable error = new Throwable("");
            error.setStackTrace(traces);
            MLog.error((Object)TAG, "printStack", error, new Object[0]);
        }
    }

    static {
        sDateFormat = FastDateFormat.getInstance("kk:mm:ss.SSS");
    }
}

