/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import android.util.Pair;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.BasicFileUtils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.MD5Utils;
import com.yy.mobile.util.StorageUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.valid.BlankUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class YYFileUtils
extends BasicFileUtils {
    public static final String TEMP_DIR = "temp";
    private static final String IMAGE_DIR = "/image";
    private static final String ACT_RECOMMAND_FILE = "temp_act_recomm.txt";
    private static final String RECORD_EXT_HIGH_CPU = ".aac";
    private static final String RECORD_EXT_LOW_CPU = ".wav";
    private static final String RECORD_PUBLISH_EXT = ".m4a";
    private static final int MIN_LEN_OF_VALID_WAV = 131072;
    private static final int MIN_LEN_OF_VALID_AAC = 8192;
    static final String[] AUDIO_EXTS = new String[]{".aac", ".wav", ".m4a", ".rec", ".mp4", ".rec2"};
    private FileOutputStream mFileOutputStream = null;
    private BufferedOutputStream mBufferedOutputStream = null;
    private File mFile;
    private static final String BARCODE_FILE_EXT = ".png";
    private static final String YY_BARCODE_DIR = "YYBarcode";
    private static final String TAG = "YYFileUtils";
    private static final int MAX_FILENAME_LENGTH = 24;
    private static final Pattern NOT_ALPHANUMERIC = Pattern.compile("[^A-Za-z0-9]");
    private static final int MAX_BUFF_SIZE = 0x100000;
    private static final int MIN_BUFF_SIZE = 4096;

    public static boolean isValidAudioFile(String path) {
        String ext;
        if (!BlankUtil.isBlank(path) && !BlankUtil.isBlank(ext = YYFileUtils.getFileExtension(path))) {
            for (String extItem : AUDIO_EXTS) {
                if (!ext.equalsIgnoreCase(extItem)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getPkgDir(Context context) {
        return context.getFilesDir().getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTxtFileContent(Context context, String fileName) {
        String path = fileName;
        String content = "";
        if (BlankUtil.isBlank(fileName)) {
            return content;
        }
        File file = new File(path);
        if (file.isFile()) {
            InputStream instream = null;
            try {
                instream = fileName.startsWith(context.getFilesDir().getPath()) ? context.openFileInput(YYFileUtils.getFileName(fileName)) : new FileInputStream(file);
                if (instream != null) {
                    String line;
                    InputStreamReader inputreader = new InputStreamReader(instream);
                    BufferedReader buffreader = new BufferedReader(inputreader);
                    StringBuffer contentBuffer = new StringBuffer();
                    while ((line = buffreader.readLine()) != null) {
                        contentBuffer.append(line).append("\n");
                    }
                    content = contentBuffer.toString();
                    buffreader.close();
                }
            }
            catch (Throwable e) {
                MLog.error((Object)TAG, "getTxtFileContent error! " + e, new Object[0]);
            }
            finally {
                if (instream != null) {
                    try {
                        instream.close();
                    }
                    catch (Exception e) {
                        MLog.error((Object)TAG, "Empty Catch on getTxtFileContent", e, new Object[0]);
                    }
                }
            }
        }
        return content;
    }

    public static String getFileExtension(String filePath) {
        String fileName = YYFileUtils.getFileName(filePath);
        int index = fileName.lastIndexOf(".");
        if (index != -1) {
            return fileName.substring(index);
        }
        return null;
    }

    public static String getFileName(String filePath) {
        if (filePath != null) {
            String slash = File.separator;
            int pos = filePath.lastIndexOf(slash) + 1;
            return filePath.substring(pos);
        }
        return null;
    }

    public static String dropExt(String fname) {
        int pos;
        if (!FP.empty(fname) && (pos = fname.lastIndexOf(".")) != -1) {
            return FP.take(pos, fname);
        }
        return fname;
    }

    public static boolean isFileExisted(String filePath) {
        if (BlankUtil.isBlank(filePath)) {
            return false;
        }
        try {
            File file = new File(filePath);
            return file.exists() && file.length() > 0L;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void renameFile(String oldFile, String newFile) {
        try {
            File file = new File(oldFile);
            file.renameTo(new File(newFile));
        }
        catch (Exception e) {
            MLog.error(TAG, e);
        }
    }

    public static void removeFiles(List<Pair<Integer, String>> fileNames) {
        for (Pair<Integer, String> p : fileNames) {
            if (p.second == null) continue;
            YYFileUtils.removeFile((String)p.second);
        }
    }

    public static void removeFile(String filename) {
        if (!BlankUtil.isBlank(filename)) {
            try {
                File file = new File(filename);
                file.delete();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Empty Catch on removeFile", (Throwable)e);
            }
        }
    }

    public static void removeDir(String dirPath) {
        File[] fileList;
        File dir = new File(dirPath);
        if (dir.isDirectory() && (fileList = dir.listFiles()) != null && fileList.length > 0) {
            for (File file : fileList) {
                file.delete();
            }
        }
        dir.delete();
    }

    public static void rm(String fname) {
        YYFileUtils.rm(new File(fname));
    }

    public static void rm(File f) {
        if (f.exists()) {
            if (f.isDirectory()) {
                for (File i : FP.ref(f.listFiles())) {
                    YYFileUtils.rm(i);
                }
            } else {
                f.delete();
            }
        }
    }

    public static File getFileFromURL(String base, String url) {
        if (BlankUtil.isBlank(url)) {
            return null;
        }
        int idx = url.lastIndexOf(File.separatorChar);
        return new File(base, url.substring(idx + 1));
    }

    public static String getImageFilePathFromUri(Context context, Uri uri) {
        ContentResolver cr;
        Cursor cursor;
        if (uri == null) {
            return null;
        }
        File file = new File(uri.getPath());
        if (file.isFile()) {
            return file.getPath();
        }
        if ("file".equals(uri.getScheme())) {
            String ret = uri.toString().substring(7);
            ret = YYFileUtils.decodeUri(ret);
            return ret;
        }
        if ("content".equals(uri.getScheme()) && (cursor = (cr = context.getContentResolver()).query(uri, new String[]{"_data"}, null, null, null)) != null && cursor.moveToFirst()) {
            int index = cursor.getColumnIndexOrThrow("_data");
            String ret = cursor.getString(index);
            ret = YYFileUtils.decodeUri(ret);
            cursor.close();
            return ret;
        }
        return null;
    }

    public static String decodeUri(String uri) {
        if (BlankUtil.isBlank(uri)) {
            return uri;
        }
        int index = uri.indexOf(37);
        if (index != -1) {
            uri = Uri.decode((String)uri);
        }
        return uri;
    }

    public static boolean isSDCardMounted() {
        return BasicFileUtils.availableMemInSDcard();
    }

    public static boolean externalStorageExist() {
        boolean ret = false;
        ret = Environment.getExternalStorageState().equalsIgnoreCase("mounted");
        return ret;
    }

    public static boolean checkFileValidation(String filepath, String md5) throws IOException {
        String fileMd5 = MD5Utils.getFileMd5String(filepath);
        if (fileMd5 == null) {
            return false;
        }
        return fileMd5.equals(md5);
    }

    public static File getTempFile(Context context, String uniqueName) {
        String tempPath = BasicConfig.getInstance().getRootDir().getAbsolutePath() + File.separator + TEMP_DIR;
        File tmpFile = new File(tempPath);
        if (!tmpFile.exists()) {
            tmpFile.mkdirs();
        }
        return new File(tmpFile.getAbsolutePath() + File.separator + uniqueName);
    }

    @Deprecated
    public static void saveBitmapToPNG(Bitmap bitmap, String filePath) throws Exception {
        YYFileUtils.saveBitmap(bitmap, filePath, Bitmap.CompressFormat.PNG);
    }

    @Deprecated
    public static void saveBitmapToJPG(Bitmap bitmap, String filePath) throws Exception {
        YYFileUtils.saveBitmap(bitmap, filePath, Bitmap.CompressFormat.JPEG);
    }

    @Deprecated
    public static void saveBitmap(Bitmap bitmap, String filePath, Bitmap.CompressFormat format) throws Exception {
        YYFileUtils.saveBitmap(bitmap, filePath, format, 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void saveBitmap(Bitmap bitmap, String filePath, Bitmap.CompressFormat format, int quality) throws Exception {
        File barcodeFile;
        if (bitmap == null) {
            return;
        }
        if (format == null) {
            format = Bitmap.CompressFormat.PNG;
        }
        if (!(barcodeFile = new File(filePath)).exists()) {
            barcodeFile.createNewFile();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(barcodeFile);
            bitmap.compress(format, quality, (OutputStream)fos);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    MLog.error(TAG, ioe);
                }
            }
        }
    }

    public static String dropPrefix(String s, String prefix) {
        return s.startsWith(prefix) ? FP.drop(FP.length(prefix), s) : s;
    }

    public static String concatPath(String p1, String p2) {
        return p1.endsWith(File.separator) ? p1 + YYFileUtils.dropPrefix(p2, File.separator) : p1 + File.separator + YYFileUtils.dropPrefix(p2, File.separator);
    }

    public static String concatPaths(String ... ss) {
        String path = "";
        for (String s : ss) {
            path = YYFileUtils.concatPath(path, s);
        }
        return path;
    }

    public static String getYYActRecommFilename(Context context) {
        File file = context.getFileStreamPath(ACT_RECOMMAND_FILE);
        return file.getPath();
    }

    public static String getPropsConfigNotifyFilePath(Context context, String url) {
        String fileName = url;
        int index = url.lastIndexOf(File.separatorChar);
        if (index != -1) {
            fileName = url.substring(index + 1);
        }
        File cacheDir = StorageUtils.getIndividualCacheDirectory(context);
        File propsConfigFile = new File(cacheDir, fileName);
        return propsConfigFile.getAbsolutePath();
    }

    public static YYFileUtils createFile(String path) throws Exception {
        String dir = YYFileUtils.getDirOfFilePath(path);
        String name = YYFileUtils.getFileName(path);
        File f = BasicFileUtils.createFileOnSD(dir, name);
        return new YYFileUtils(f, null);
    }

    public static YYFileUtils openFile(String filePath) throws Exception {
        String dirPath = filePath.substring(0, filePath.lastIndexOf(File.separator));
        BasicFileUtils.createDir(dirPath, true);
        File file = new File(filePath);
        if (!file.exists() && !file.createNewFile()) {
            file = null;
        }
        return new YYFileUtils(file, null);
    }

    private YYFileUtils(File file, FileOutputStream fileos) throws Exception {
        this.mFile = file;
        this.mFileOutputStream = fileos;
        if (this.mFile != null) {
            if (this.mFileOutputStream == null) {
                this.mFileOutputStream = new FileOutputStream(this.mFile);
            }
        } else {
            throw new Exception("YYFileOutput, can not create file output stream");
        }
        this.mBufferedOutputStream = new BufferedOutputStream(this.mFileOutputStream);
    }

    public static boolean ensureFileDirExists(String filePath) {
        String dir = YYFileUtils.getDirOfFilePath(filePath);
        if (BlankUtil.isBlank(dir)) {
            return false;
        }
        BasicFileUtils.ensureDirExists(dir);
        return true;
    }

    public static String getDirOfFilePath(String filePath) {
        if (BlankUtil.isBlank(filePath)) {
            return null;
        }
        int sepPos = filePath.lastIndexOf(File.separatorChar);
        if (sepPos == -1) {
            return null;
        }
        return filePath.substring(0, sepPos);
    }

    public boolean write(Bitmap bitmap) {
        return this.write(bitmap, 80);
    }

    public boolean write(Bitmap bitmap, int compressRate) {
        return bitmap.compress(Bitmap.CompressFormat.JPEG, compressRate, (OutputStream)this.mBufferedOutputStream);
    }

    public void writeYCbCr420SP(byte[] data, int width, int height) {
        YuvImage image = new YuvImage(data, 17, width, height, null);
        image.compressToJpeg(new Rect(0, 0, width, height - 1), 100, (OutputStream)this.mBufferedOutputStream);
    }

    public void write(InputStream is) {
        int bytes = 0;
        byte[] buffer = new byte[4096];
        try {
            while ((bytes = is.read(buffer)) != -1) {
                this.mBufferedOutputStream.write(buffer, 0, bytes);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(String fileName) {
        try {
            FileInputStream fis = new FileInputStream(fileName);
            this.write(fis);
            fis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void write(byte[] buffer) {
        try {
            this.mBufferedOutputStream.write(buffer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(byte[] buffer, int offset, int length) {
        try {
            this.mBufferedOutputStream.write(buffer, offset, length);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        try {
            if (this.mBufferedOutputStream != null) {
                this.mBufferedOutputStream.flush();
                this.mBufferedOutputStream.close();
            }
            if (this.mFileOutputStream != null) {
                this.mFileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public File getFile() {
        return this.mFile;
    }

    public static long getFileLength(String file) {
        File tmp = new File(file);
        return tmp.length();
    }

    public static String fallbackFile(String file) {
        String ext = BasicFileUtils.getFileExt(file);
        int i = file.lastIndexOf(".");
        return i == -1 ? "" : file.substring(0, i + 1) + "bak" + ext;
    }

    public static boolean isValidRecordFile(String filePath) {
        if (!YYFileUtils.isFileExisted(filePath)) {
            return false;
        }
        String ext = YYFileUtils.getFileExtension(filePath);
        if (ext == null) {
            return false;
        }
        boolean aac = false;
        aac = ext.equalsIgnoreCase(RECORD_EXT_HIGH_CPU);
        if (!aac && !ext.equalsIgnoreCase(RECORD_EXT_LOW_CPU)) {
            return false;
        }
        long len = YYFileUtils.getFileLength(filePath);
        long minLen = aac ? 8192L : 131072L;
        boolean ret = len >= minLen;
        return ret;
    }

    public static long getFileSize(File file) throws Exception {
        long size = 0L;
        File[] fileList = file.listFiles();
        if (fileList != null) {
            for (int i = 0; i < fileList.length; ++i) {
                if (fileList[i].isDirectory()) {
                    size += YYFileUtils.getFileSize(fileList[i]);
                    continue;
                }
                size += fileList[i].length();
            }
        }
        return size;
    }

    public static String getHumanReadableFileSize(long bytes) {
        if (bytes < 1024L) {
            return YYFileUtils.getFileSizeInBytes(bytes);
        }
        return bytes >> 20 == 0L ? YYFileUtils.getFileSizeInKBytes(bytes) : YYFileUtils.getFileSizeInMBytes(bytes);
    }

    public static String getFileSizeInBytes(long bytes) {
        return String.format("%dB", bytes);
    }

    public static String getFileSizeInKBytes(long bytes) {
        long kbs = bytes >> 10;
        return String.format("%dK", kbs);
    }

    public static String getFileSizeInMBytes(long bytes) {
        float kbs = (float)bytes / 1024.0f;
        float mbs = kbs / 1024.0f;
        DecimalFormat df = new DecimalFormat("0.00M");
        String ret = df.format(mbs);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void saveBitmapToPublicDir(Bitmap bitmap, String fileName) {
        if (bitmap == null) {
            return;
        }
        File barcodesRoot = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), YY_BARCODE_DIR);
        if (!barcodesRoot.exists() && !barcodesRoot.mkdirs()) {
            return;
        }
        File barcodeFile = new File(barcodesRoot, YYFileUtils.makeFileName(fileName) + BARCODE_FILE_EXT);
        barcodeFile.delete();
        FileOutputStream fos = null;
        fos = new FileOutputStream(barcodeFile);
        bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)fos);
        if (fos == null) return;
        try {
            fos.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        catch (FileNotFoundException fnfe) {
            if (fos == null) return;
            try {
                fos.close();
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
            catch (Throwable throwable) {
                if (fos == null) throw throwable;
                try {
                    fos.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private static String makeFileName(CharSequence contents) {
        String fileName = NOT_ALPHANUMERIC.matcher(contents).replaceAll("_");
        if (fileName.length() > 24) {
            fileName = fileName.substring(0, 24);
        }
        return fileName;
    }

    public static byte[] fileToByteArray(File file) {
        if (!file.exists() || !file.canRead()) {
            return null;
        }
        try {
            return YYFileUtils.streamToBytes(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] streamToBytes(InputStream inputStream) {
        byte[] content = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        try {
            byte[] buffer = new byte[1024];
            int length = 0;
            while ((length = bis.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            content = baos.toByteArray();
            if (content.length == 0) {
                content = null;
            }
            baos.close();
            bis.close();
        }
        catch (IOException iOException) {
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return content;
    }

    public static void copyFile(File src, File des) throws IOException {
        if (des.exists()) {
            des.delete();
        }
        des.createNewFile();
        FileInputStream in = new FileInputStream(src);
        int length = in.available();
        if (length == 0) {
            length = 4096;
        } else if (length >= 0x100000) {
            length = 0x100000;
        }
        FileOutputStream out = new FileOutputStream(des);
        byte[] buffer = new byte[length];
        while (true) {
            int ins;
            if ((ins = in.read(buffer)) == -1) {
                in.close();
                out.flush();
                out.close();
                return;
            }
            out.write(buffer, 0, ins);
        }
    }

    public static boolean copyFile(String inFileName, String outFileName) {
        try {
            YYFileUtils.copyFile(new File(inFileName), new File(outFileName));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getImagePathFromURL(String basePath, String url) {
        if (BlankUtil.isBlank(url)) {
            return null;
        }
        int idx = url.lastIndexOf(File.separatorChar);
        String path = url.substring(idx + 1);
        return basePath + File.separator + path;
    }

    public static void deleteOldFiles(String dirPath, final String postfix, long downloadTime) {
        File dir = new File(dirPath);
        if (dir.isDirectory()) {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String filename) {
                    return filename.toLowerCase().indexOf(postfix) != -1;
                }
            };
            ArrayList portraitList = new ArrayList();
            File[] fileList = dir.listFiles(filter);
            if (fileList != null && fileList.length > 0) {
                long current = System.currentTimeMillis();
                for (File file : fileList) {
                    if (portraitList.contains(file.getPath()) || current - file.lastModified() <= downloadTime) continue;
                    file.delete();
                }
            }
        }
    }

    public static boolean isSameFile(String path1, String path2) {
        if (path1 == null || path2 == null) {
            return false;
        }
        return new File(path1).equals(new File(path2));
    }

    public static String getRootDir() {
        return BasicConfig.getInstance().getRootDir().getAbsolutePath();
    }

    public static String getYYTempDir() {
        return YYFileUtils.getRootDir() + TEMP_DIR;
    }

    public static String getYYImReceivedImageDir() {
        return YYFileUtils.getRootDir() + IMAGE_DIR + File.separator;
    }

    public static String getYYImageFileLocalPath(String name) {
        if (FP.empty(name)) {
            return name;
        }
        String filename = name;
        int index = name.lastIndexOf(File.separatorChar);
        if (index != -1) {
            filename = name.substring(index + 1);
        }
        String dirPath = YYFileUtils.getYYImReceivedImageDir();
        BasicFileUtils.createDir(dirPath, true);
        return dirPath + filename;
    }

    public static boolean isTempFile(Context c, String path) {
        File temp = YYFileUtils.getTempFile(c, YYFileUtils.getFileName(path));
        return StringUtils.equal(path, temp.getPath());
    }

    public static String getLocalPathFromUrl(String url) {
        String fileName = url.substring(url.lastIndexOf("/") + 1, url.length());
        return YYFileUtils.getYYImReceivedImageDir() + fileName;
    }

    public static byte[] getBytes(String filePath) {
        byte[] buffer = null;
        try {
            int n;
            File file = new File(filePath);
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "getBytes error!" + e, new Object[0]);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToFile(byte[] bfile, String filePath, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            File dir = new File(filePath);
            if (!dir.exists() && dir.isDirectory()) {
                dir.mkdirs();
            }
            file = new File(filePath + File.separator + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bfile);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "saveFile error!" + e, new Object[0]);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, "saveFile error!" + e, new Object[0]);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, "saveFile error!" + e, new Object[0]);
                }
            }
        }
    }

    public static boolean saveToFile(String str, String path) {
        ByteArrayInputStream stream = new ByteArrayInputStream(str.getBytes());
        try {
            FileOutputStream os = new FileOutputStream(path);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = stream.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            ((OutputStream)os).close();
            stream.close();
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "saveToPath error!" + e, new Object[0]);
            return false;
        }
        return true;
    }

    public static void saveJsonData(String jsonString, String fileName) {
        try {
            FileWriter file = new FileWriter(fileName);
            file.write(jsonString);
            file.close();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"printStackTrace", (Throwable)e);
        }
    }

    public static String readJsonData(String fileName) {
        try {
            FileInputStream is = new FileInputStream(fileName);
            int size = is.available();
            byte[] buffer = new byte[size];
            is.read(buffer);
            is.close();
            return new String(buffer);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"printStackTrace", (Throwable)e);
            return null;
        }
    }

    public static List<File> getSuffixFile(String filePath, String suffere) {
        ArrayList<File> files = new ArrayList<File>();
        return YYFileUtils.getSuffixFile(files, filePath, suffere);
    }

    public static List<File> getSuffixFile(List<File> files, String filePath, String suffere) {
        File[] subFiles;
        File f = new File(filePath);
        if (!f.exists()) {
            return null;
        }
        for (File subFile : subFiles = f.listFiles()) {
            if (subFile.isFile() && subFile.getName().endsWith(suffere)) {
                files.add(subFile);
                continue;
            }
            if (!subFile.isDirectory()) continue;
            YYFileUtils.getSuffixFile(files, subFile.getAbsolutePath(), suffere);
        }
        return files;
    }

    public static class IO {
        public static void mkdir(String path) {
            BasicFileUtils.ensureDirExists(path);
        }

        public static String concat(String p1, String p2) {
            return YYFileUtils.concatPath(p1, p2);
        }

        public static String concats(String ... ps) {
            return YYFileUtils.concatPaths(ps);
        }

        public static boolean exist(String f) {
            if (!FP.empty(f)) {
                try {
                    return new File(f).exists();
                }
                catch (Exception e) {
                    Log.e((String)YYFileUtils.TAG, (String)"Empty Catch on exist", (Throwable)e);
                }
            }
            return false;
        }

        public static boolean touch(String f) {
            if (IO.exist(f)) {
                return false;
            }
            if (YYFileUtils.ensureFileDirExists(f)) {
                try {
                    new File(f).createNewFile();
                }
                catch (Exception e) {
                    Log.e((String)YYFileUtils.TAG, (String)"Empty Catch on touch", (Throwable)e);
                }
            }
            return true;
        }
    }
}

