/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.menudrawer;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;

public class SlideDrawable
extends Drawable
implements Drawable.Callback {
    private Drawable mWrapped;
    private float mOffset;
    private final Rect mTmpRect = new Rect();
    private boolean mIsRtl;

    public SlideDrawable(Drawable wrapped) {
        this.mWrapped = wrapped;
    }

    public void setOffset(float offset) {
        this.mOffset = offset;
        this.invalidateSelf();
    }

    public float getOffset() {
        return this.mOffset;
    }

    void setIsRtl(boolean isRtl) {
        this.mIsRtl = isRtl;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        this.mWrapped.copyBounds(this.mTmpRect);
        canvas.save();
        if (this.mIsRtl) {
            canvas.translate(0.33333334f * (float)this.mTmpRect.width() * this.mOffset, 0.0f);
        } else {
            canvas.translate(0.33333334f * (float)this.mTmpRect.width() * -this.mOffset, 0.0f);
        }
        this.mWrapped.draw(canvas);
        canvas.restore();
    }

    public void setChangingConfigurations(int configs) {
        this.mWrapped.setChangingConfigurations(configs);
    }

    public int getChangingConfigurations() {
        return this.mWrapped.getChangingConfigurations();
    }

    public void setDither(boolean dither) {
        this.mWrapped.setDither(dither);
    }

    public void setFilterBitmap(boolean filter) {
        this.mWrapped.setFilterBitmap(filter);
    }

    public void setAlpha(int alpha) {
        this.mWrapped.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mWrapped.setColorFilter(cf);
    }

    public void setColorFilter(int color2, PorterDuff.Mode mode) {
        this.mWrapped.setColorFilter(color2, mode);
    }

    public void clearColorFilter() {
        this.mWrapped.clearColorFilter();
    }

    public boolean isStateful() {
        return this.mWrapped.isStateful();
    }

    public boolean setState(int[] stateSet) {
        return this.mWrapped.setState(stateSet);
    }

    public int[] getState() {
        return this.mWrapped.getState();
    }

    public Drawable getCurrent() {
        return this.mWrapped.getCurrent();
    }

    public boolean setVisible(boolean visible, boolean restart) {
        return super.setVisible(visible, restart);
    }

    public int getOpacity() {
        return this.mWrapped.getOpacity();
    }

    public Region getTransparentRegion() {
        return this.mWrapped.getTransparentRegion();
    }

    protected boolean onStateChange(int[] state) {
        this.mWrapped.setState(state);
        return super.onStateChange(state);
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mWrapped.setBounds(bounds);
    }

    public int getIntrinsicWidth() {
        return this.mWrapped.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.mWrapped.getIntrinsicHeight();
    }

    public int getMinimumWidth() {
        return this.mWrapped.getMinimumWidth();
    }

    public int getMinimumHeight() {
        return this.mWrapped.getMinimumHeight();
    }

    public boolean getPadding(Rect padding) {
        return this.mWrapped.getPadding(padding);
    }

    public Drawable.ConstantState getConstantState() {
        return super.getConstantState();
    }

    public void invalidateDrawable(Drawable who) {
        if (who == this.mWrapped) {
            this.invalidateSelf();
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        if (who == this.mWrapped) {
            this.scheduleSelf(what, when);
        }
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        if (who == this.mWrapped) {
            this.unscheduleSelf(what);
        }
    }
}

