/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.menudrawer;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;

class ColorDrawable
extends Drawable {
    private ColorState mState;
    private final Paint mPaint = new Paint();

    public ColorDrawable() {
        this(null);
    }

    public ColorDrawable(int color2) {
        this(null);
        this.setColor(color2);
    }

    private ColorDrawable(ColorState state) {
        this.mState = new ColorState(state);
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mState.mChangingConfigurations;
    }

    public void draw(Canvas canvas) {
        if (this.mState.mUseColor >>> 24 != 0) {
            this.mPaint.setColor(this.mState.mUseColor);
            canvas.drawRect(this.getBounds(), this.mPaint);
        }
    }

    public int getColor() {
        return this.mState.mUseColor;
    }

    public void setColor(int color2) {
        if (this.mState.mBaseColor != color2 || this.mState.mUseColor != color2) {
            this.invalidateSelf();
            this.mState.mBaseColor = this.mState.mUseColor = color2;
        }
    }

    public int getAlpha() {
        return this.mState.mUseColor >>> 24;
    }

    public void setAlpha(int alpha) {
        alpha += alpha >> 7;
        int baseAlpha = this.mState.mBaseColor >>> 24;
        int useAlpha = baseAlpha * alpha >> 8;
        int oldUseColor = this.mState.mUseColor;
        this.mState.mUseColor = this.mState.mBaseColor << 8 >>> 8 | useAlpha << 24;
        if (oldUseColor != this.mState.mUseColor) {
            this.invalidateSelf();
        }
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public int getOpacity() {
        switch (this.mState.mUseColor >>> 24) {
            case 255: {
                return -1;
            }
            case 0: {
                return -2;
            }
        }
        return -3;
    }

    public Drawable.ConstantState getConstantState() {
        this.mState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mState;
    }

    static final class ColorState
    extends Drawable.ConstantState {
        int mBaseColor;
        int mUseColor;
        int mChangingConfigurations;

        ColorState(ColorState state) {
            if (state != null) {
                this.mBaseColor = state.mBaseColor;
                this.mUseColor = state.mUseColor;
            }
        }

        public Drawable newDrawable() {
            return new ColorDrawable(this);
        }

        public Drawable newDrawable(Resources res) {
            return new ColorDrawable(this);
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }
    }
}

