/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.yy.mobile.util.log.MLog;

public class MarqueeTextView
extends TextView {
    private static final String TAG = "MarqueeTextView";
    private boolean isMarquee = true;
    private boolean isInterceptTouch = true;

    public MarqueeTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return true;
            }
        });
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        if (focused) {
            super.onFocusChanged(focused, direction, previouslyFocusedRect);
        }
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        if (hasWindowFocus) {
            super.onWindowFocusChanged(hasWindowFocus);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isInterceptTouch) {
            return super.onTouchEvent(event);
        }
        return false;
    }

    public boolean isFocused() {
        return this.isMarquee;
    }

    public void setMarquee(boolean isMarquee) {
        this.isMarquee = isMarquee;
        this.setFocusable(isMarquee);
        this.setFocusableInTouchMode(isMarquee);
        this.setHorizontallyScrolling(isMarquee);
    }

    public boolean performLongClick() {
        try {
            return super.performLongClick();
        }
        catch (Throwable throwable) {
            MLog.error(TAG, throwable);
            return false;
        }
    }

    public void setNoInterceptTouch() {
        this.isInterceptTouch = false;
    }
}

