/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import com.yy.mobile.http.BaseNetwork;
import com.yy.mobile.http.HttpLog;
import com.yy.mobile.http.ProgressInfo;
import com.yy.mobile.http.Request;
import com.yy.mobile.http.ServerError;
import com.yy.mobile.util.YYFileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import okhttp3.Response;

public class DownloadNetwork
extends BaseNetwork {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final String TMP_SURFIX = ".tmp";
    protected String mDownloadFilePath;
    protected String mDownloadFileTempPath;

    public DownloadNetwork(String downloadFilePath) {
        if (HttpLog.isDebug()) {
            HttpLog.d("Download file path " + downloadFilePath, new Object[0]);
        }
        this.mDownloadFilePath = downloadFilePath;
        this.mDownloadFileTempPath = DownloadNetwork.createTempPath(this.mDownloadFilePath);
    }

    protected static String createTempPath(String orginalPath) {
        String fileName = TMP_SURFIX;
        fileName = orginalPath.concat(fileName);
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] entityToBytes(Request<?> request, Response response) throws IOException, ServerError {
        byte[] byArray;
        int count;
        long progress;
        long total;
        int statusCode = response.code();
        if (statusCode < 200 || statusCode > 299) {
            return super.entityToBytes(request, response);
        }
        HttpLog.v("Download file tmp path " + this.mDownloadFileTempPath, new Object[0]);
        File file = new File(this.mDownloadFileTempPath);
        if (!file.exists()) {
            try {
                File tmpFile = YYFileUtils.createFile(file.getPath()).getFile();
                if (tmpFile != null) {
                    file = tmpFile;
                }
            }
            catch (Exception e) {
                HttpLog.e("Create download config error:" + this.mDownloadFileTempPath, new Object[0]);
            }
        }
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));
        byte[] buffer = new byte[4096];
        InputStream in = response.body().byteStream();
        try {
            if (in == null) {
                throw new ServerError();
            }
            total = response.body().contentLength();
            HttpLog.v("Download content length %d", total);
            progress = 0L;
            while ((count = in.read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, count);
                progress += (long)count;
                if (!request.isCanceled()) break block16;
                HttpLog.e("Download cancel.", new Object[0]);
                this.onCancel(progress);
                byArray = new byte[]{};
            }
        }
        catch (Throwable throwable) {
            try {
                in.close();
                response.body().close();
                ((OutputStream)outputStream).flush();
                ((OutputStream)outputStream).close();
            }
            catch (IOException e) {
                HttpLog.e("entity to bytes consumingContent error", e);
            }
            throw throwable;
        }
        {
            block16: {
                try {
                    in.close();
                    response.body().close();
                    ((OutputStream)outputStream).flush();
                    ((OutputStream)outputStream).close();
                }
                catch (IOException e) {
                    HttpLog.e("entity to bytes consumingContent error", e);
                }
                return byArray;
            }
            if (!this.needProgress(count, total, request, progress)) continue;
            ProgressInfo progressInfo = new ProgressInfo(progress, total);
            request.postProgress(progressInfo);
            continue;
        }
        try {
            in.close();
            response.body().close();
            ((OutputStream)outputStream).flush();
            ((OutputStream)outputStream).close();
        }
        catch (IOException e) {
            HttpLog.e("entity to bytes consumingContent error", e);
        }
        boolean renameFileReulst = file.renameTo(new File(this.mDownloadFilePath));
        HttpLog.v("File file.length() %d", file.length());
        HttpLog.v("File rename completed, result %d", renameFileReulst ? 1 : 0);
        return this.mDownloadFilePath.getBytes();
    }

    protected void onCancel(long progress) throws IOException {
        if (HttpLog.isDebug()) {
            HttpLog.d("OnCancel", new Object[0]);
        }
        this.abort();
    }
}

