/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.config;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Environment;
import com.unionyy.mobile.spdt.Spdt;
import com.yy.mobile.config.LogPathGetter;
import com.yy.mobile.http.DiskCache;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class BasicConfig {
    private static final String TAG = "BasicConfig";
    public static final int PHONE_LOW = 0;
    public static final int PHONE_MIDDLE = 1;
    public static final int PHONE_HIGH = 2;
    private Context mContext;
    private boolean isDebuggable;
    private boolean isHeatBallZipOK = false;
    private File mLogDir;
    private File mSdkLogDir;
    private File mRoot;
    private File mInternalDir;
    private File mConfigDir;
    private File mTurnTableDir;
    private File mBigGiftEffectDir;
    private File mGiftAnimationDir;
    private static BasicConfig mInstance = new BasicConfig();
    public int phoneType = 2;
    public int defaultPhoneType = -1;
    @Nullable
    private LogPathGetter pathGetter = (LogPathGetter)Spdt.ofOrNull(LogPathGetter.class);
    public final String yyMobileDir = this.pathGetter == null ? "unionyy" : this.pathGetter.getLogPath();
    private String yyLogsDir = "logs";
    private String yySdkLogsDir = "sdklog";
    public boolean isDebugPackage;
    public boolean isBuildDebug;
    public String appId;
    BroadcastReceiver mExternalStorageReceiver;
    boolean mExternalStorageAvailable = false;
    boolean mExternalStorageWriteable = false;
    private volatile boolean mExternalStorageChecked = false;

    public void setIsHeatBallZipOK(boolean isZipOK) {
        this.isHeatBallZipOK = isZipOK;
    }

    public boolean getIsHeatBallZipOK() {
        return this.isHeatBallZipOK;
    }

    public void setPhoneType(int phoneType) {
        this.phoneType = phoneType;
        if (this.defaultPhoneType == -1) {
            this.defaultPhoneType = phoneType;
        }
    }

    public void resetPhoneType() {
        this.phoneType = this.defaultPhoneType == -1 ? 0 : this.defaultPhoneType;
    }

    public static BasicConfig getInstance() {
        return mInstance;
    }

    public void setAppContext(Context context) {
        this.mContext = context;
        this.setDebuggable();
    }

    public Context getAppContext() {
        return this.mContext;
    }

    public boolean isDebuggable() {
        return this.isDebuggable;
    }

    public Context getSPContextWrapper() {
        return this.mContext;
    }

    private void updateDebuggableFlag() {
        ApplicationInfo appInfo = null;
        PackageManager packMgmr = this.mContext.getPackageManager();
        try {
            appInfo = packMgmr.getApplicationInfo(this.mContext.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            MLog.error(TAG, e);
        }
        if (appInfo != null) {
            this.setDebuggable((appInfo.flags & 2) > 0);
        }
    }

    private void setDebuggable() {
        this.updateDebuggableFlag();
    }

    public void setDebuggable(boolean debuggable) {
        MLog.info(TAG, "setDebuggable debuggable : " + debuggable, new Object[0]);
        this.isDebuggable = debuggable;
    }

    public void setRootDir(String rootDir) {
        File f = DiskCache.getCacheDir(this.mContext, this.yyMobileDir);
        if (!f.exists()) {
            f.mkdirs();
        }
        this.mRoot = f;
    }

    public File getRootDir() {
        return this.mRoot;
    }

    public void setConfigDir(String dir) {
        try {
            this.mConfigDir = DiskCache.getCacheDir(this.mContext, dir);
            if (!this.mConfigDir.exists() && !this.mConfigDir.mkdirs()) {
                MLog.error((Object)TAG, "Can't create config dir " + this.mConfigDir, new Object[0]);
                return;
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "Set config dir error", e, new Object[0]);
        }
    }

    public File getConfigDir() {
        return this.mConfigDir;
    }

    public void setLogDir() {
        try {
            if (this.mLogDir != null && this.mLogDir.exists()) {
                MLog.info(TAG, "log dir " + this.mLogDir.getAbsolutePath(), new Object[0]);
                return;
            }
            File cacheDirectory = DiskCache.getCacheDir(this.mContext, this.yyMobileDir);
            if (!cacheDirectory.exists()) {
                cacheDirectory.mkdirs();
            }
            if (cacheDirectory.exists()) {
                this.mLogDir = new File(cacheDirectory.getAbsolutePath() + File.separator + this.yyLogsDir);
                if (!this.mLogDir.exists() && !this.mLogDir.mkdirs()) {
                    MLog.error((Object)TAG, "Can't create log dir ", new Object[0]);
                }
            }
            if (this.mLogDir.exists() && !this.mLogDir.canWrite()) {
                cacheDirectory = DiskCache.getCacheDir(this.mContext, true, this.yyMobileDir);
                if (!cacheDirectory.exists()) {
                    cacheDirectory.mkdirs();
                }
                if (cacheDirectory.exists()) {
                    this.mLogDir = new File(cacheDirectory.getAbsolutePath() + File.separator + this.yyLogsDir);
                    if (!this.mLogDir.exists() && !this.mLogDir.mkdirs()) {
                        MLog.error((Object)TAG, "Can't create log dir ", new Object[0]);
                    }
                }
            }
            MLog.info(TAG, "create mLogDir dir " + this.mLogDir, new Object[0]);
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "Set log dir error", e, new Object[0]);
        }
    }

    private File getLogDir() {
        try {
            if (this.mLogDir == null) {
                this.setLogDir();
            }
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "getLogDir log dir error", e, new Object[0]);
        }
        return this.mLogDir;
    }

    public String getLogDirPath() {
        File logDir = this.getLogDir();
        if (logDir == null || FP.empty(logDir.getAbsolutePath())) {
            return "/storage/emulated/0/" + this.yyMobileDir + "/" + this.yyLogsDir;
        }
        return logDir.getAbsolutePath();
    }

    public void setSDKLogDir() {
        try {
            if (this.mSdkLogDir != null && this.mSdkLogDir.exists()) {
                MLog.info(TAG, "mSdkLogDir dir " + this.mSdkLogDir.getAbsolutePath(), new Object[0]);
                return;
            }
            File logDirFile = this.getLogDir();
            this.mSdkLogDir = new File(logDirFile + File.separator + this.yySdkLogsDir);
            if (!this.mSdkLogDir.exists() && !this.mSdkLogDir.mkdirs()) {
                MLog.error((Object)TAG, "Can't create log dir ", new Object[0]);
            }
            MLog.info(TAG, "create mSdkLogDir dir " + this.mSdkLogDir, new Object[0]);
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "Set log dir error", e, new Object[0]);
        }
    }

    private File getSDKLogDir() {
        try {
            if (this.mSdkLogDir == null) {
                this.setSDKLogDir();
            }
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "getLogDir log dir error", e, new Object[0]);
        }
        return this.mSdkLogDir;
    }

    public String getSDKLogDirPath() {
        File sdkLogDir = this.getSDKLogDir();
        if (sdkLogDir == null || FP.empty(sdkLogDir.getAbsolutePath())) {
            return "/storage/emulated/0/" + this.yyMobileDir + "/" + this.yyLogsDir + "/" + this.yySdkLogsDir;
        }
        return sdkLogDir.getAbsolutePath();
    }

    public void setTurnTableDir(String dir) {
        try {
            this.mTurnTableDir = DiskCache.getCacheDir(this.mContext, dir);
            if (!this.mTurnTableDir.exists() && !this.mTurnTableDir.mkdirs()) {
                MLog.error((Object)TAG, "Can't create turntable dir " + this.mTurnTableDir, new Object[0]);
                return;
            }
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "Set turntable dir error", e, new Object[0]);
        }
    }

    public File getTurnTableDir() {
        return this.mTurnTableDir;
    }

    public void setBigGiftEffectDir(String dir) {
        try {
            this.mBigGiftEffectDir = DiskCache.getCacheDir(this.mContext, dir);
            if (!this.mBigGiftEffectDir.exists() && !this.mBigGiftEffectDir.mkdirs()) {
                MLog.error((Object)TAG, "Can't create turntable dir " + this.mBigGiftEffectDir, new Object[0]);
                return;
            }
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "Set turntable dir error", e, new Object[0]);
        }
    }

    public File getBigGiftEffectDir() {
        return this.mBigGiftEffectDir;
    }

    public void setGiftAnimationDir(String dir) {
        try {
            this.mGiftAnimationDir = DiskCache.getCacheDir(this.mContext, dir);
            if (!this.mGiftAnimationDir.exists() && !this.mGiftAnimationDir.mkdirs()) {
                MLog.error((Object)TAG, "Can't create turntable dir " + this.mGiftAnimationDir, new Object[0]);
                return;
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "Set turntable dir error", e, new Object[0]);
        }
    }

    public File getGiftAnimationDir() {
        return this.mGiftAnimationDir;
    }

    public File getInternalDir(String dir) {
        if (this.mInternalDir != null && this.mInternalDir.getAbsolutePath().endsWith(dir)) {
            return this.mInternalDir;
        }
        try {
            this.mInternalDir = DiskCache.getCacheDir(this.mContext, true, dir);
            if (!this.mInternalDir.exists() && !this.mInternalDir.mkdirs()) {
                MLog.error((Object)TAG, "Can't create turntable dir " + this.mInternalDir, new Object[0]);
                return this.mInternalDir;
            }
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "Set Internal dir error", e, new Object[0]);
        }
        return this.mInternalDir;
    }

    public boolean isExternalStorageAvailable() {
        this.startExternalState();
        return this.mExternalStorageAvailable;
    }

    public boolean isExternalStorageWriteable() {
        this.startExternalState();
        return this.mExternalStorageWriteable;
    }

    public synchronized void startExternalState() {
        if (!this.mExternalStorageChecked) {
            this.updateExternalStorageState();
            this.startWatchingExternalStorage();
            this.mExternalStorageChecked = true;
        }
    }

    public synchronized void updateExternalStorageState() {
        String state = Environment.getExternalStorageState();
        if ("mounted".equals(state)) {
            this.mExternalStorageWriteable = true;
            this.mExternalStorageAvailable = true;
        } else if ("mounted_ro".equals(state)) {
            this.mExternalStorageAvailable = true;
            this.mExternalStorageWriteable = false;
        } else {
            this.mExternalStorageWriteable = false;
            this.mExternalStorageAvailable = false;
        }
    }

    public synchronized void startWatchingExternalStorage() {
        if (this.mContext == null) {
            MLog.error((Object)TAG, "mContext null when startWatchingExternalStorage", new Object[0]);
            return;
        }
        this.mExternalStorageReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                MLog.info("ExternalStorageReceiver", "Storage: " + intent.getData(), new Object[0]);
                BasicConfig.this.updateExternalStorageState();
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.MEDIA_MOUNTED");
        filter.addAction("android.intent.action.MEDIA_REMOVED");
        try {
            this.mContext.registerReceiver(this.mExternalStorageReceiver, filter);
        }
        catch (Exception e) {
            this.mExternalStorageReceiver = null;
        }
    }

    public synchronized void stopWatchingExternalStorage() {
        if (this.mContext == null) {
            MLog.error((Object)TAG, "mContext null when stopWatchingExternalStorage", new Object[0]);
            return;
        }
        if (this.mExternalStorageReceiver != null) {
            this.mContext.unregisterReceiver(this.mExternalStorageReceiver);
        }
    }
}

