/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.stickyListHeaders;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.widget.AbsListView;
import android.widget.ListView;
import com.yy.mobile.ui.widget.stickyListHeaders.WrapperView;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

class WrapperViewList
extends ListView {
    private LifeCycleListener mLifeCycleListener;
    private List<View> mFooterViews;
    private int mTopClippingLength;
    private Rect mSelectorRect = new Rect();
    private Field mSelectorPositionField;
    private boolean mClippingToPadding = true;

    public WrapperViewList(Context context) {
        super(context);
        try {
            Field selectorRectField = AbsListView.class.getDeclaredField("mSelectorRect");
            selectorRectField.setAccessible(true);
            this.mSelectorRect = (Rect)selectorRectField.get((Object)this);
            if (Build.VERSION.SDK_INT >= 14) {
                this.mSelectorPositionField = AbsListView.class.getDeclaredField("mSelectorPosition");
                this.mSelectorPositionField.setAccessible(true);
            }
        }
        catch (NoSuchFieldException e) {
            Log.e((String)"WrapperViewList", (String)"printStackTrace", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)"WrapperViewList", (String)"printStackTrace", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.e((String)"WrapperViewList", (String)"printStackTrace", (Throwable)e);
        }
    }

    public boolean performItemClick(View view, int position, long id2) {
        if (view instanceof WrapperView) {
            view = ((WrapperView)view).mItem;
        }
        return super.performItemClick(view, position, id2);
    }

    private void positionSelectorRect() {
        int firstVisibleItem;
        View v;
        int selectorPosition;
        if (!this.mSelectorRect.isEmpty() && (selectorPosition = this.getSelectorPosition()) >= 0 && (v = this.getChildAt(selectorPosition - (firstVisibleItem = this.getFixedFirstVisibleItem()))) instanceof WrapperView) {
            WrapperView wrapper = (WrapperView)v;
            this.mSelectorRect.top = wrapper.getTop() + wrapper.mItemTop;
        }
    }

    private int getSelectorPosition() {
        if (this.mSelectorPositionField == null) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                if (this.getChildAt(i).getBottom() != this.mSelectorRect.bottom) continue;
                return i + this.getFixedFirstVisibleItem();
            }
        } else {
            try {
                return this.mSelectorPositionField.getInt((Object)this);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)"WrapperViewList", (String)"printStackTrace", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                Log.e((String)"WrapperViewList", (String)"printStackTrace", (Throwable)e);
            }
        }
        return -1;
    }

    protected void dispatchDraw(Canvas canvas) {
        this.positionSelectorRect();
        if (this.mTopClippingLength != 0) {
            canvas.save();
            Rect clipping = canvas.getClipBounds();
            clipping.top = this.mTopClippingLength;
            canvas.clipRect(clipping);
            super.dispatchDraw(canvas);
            canvas.restore();
        } else {
            super.dispatchDraw(canvas);
        }
        this.mLifeCycleListener.onDispatchDrawOccurred(canvas);
    }

    void setLifeCycleListener(LifeCycleListener lifeCycleListener) {
        this.mLifeCycleListener = lifeCycleListener;
    }

    public void addFooterView(View v) {
        super.addFooterView(v);
        if (this.mFooterViews == null) {
            this.mFooterViews = new ArrayList<View>();
        }
        this.mFooterViews.add(v);
    }

    public boolean removeFooterView(View v) {
        if (super.removeFooterView(v)) {
            this.mFooterViews.remove(v);
            return true;
        }
        return false;
    }

    boolean containsFooterView(View v) {
        if (this.mFooterViews == null) {
            return false;
        }
        return this.mFooterViews.contains(v);
    }

    void setTopClippingLength(int topClipping) {
        this.mTopClippingLength = topClipping;
    }

    int getFixedFirstVisibleItem() {
        int firstVisibleItem = this.getFirstVisiblePosition();
        if (Build.VERSION.SDK_INT >= 11) {
            return firstVisibleItem;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (this.getChildAt(i).getBottom() < 0) continue;
            firstVisibleItem += i;
            break;
        }
        if (!this.mClippingToPadding && this.getPaddingTop() > 0 && firstVisibleItem > 0 && this.getChildAt(0).getTop() > 0) {
            --firstVisibleItem;
        }
        return firstVisibleItem;
    }

    public void setClipToPadding(boolean clipToPadding) {
        this.mClippingToPadding = clipToPadding;
        super.setClipToPadding(clipToPadding);
    }

    static interface LifeCycleListener {
        public void onDispatchDrawOccurred(Canvas var1);
    }
}

