/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.arclayout;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.yy.mobile.framework.R;

public class ArcLayoutSettings {
    public static final int CROP_INSIDE = 1;
    public static final int CROP_OUTSIDE = 2;
    private boolean cropInside = true;
    private float arcHeight;
    private float elevation;
    private float arcCorner;

    private static float dpToPx(Context context, int dp) {
        Resources r = context.getResources();
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)r.getDisplayMetrics());
    }

    ArcLayoutSettings(Context context, AttributeSet attrs) {
        TypedArray styledAttributes = context.obtainStyledAttributes(attrs, R.styleable.ArcHeader, 0, 0);
        this.arcHeight = styledAttributes.getDimension(R.styleable.ArcHeader_arc_height, ArcLayoutSettings.dpToPx(context, 10));
        this.arcCorner = styledAttributes.getDimension(R.styleable.ArcHeader_arc_corner, ArcLayoutSettings.dpToPx(context, 10));
        int cropDirection = styledAttributes.getInt(R.styleable.ArcHeader_arc_cropDirection, 1);
        this.cropInside = (cropDirection & 1) == 1;
        styledAttributes.recycle();
    }

    public float getElevation() {
        return this.elevation;
    }

    public void setElevation(float elevation) {
        this.elevation = elevation;
    }

    public boolean isCropInside() {
        return this.cropInside;
    }

    public float getArcHeight() {
        return this.arcHeight;
    }

    public void setArcHeight(float arcHeight) {
        this.arcHeight = arcHeight;
    }

    public void setArcCorner(float arcCorner) {
        this.arcCorner = arcCorner;
    }

    public float getArcCorner() {
        return this.arcCorner;
    }
}

